/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.chat.controller;

import de.justsoftware.chat.application.ChatApplicationService;
import de.justsoftware.chat.application.ChatMessageApplicationService;
import de.justsoftware.chat.application.ChatParticipantApplicationService;
import de.justsoftware.chat.application.model.AppPermissionsDto;
import de.justsoftware.chat.application.model.ChatDto;
import de.justsoftware.chat.application.model.ChatMessageAttachmentDto;
import de.justsoftware.chat.application.model.ChatMessageDto;
import de.justsoftware.chat.application.model.CreateChatDto;
import de.justsoftware.chat.application.model.ParticipantDto;
import de.justsoftware.chat.application.model.SaveChatMessageDto;
import de.justsoftware.chat.application.model.SavePersonMentionDto;
import de.justsoftware.chat.authorization.AuthorizationContext;
import de.justsoftware.chat.business.LoadDirection;
import de.justsoftware.chat.business.model.AttachmentFilter;
import de.justsoftware.chat.controller.ChatController;
import de.justsoftware.chat.exception.ValidationException;
import de.justsoftware.chat.model.ChatId;
import de.justsoftware.chat.model.ChatMessageId;
import de.justsoftware.chat.model.ParticipantId;
import de.justsoftware.chat.model.PermissionType;
import de.justsoftware.chat.model.ProfileId;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.data.domain.Page;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/api/chats"})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00d2\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0011\u0018\u00002\u00020\u0001:\u0001YB\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ*\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\b\b\u0001\u0010\r\u001a\u00020\u000e2\b\b\u0001\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0017J\u0010\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0017J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\u0011H\u0017J\u001a\u0010\u0015\u001a\u00020\f2\b\b\u0001\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0010\u001a\u00020\u0011H\u0017J2\u0010\u0018\u001a\u0004\u0018\u00010\f2\b\b\u0001\u0010\u0016\u001a\u00020\u00172\b\b\u0001\u0010\u0019\u001a\u00020\u001a2\n\b\u0001\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u0010\u001a\u00020\u0011H\u0017J\u001a\u0010\u001d\u001a\u00020\f2\b\b\u0001\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0017J\u001a\u0010 \u001a\u00020!2\b\b\u0001\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0010\u001a\u00020\u0011H\u0017J\u001a\u0010\"\u001a\u00020!2\b\b\u0001\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0010\u001a\u00020\u0011H\u0017J$\u0010#\u001a\u00020$2\b\b\u0001\u0010\u0016\u001a\u00020\u00172\b\b\u0001\u0010%\u001a\u00020$2\u0006\u0010\u0010\u001a\u00020\u0011H\u0017J\u001a\u0010&\u001a\u00020!2\b\b\u0001\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0010\u001a\u00020\u0011H\u0017J\u001c\u0010'\u001a\u0004\u0018\u00010$2\b\b\u0001\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0010\u001a\u00020\u0011H\u0017J\u001a\u0010(\u001a\u00020!2\b\b\u0001\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0010\u001a\u00020\u0011H\u0017J\u001a\u0010)\u001a\u00020!2\b\b\u0001\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0010\u001a\u00020\u0011H\u0017J$\u0010*\u001a\u00020\f2\b\b\u0001\u0010\u0016\u001a\u00020\u00172\b\b\u0001\u0010+\u001a\u00020,2\u0006\u0010\u0010\u001a\u00020\u0011H\u0017J[\u0010-\u001a\b\u0012\u0004\u0012\u00020.0\u000b2\b\b\u0001\u0010\u0016\u001a\u00020\u00172\n\b\u0001\u0010/\u001a\u0004\u0018\u0001002\n\b\u0001\u00101\u001a\u0004\u0018\u0001022\b\b\u0001\u00103\u001a\u00020\u000e2\b\b\u0001\u00104\u001a\u0002052\b\b\u0001\u00106\u001a\u0002072\u0006\u0010\u0010\u001a\u00020\u0011H\u0017\u00a2\u0006\u0002\u00108J$\u00109\u001a\u00020.2\b\b\u0001\u0010\u0016\u001a\u00020\u00172\b\b\u0001\u0010:\u001a\u0002022\u0006\u0010\u0010\u001a\u00020\u0011H\u0017J\u001a\u0010;\u001a\u00020!2\b\b\u0001\u0010:\u001a\u0002022\u0006\u0010\u0010\u001a\u00020\u0011H\u0017J.\u0010<\u001a\u00020.2\b\b\u0001\u0010\u0016\u001a\u00020\u00172\b\b\u0001\u0010:\u001a\u0002022\b\b\u0001\u0010=\u001a\u00020,2\u0006\u0010\u0010\u001a\u00020\u0011H\u0017J$\u0010>\u001a\u00020.2\b\b\u0001\u0010\u0016\u001a\u00020\u00172\b\b\u0001\u0010:\u001a\u0002022\u0006\u0010\u0010\u001a\u00020\u0011H\u0017J$\u0010?\u001a\u00020.2\b\b\u0001\u0010:\u001a\u0002022\b\b\u0001\u0010@\u001a\u00020A2\u0006\u0010\u0010\u001a\u00020\u0011H\u0017J`\u0010B\u001a\u00020.2\b\b\u0001\u0010\u0016\u001a\u00020\u00172\b\b\u0001\u0010C\u001a\u0002022\n\b\u0001\u0010D\u001a\u0004\u0018\u00010,2\n\b\u0001\u0010E\u001a\u0004\u0018\u0001022\u0010\b\u0001\u0010F\u001a\n\u0012\u0004\u0012\u00020\u001c\u0018\u00010G2\u0010\b\u0001\u0010H\u001a\n\u0012\u0004\u0012\u00020I\u0018\u00010G2\u0006\u0010\u0010\u001a\u00020\u0011H\u0017J \u0010J\u001a\b\u0012\u0004\u0012\u00020L0K2\b\b\u0001\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0010\u001a\u00020\u0011H\u0017J6\u0010M\u001a\b\u0012\u0004\u0012\u00020L0K2\b\b\u0001\u0010\u0016\u001a\u00020\u00172\u0014\b\u0001\u0010N\u001a\u000e\u0012\u0004\u0012\u00020P\u0012\u0004\u0012\u00020Q0O2\u0006\u0010\u0010\u001a\u00020\u0011H\u0017J\u001a\u0010R\u001a\u00020!2\b\b\u0001\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0010\u001a\u00020\u0011H\u0017J>\u0010S\u001a\b\u0012\u0004\u0012\u00020T0\u000b2\b\b\u0001\u0010\u0016\u001a\u00020\u00172\b\b\u0001\u0010\r\u001a\u00020\u000e2\b\b\u0001\u0010\u000f\u001a\u00020\u000e2\b\b\u0001\u0010U\u001a\u00020V2\u0006\u0010\u0010\u001a\u00020\u0011H\u0017J$\u0010W\u001a\u00020\f2\b\b\u0001\u0010\u0016\u001a\u00020\u00172\b\b\u0001\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0010\u001a\u00020\u0011H\u0017J\u001a\u0010X\u001a\u00020\f2\b\b\u0001\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0010\u001a\u00020\u0011H\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006Z"}, d2={"Lde/justsoftware/chat/controller/ChatController;", "", "chatApplicationService", "Lde/justsoftware/chat/application/ChatApplicationService;", "chatParticipantApplicationService", "Lde/justsoftware/chat/application/ChatParticipantApplicationService;", "chatMessageApplicationService", "Lde/justsoftware/chat/application/ChatMessageApplicationService;", "<init>", "(Lde/justsoftware/chat/application/ChatApplicationService;Lde/justsoftware/chat/application/ChatParticipantApplicationService;Lde/justsoftware/chat/application/ChatMessageApplicationService;)V", "getRecentChats", "Lorg/springframework/data/domain/Page;", "Lde/justsoftware/chat/application/model/ChatDto;", "page", "", "pageSize", "authContext", "Lde/justsoftware/chat/authorization/AuthorizationContext;", "getUnreadMessageCount", "getAppPermissions", "Lde/justsoftware/chat/application/model/AppPermissionsDto;", "getChat", "chatId", "Lde/justsoftware/chat/model/ChatId;", "createChat", "createChatDto", "Lde/justsoftware/chat/application/model/CreateChatDto;", "icon", "Lorg/springframework/web/multipart/MultipartFile;", "getOrCreateOneOnOneChat", "profileId", "Lde/justsoftware/chat/model/ProfileId;", "deleteChat", "", "leaveChat", "markChatAsRead", "Ljava/time/Instant;", "readDate", "markChatAsUnread", "getReadDate", "muteChat", "unmuteChat", "updateUserGroupChatTitle", "title", "", "getMessages", "Lde/justsoftware/chat/application/model/ChatMessageDto;", "offsetMilliSeconds", "", "offsetMessageId", "Lde/justsoftware/chat/model/ChatMessageId;", "limit", "direction", "Lde/justsoftware/chat/business/LoadDirection;", "includeOffsetMessage", "", "(Lde/justsoftware/chat/model/ChatId;Ljava/lang/Long;Lde/justsoftware/chat/model/ChatMessageId;ILde/justsoftware/chat/business/LoadDirection;ZLde/justsoftware/chat/authorization/AuthorizationContext;)Lorg/springframework/data/domain/Page;", "getChatMessage", "chatMessageId", "deleteChatMessage", "reactToChatMessage", "reaction", "deleteReaction", "editChatMessage", "chatMessageEdit", "Lde/justsoftware/chat/controller/ChatController$ChatMessageEdit;", "createChatMessage", "id", "message", "citedMessageId", "attachments", "", "savePersonMentionDtos", "Lde/justsoftware/chat/application/model/SavePersonMentionDto;", "getChatParticipants", "", "Lde/justsoftware/chat/application/model/ParticipantDto;", "setChatParticipants", "participants", "", "Lde/justsoftware/chat/model/ParticipantId;", "Lde/justsoftware/chat/model/PermissionType;", "restoreChat", "getAttachments", "Lde/justsoftware/chat/application/model/ChatMessageAttachmentDto;", "attachmentFilter", "Lde/justsoftware/chat/business/model/AttachmentFilter;", "updateChatIcon", "deleteChatIcon", "ChatMessageEdit", "chat-service"})
@SourceDebugExtension(value={"SMAP\nChatController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChatController.kt\nde/justsoftware/chat/controller/ChatController\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,264:1\n1#2:265\n*E\n"})
public class ChatController {
    @NotNull
    private final ChatApplicationService chatApplicationService;
    @NotNull
    private final ChatParticipantApplicationService chatParticipantApplicationService;
    @NotNull
    private final ChatMessageApplicationService chatMessageApplicationService;

    public ChatController(@NotNull ChatApplicationService chatApplicationService, @NotNull ChatParticipantApplicationService chatParticipantApplicationService, @NotNull ChatMessageApplicationService chatMessageApplicationService) {
        Intrinsics.checkNotNullParameter((Object)chatApplicationService, (String)"chatApplicationService");
        Intrinsics.checkNotNullParameter((Object)chatParticipantApplicationService, (String)"chatParticipantApplicationService");
        Intrinsics.checkNotNullParameter((Object)chatMessageApplicationService, (String)"chatMessageApplicationService");
        this.chatApplicationService = chatApplicationService;
        this.chatParticipantApplicationService = chatParticipantApplicationService;
        this.chatMessageApplicationService = chatMessageApplicationService;
    }

    @GetMapping(value={"/"})
    @NotNull
    public Page<ChatDto> getRecentChats(@RequestParam(value="page", required=false, defaultValue="0") int page, @RequestParam(value="pageSize", required=false, defaultValue="30") int pageSize, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.chatApplicationService.getRecentChats(page, pageSize, authContext);
    }

    @GetMapping(value={"/unreadMessageCount"})
    public int getUnreadMessageCount(@NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.chatApplicationService.getUnreadMessageCount(authContext);
    }

    @GetMapping(value={"/appPermissions"})
    @NotNull
    public AppPermissionsDto getAppPermissions(@NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.chatApplicationService.getAppPermissions(authContext);
    }

    @GetMapping(value={"/{chatId}"})
    @NotNull
    public ChatDto getChat(@PathVariable(value="chatId") @NotNull ChatId chatId, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)chatId, (String)"chatId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.chatApplicationService.getChat(chatId, authContext);
    }

    @PostMapping(value={"/{chatId}"})
    @Nullable
    public ChatDto createChat(@PathVariable(value="chatId") @NotNull ChatId chatId, @RequestPart(value="chat", required=true) @NotNull CreateChatDto createChatDto, @RequestParam(value="icon", required=false) @Nullable MultipartFile icon, @NotNull AuthorizationContext authContext) throws ValidationException {
        Intrinsics.checkNotNullParameter((Object)chatId, (String)"chatId");
        Intrinsics.checkNotNullParameter((Object)createChatDto, (String)"createChatDto");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.chatApplicationService.createChat(chatId, createChatDto, icon, authContext);
    }

    @GetMapping(value={"/oneOnOne/{profileId}"})
    @NotNull
    public ChatDto getOrCreateOneOnOneChat(@PathVariable(value="profileId") @NotNull ProfileId profileId, @NotNull AuthorizationContext authContext) throws ValidationException {
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.chatApplicationService.getOrCreateOneOnOneChat(profileId, authContext);
    }

    @DeleteMapping(value={"/{chatId}"})
    public void deleteChat(@PathVariable(value="chatId") @NotNull ChatId chatId, @NotNull AuthorizationContext authContext) throws ValidationException {
        Intrinsics.checkNotNullParameter((Object)chatId, (String)"chatId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        this.chatApplicationService.deleteChat(chatId, authContext);
    }

    @DeleteMapping(value={"/{chatId}/leave"})
    public void leaveChat(@PathVariable(value="chatId") @NotNull ChatId chatId, @NotNull AuthorizationContext authContext) throws ValidationException {
        Intrinsics.checkNotNullParameter((Object)chatId, (String)"chatId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        this.chatParticipantApplicationService.leaveChat(chatId, authContext);
    }

    @PostMapping(value={"/{chatId}/markAsRead"})
    @NotNull
    public Instant markChatAsRead(@PathVariable(value="chatId") @NotNull ChatId chatId, @RequestBody @NotNull Instant readDate, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)chatId, (String)"chatId");
        Intrinsics.checkNotNullParameter((Object)readDate, (String)"readDate");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.chatApplicationService.markChatAsRead(chatId, authContext, readDate);
    }

    @PostMapping(value={"/{chatId}/markAsUnread"})
    public void markChatAsUnread(@PathVariable(value="chatId") @NotNull ChatId chatId, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)chatId, (String)"chatId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        this.chatApplicationService.markChatAsUnread(chatId, authContext);
    }

    @GetMapping(value={"/{chatId}/readDate"})
    @Nullable
    public Instant getReadDate(@PathVariable(value="chatId") @NotNull ChatId chatId, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)chatId, (String)"chatId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.chatApplicationService.getReadDate(chatId, authContext);
    }

    @PostMapping(value={"/{chatId}/settings/mute"})
    public void muteChat(@PathVariable(value="chatId") @NotNull ChatId chatId, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)chatId, (String)"chatId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        this.chatApplicationService.muteChat(true, chatId, authContext);
    }

    @PostMapping(value={"/{chatId}/settings/unmute"})
    public void unmuteChat(@PathVariable(value="chatId") @NotNull ChatId chatId, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)chatId, (String)"chatId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        this.chatApplicationService.muteChat(false, chatId, authContext);
    }

    @PutMapping(value={"/{chatId}"})
    @NotNull
    public ChatDto updateUserGroupChatTitle(@PathVariable(value="chatId") @NotNull ChatId chatId, @RequestParam(value="title") @NotNull String title, @NotNull AuthorizationContext authContext) throws ValidationException {
        Intrinsics.checkNotNullParameter((Object)chatId, (String)"chatId");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.chatApplicationService.updateUserGroupChatTitle(chatId, title, authContext);
    }

    /*
     * WARNING - void declaration
     */
    @GetMapping(value={"/{chatId}/messages"})
    @NotNull
    public Page<ChatMessageDto> getMessages(@PathVariable(value="chatId") @NotNull ChatId chatId, @RequestParam(value="offsetMilliSeconds", required=false) @Nullable Long offsetMilliSeconds, @RequestParam(value="offsetMessageId", required=false) @Nullable ChatMessageId offsetMessageId, @RequestParam(value="limit", required=false, defaultValue="30") int limit, @RequestParam(value="direction", required=false, defaultValue="OLDER") @NotNull LoadDirection direction, @RequestParam(value="includeOffsetMessage", required=false, defaultValue="false") boolean includeOffsetMessage, @NotNull AuthorizationContext authContext) {
        Instant instant;
        Intrinsics.checkNotNullParameter((Object)chatId, (String)"chatId");
        Intrinsics.checkNotNullParameter((Object)direction, (String)"direction");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        ChatMessageApplicationService chatMessageApplicationService = this.chatMessageApplicationService;
        ChatId chatId2 = chatId;
        Long l = offsetMilliSeconds;
        if (l != null) {
            void it;
            long l2 = ((Number)l).longValue();
            ChatId chatId3 = chatId2;
            ChatMessageApplicationService chatMessageApplicationService2 = chatMessageApplicationService;
            boolean bl = false;
            Instant instant2 = Instant.ofEpochMilli((long)it);
            chatMessageApplicationService = chatMessageApplicationService2;
            chatId2 = chatId3;
            instant = instant2;
        } else {
            instant = null;
        }
        return chatMessageApplicationService.getMessages(chatId2, instant, offsetMessageId, limit, direction, includeOffsetMessage, authContext);
    }

    @GetMapping(value={"/{chatId}/messages/{chatMessageId}"})
    @NotNull
    public ChatMessageDto getChatMessage(@PathVariable(value="chatId") @NotNull ChatId chatId, @PathVariable(value="chatMessageId") @NotNull ChatMessageId chatMessageId, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)chatId, (String)"chatId");
        Intrinsics.checkNotNullParameter((Object)chatMessageId, (String)"chatMessageId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.chatMessageApplicationService.getChatMessage(chatId, chatMessageId, authContext, true);
    }

    @DeleteMapping(value={"/{chatId}/messages/{chatMessageId}"})
    public void deleteChatMessage(@PathVariable(value="chatMessageId") @NotNull ChatMessageId chatMessageId, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)chatMessageId, (String)"chatMessageId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        this.chatMessageApplicationService.deleteChatMessage(chatMessageId, authContext);
    }

    @PutMapping(value={"/{chatId}/messages/{chatMessageId}/react"})
    @NotNull
    public ChatMessageDto reactToChatMessage(@PathVariable(value="chatId") @NotNull ChatId chatId, @PathVariable(value="chatMessageId") @NotNull ChatMessageId chatMessageId, @RequestParam(value="reaction", required=true) @NotNull String reaction, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)chatId, (String)"chatId");
        Intrinsics.checkNotNullParameter((Object)chatMessageId, (String)"chatMessageId");
        Intrinsics.checkNotNullParameter((Object)reaction, (String)"reaction");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.chatMessageApplicationService.react(chatId, chatMessageId, reaction, authContext);
    }

    @DeleteMapping(value={"/{chatId}/messages/{chatMessageId}/react"})
    @NotNull
    public ChatMessageDto deleteReaction(@PathVariable(value="chatId") @NotNull ChatId chatId, @PathVariable(value="chatMessageId") @NotNull ChatMessageId chatMessageId, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)chatId, (String)"chatId");
        Intrinsics.checkNotNullParameter((Object)chatMessageId, (String)"chatMessageId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.chatMessageApplicationService.deleteReaction(chatId, chatMessageId, authContext);
    }

    @PutMapping(value={"/{chatId}/messages/{chatMessageId}"})
    @NotNull
    public ChatMessageDto editChatMessage(@PathVariable(value="chatMessageId") @NotNull ChatMessageId chatMessageId, @RequestBody @NotNull ChatMessageEdit chatMessageEdit, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)chatMessageId, (String)"chatMessageId");
        Intrinsics.checkNotNullParameter((Object)chatMessageEdit, (String)"chatMessageEdit");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.chatMessageApplicationService.edit(chatMessageId, chatMessageEdit.getNewMessageText(), chatMessageEdit.getNewPersonMentions(), authContext);
    }

    @PostMapping(value={"/{chatId}/messages"})
    @NotNull
    public ChatMessageDto createChatMessage(@PathVariable(value="chatId") @NotNull ChatId chatId, @RequestParam(value="id") @NotNull ChatMessageId id, @RequestParam(value="message", required=false) @Nullable String message, @RequestParam(value="citedMessageId", required=false) @Nullable ChatMessageId citedMessageId, @RequestParam(value="attachments", required=false) @Nullable List<? extends MultipartFile> attachments, @RequestPart(value="personMentions", required=false) @Nullable List<SavePersonMentionDto> savePersonMentionDtos, @NotNull AuthorizationContext authContext) {
        List list;
        Intrinsics.checkNotNullParameter((Object)chatId, (String)"chatId");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        SaveChatMessageDto saveChatMessageDto = new SaveChatMessageDto(id, message, citedMessageId);
        List list2 = attachments;
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        if ((list = savePersonMentionDtos) == null) {
            list = CollectionsKt.emptyList();
        }
        return this.chatMessageApplicationService.createChatMessage(chatId, saveChatMessageDto, list2, list, authContext);
    }

    @GetMapping(value={"/{chatId}/participants"})
    @NotNull
    public Set<ParticipantDto> getChatParticipants(@PathVariable(value="chatId") @NotNull ChatId chatId, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)chatId, (String)"chatId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.chatParticipantApplicationService.getParticipants(chatId, authContext);
    }

    @PutMapping(value={"/{chatId}/participants"})
    @NotNull
    public Set<ParticipantDto> setChatParticipants(@PathVariable(value="chatId") @NotNull ChatId chatId, @RequestBody @NotNull Map<ParticipantId, ? extends PermissionType> participants, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)chatId, (String)"chatId");
        Intrinsics.checkNotNullParameter(participants, (String)"participants");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.chatParticipantApplicationService.setParticipants(chatId, participants, authContext);
    }

    @GetMapping(value={"/{chatId}/restore"})
    public void restoreChat(@PathVariable(value="chatId") @NotNull ChatId chatId, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)chatId, (String)"chatId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        this.chatApplicationService.restoreChat(chatId, authContext);
    }

    @GetMapping(value={"/{chatId}/attachments"})
    @NotNull
    public Page<ChatMessageAttachmentDto> getAttachments(@PathVariable(value="chatId") @NotNull ChatId chatId, @RequestParam(value="page", required=false, defaultValue="0") int page, @RequestParam(value="pageSize", required=false, defaultValue="30") int pageSize, @RequestParam(value="attachmentFilter", required=false, defaultValue="ALL") @NotNull AttachmentFilter attachmentFilter, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)chatId, (String)"chatId");
        Intrinsics.checkNotNullParameter((Object)attachmentFilter, (String)"attachmentFilter");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.chatApplicationService.getAttachmentsForChat(chatId, page, pageSize, attachmentFilter, authContext);
    }

    @PostMapping(value={"/{chatId}/chatIcon"})
    @NotNull
    public ChatDto updateChatIcon(@PathVariable(value="chatId") @NotNull ChatId chatId, @RequestParam(value="icon", required=true) @NotNull MultipartFile icon, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)chatId, (String)"chatId");
        Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.chatApplicationService.updateChatIcon(chatId, icon, authContext);
    }

    @DeleteMapping(value={"/{chatId}/chatIcon"})
    @NotNull
    public ChatDto deleteChatIcon(@PathVariable(value="chatId") @NotNull ChatId chatId, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)chatId, (String)"chatId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.chatApplicationService.deleteChatIcon(chatId, authContext);
    }
}

