/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.chat.config;

import java.time.Clock;
import java.time.Instant;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\nH\u0016R\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\r"}, d2={"Lde/justsoftware/chat/config/ClockWithMillisecondPrecision;", "Ljava/time/Clock;", "clock", "<init>", "(Ljava/time/Clock;)V", "getClock", "()Ljava/time/Clock;", "instant", "Ljava/time/Instant;", "getZone", "Ljava/time/ZoneId;", "withZone", "zone", "chat-service"})
public final class ClockWithMillisecondPrecision
extends Clock {
    @NotNull
    private final Clock clock;

    public ClockWithMillisecondPrecision(@NotNull Clock clock) {
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        this.clock = clock;
    }

    public /* synthetic */ ClockWithMillisecondPrecision(Clock clock, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            Clock clock2 = Clock.systemUTC();
            Intrinsics.checkNotNullExpressionValue((Object)clock2, (String)"systemUTC(...)");
            clock = clock2;
        }
        this(clock);
    }

    @NotNull
    public final Clock getClock() {
        return this.clock;
    }

    @Override
    @NotNull
    public Instant instant() {
        Instant instant = this.clock.instant().truncatedTo(ChronoUnit.MILLIS);
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"truncatedTo(...)");
        return instant;
    }

    @Override
    @NotNull
    public ZoneId getZone() {
        ZoneId zoneId = this.clock.getZone();
        Intrinsics.checkNotNullExpressionValue((Object)zoneId, (String)"getZone(...)");
        return zoneId;
    }

    @Override
    @NotNull
    public Clock withZone(@NotNull ZoneId zone) {
        Intrinsics.checkNotNullParameter((Object)zone, (String)"zone");
        Clock clock = this.clock.withZone(zone);
        Intrinsics.checkNotNullExpressionValue((Object)clock, (String)"withZone(...)");
        return (Clock)new ClockWithMillisecondPrecision(clock);
    }

    public ClockWithMillisecondPrecision() {
        this(null, 1, null);
    }
}

