/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.chat.business;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.justsoftware.chat.application.model.ChatMessageDto;
import de.justsoftware.chat.application.model.ControlMessageDto;
import de.justsoftware.chat.business.XmppRestApiService;
import de.justsoftware.chat.business.model.xmpp.CreateNodeStanza;
import de.justsoftware.chat.business.model.xmpp.JabberId;
import de.justsoftware.chat.business.model.xmpp.PublishItemStanza;
import de.justsoftware.chat.business.model.xmpp.Subscription;
import de.justsoftware.chat.business.model.xmpp.SubscriptionState;
import de.justsoftware.chat.business.model.xmpp.SubscriptionsStanza;
import de.justsoftware.chat.business.model.xmpp.XmppConnectedUsersPayload;
import de.justsoftware.chat.business.model.xmpp.XmppPayload;
import de.justsoftware.chat.business.model.xmpp.XmppSendMessagePayload;
import de.justsoftware.chat.business.model.xmpp.XmppSendStanzaPayload;
import de.justsoftware.chat.business.model.xmpp.XmppStanza;
import de.justsoftware.chat.exception.XmppException;
import de.justsoftware.chat.model.ProfileId;
import de.justsoftware.chat.model.UserGroupId;
import de.justsoftware.chat.util.CollectionUtilsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.web.client.ResourceAccessException;
import org.springframework.web.client.RestClient;
import org.springframework.web.client.RestClientException;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u0000 52\u00020\u0001:\u00015B7\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0001\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001e\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0017J\u001e\u0010\u0016\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0017\u001a\u00020\u0018H\u0017J\u001e\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u00032\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00130\u001cH\u0017J\u001e\u0010\u001d\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u00032\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00130\u001cH\u0017J&\u0010\u001e\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u00182\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\u0012H\u0017J&\u0010!\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\u0012H\u0017J\u0010\u0010\"\u001a\u00020\u00102\u0006\u0010#\u001a\u00020$H\u0017J&\u0010%\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010&\u001a\u00020\u00032\u0006\u0010'\u001a\u00020\u0003H\u0012J&\u0010(\u001a\u00020\u00102\u0006\u0010)\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u00032\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\u0012H\u0012J\u000e\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0012J\u001e\u0010+\u001a\u0002H,\"\u0006\b\u0000\u0010,\u0018\u00012\u0006\u0010)\u001a\u00020-H\u0092\b\u00a2\u0006\u0002\u0010.J+\u0010/\u001a\u0002H,\"\u0004\b\u0000\u0010,2\b\b\u0002\u00100\u001a\u0002012\f\u00102\u001a\b\u0012\u0004\u0012\u0002H,03H\u0012\u00a2\u0006\u0002\u00104R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lde/justsoftware/chat/business/XmppRestApiService;", "", "domain", "", "xmppHost", "xmppPort", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "restClient", "Lorg/springframework/web/client/RestClient;", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lcom/fasterxml/jackson/databind/ObjectMapper;Lorg/springframework/web/client/RestClient;)V", "xmppRestApiUrl", "pubSubRecipient", "systemUserId", "sendControlMessage", "", "recipients", "", "Lde/justsoftware/chat/model/ProfileId;", "controlMessageDto", "Lde/justsoftware/chat/application/model/ControlMessageDto;", "sendChatMessage", "chatMessageDto", "Lde/justsoftware/chat/application/model/ChatMessageDto;", "sendSubscribeStanza", "nodeName", "subscribers", "", "sendUnsubscribeStanza", "publishChatMessage", "userGroupIds", "Lde/justsoftware/chat/model/UserGroupId;", "publishControlMessage", "sendStanza", "stanza", "Lde/justsoftware/chat/business/model/xmpp/XmppStanza;", "sendMessage", "subject", "body", "sendPublishStanza", "payload", "getConnectedUsers", "sendToXmppRestApi", "T", "Lde/justsoftware/chat/business/model/xmpp/XmppPayload;", "(Lde/justsoftware/chat/business/model/xmpp/XmppPayload;)Ljava/lang/Object;", "retryEjabberd", "count", "", "block", "Lkotlin/Function0;", "(ILkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "Companion", "chat-service"})
@SourceDebugExtension(value={"SMAP\nXmppRestApiService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 XmppRestApiService.kt\nde/justsoftware/chat/business/XmppRestApiService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 CollectionUtils.kt\nde/justsoftware/chat/util/CollectionUtilsKt\n+ 4 LoggerUtils.kt\nde/justsoftware/chat/util/LoggerUtilsKt\n*L\n1#1,210:1\n166#1,23:219\n166#1,23:247\n166#1,23:273\n1563#2:211\n1634#2,3:212\n1563#2:215\n1634#2,3:216\n1634#2,3:243\n1869#2:246\n1870#2:270\n1869#2,2:271\n7#3:242\n9#4:296\n8#4,3:297\n*S KotlinDebug\n*F\n+ 1 XmppRestApiService.kt\nde/justsoftware/chat/business/XmppRestApiService\n*L\n117#1:219,23\n141#1:247,23\n157#1:273,23\n72#1:211\n72#1:212,3\n88#1:215\n88#1:216,3\n133#1:243,3\n134#1:246\n134#1:270\n152#1:271,2\n133#1:242\n206#1:296\n206#1:297,3\n*E\n"})
public class XmppRestApiService {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final String domain;
    @NotNull
    private final String xmppHost;
    @NotNull
    private final String xmppPort;
    @NotNull
    private final ObjectMapper objectMapper;
    @NotNull
    private final RestClient restClient;
    @NotNull
    private final String xmppRestApiUrl;
    @NotNull
    private final String pubSubRecipient;
    @NotNull
    private final String systemUserId;
    @NotNull
    private static final Logger LOG;
    private static final int MAX_RETRIES = 3;

    public XmppRestApiService(@Value(value="${just.chat.domain}") @NotNull String domain, @Value(value="${server.xmpp.host}") @NotNull String xmppHost, @Value(value="${server.xmpp.rest-api-port}") @NotNull String xmppPort, @NotNull ObjectMapper objectMapper, @Qualifier(value="ejabberdRestClient") @NotNull RestClient restClient) {
        Intrinsics.checkNotNullParameter((Object)domain, (String)"domain");
        Intrinsics.checkNotNullParameter((Object)xmppHost, (String)"xmppHost");
        Intrinsics.checkNotNullParameter((Object)xmppPort, (String)"xmppPort");
        Intrinsics.checkNotNullParameter((Object)objectMapper, (String)"objectMapper");
        Intrinsics.checkNotNullParameter((Object)restClient, (String)"restClient");
        this.domain = domain;
        this.xmppHost = xmppHost;
        this.xmppPort = xmppPort;
        this.objectMapper = objectMapper;
        this.restClient = restClient;
        this.xmppRestApiUrl = "https://" + this.xmppHost + ":" + this.xmppPort + "/api/";
        this.pubSubRecipient = "pubsub." + this.domain;
        this.systemUserId = new JabberId("xmpp-system-user", this.domain, null, 4, null).toString();
    }

    @Async
    public void sendControlMessage(@NotNull Set<ProfileId> recipients, @NotNull ControlMessageDto controlMessageDto) {
        Intrinsics.checkNotNullParameter(recipients, (String)"recipients");
        Intrinsics.checkNotNullParameter((Object)controlMessageDto, (String)"controlMessageDto");
        String string = this.objectMapper.writeValueAsString((Object)controlMessageDto);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"writeValueAsString(...)");
        this.sendMessage(recipients, "Notification", string);
    }

    @Async
    public void sendChatMessage(@NotNull Set<ProfileId> recipients, @NotNull ChatMessageDto chatMessageDto) {
        Intrinsics.checkNotNullParameter(recipients, (String)"recipients");
        Intrinsics.checkNotNullParameter((Object)chatMessageDto, (String)"chatMessageDto");
        String string = this.objectMapper.writeValueAsString((Object)chatMessageDto);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"writeValueAsString(...)");
        this.sendMessage(recipients, "Message", string);
    }

    /*
     * WARNING - void declaration
     */
    @Async
    public void sendSubscribeStanza(@NotNull String nodeName, @NotNull List<ProfileId> subscribers) {
        Collection<Subscription> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)nodeName, (String)"nodeName");
        Intrinsics.checkNotNullParameter(subscribers, (String)"subscribers");
        this.sendStanza((XmppStanza)new CreateNodeStanza(nodeName, null, 2, null));
        Iterable iterable = subscribers;
        String string = nodeName;
        XmppRestApiService xmppRestApiService = this;
        boolean $i$f$map = false;
        void var5_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void profileId;
            ProfileId profileId2 = (ProfileId)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new Subscription(JabberId.Companion.toJabberId((ProfileId)profileId, this.domain), nodeName, SubscriptionState.SUBSCRIBE));
        }
        collection = (List)destination$iv$iv;
        DefaultConstructorMarker defaultConstructorMarker = null;
        int n = 4;
        UUID uUID = null;
        List list = collection;
        String string2 = string;
        xmppRestApiService.sendStanza((XmppStanza)new SubscriptionsStanza(string2, list, uUID, n, defaultConstructorMarker));
    }

    /*
     * WARNING - void declaration
     */
    @Async
    public void sendUnsubscribeStanza(@NotNull String nodeName, @NotNull List<ProfileId> subscribers) {
        Collection<Subscription> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)nodeName, (String)"nodeName");
        Intrinsics.checkNotNullParameter(subscribers, (String)"subscribers");
        Iterable iterable = subscribers;
        String string = nodeName;
        XmppRestApiService xmppRestApiService = this;
        boolean $i$f$map = false;
        void var5_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void profileId;
            ProfileId profileId2 = (ProfileId)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new Subscription(JabberId.Companion.toJabberId((ProfileId)profileId, this.domain), nodeName, SubscriptionState.UNSUBSCRIBE));
        }
        collection = (List)destination$iv$iv;
        DefaultConstructorMarker defaultConstructorMarker = null;
        int n = 4;
        UUID uUID = null;
        List list = collection;
        String string2 = string;
        xmppRestApiService.sendStanza((XmppStanza)new SubscriptionsStanza(string2, list, uUID, n, defaultConstructorMarker));
    }

    @Async
    public void publishChatMessage(@NotNull String nodeName, @NotNull ChatMessageDto chatMessageDto, @NotNull Set<UserGroupId> userGroupIds) {
        Intrinsics.checkNotNullParameter((Object)nodeName, (String)"nodeName");
        Intrinsics.checkNotNullParameter((Object)chatMessageDto, (String)"chatMessageDto");
        Intrinsics.checkNotNullParameter(userGroupIds, (String)"userGroupIds");
        String string = this.objectMapper.writeValueAsString((Object)chatMessageDto);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"writeValueAsString(...)");
        this.sendPublishStanza(string, nodeName, userGroupIds);
    }

    @Async
    public void publishControlMessage(@NotNull String nodeName, @NotNull ControlMessageDto controlMessageDto, @NotNull Set<UserGroupId> userGroupIds) {
        Intrinsics.checkNotNullParameter((Object)nodeName, (String)"nodeName");
        Intrinsics.checkNotNullParameter((Object)controlMessageDto, (String)"controlMessageDto");
        Intrinsics.checkNotNullParameter(userGroupIds, (String)"userGroupIds");
        String string = this.objectMapper.writeValueAsString((Object)controlMessageDto);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"writeValueAsString(...)");
        this.sendPublishStanza(string, nodeName, userGroupIds);
    }

    /*
     * WARNING - void declaration
     */
    @Async
    public void sendStanza(@NotNull XmppStanza stanza) {
        Object object;
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)stanza, (String)"stanza");
        XmppSendStanzaPayload payload = new XmppSendStanzaPayload(this.systemUserId, this.pubSubRecipient, stanza.toXMLString());
        XmppRestApiService xmppRestApiService = this;
        XmppPayload payload$iv = (XmppPayload)payload;
        boolean $i$f$sendToXmppRestApi = false;
        Pair pair = payload$iv instanceof XmppSendMessagePayload ? TuplesKt.to((Object)"send_message", (Object)HttpMethod.POST) : TuplesKt.to((Object)"send_stanza", (Object)HttpMethod.POST);
        String command$iv = (String)pair.component1();
        HttpMethod httpMethod$iv = (HttpMethod)pair.component2();
        try {
            byte[] body$iv = this_$iv.objectMapper.writeValueAsBytes((Object)payload$iv);
            ResponseEntity response$iv = (ResponseEntity)XmppRestApiService.retryEjabberd$default((XmppRestApiService)this_$iv, (int)0, (Function0)((Function0)new /* Unavailable Anonymous Inner Class!! */), (int)1, null);
            if (response$iv.getStatusCode() != HttpStatus.OK) {
                throw new XmppException("Sending command " + command$iv + " failed with http status: " + response$iv.getStatusCode().value(), null, 2, null);
            }
            if (response$iv.getBody() == null) {
                throw new XmppException("ejabberd returned nothing for command " + command$iv, null, 2, null);
            }
        }
        catch (RestClientException e$iv) {
            throw new XmppException("Could not access ejabberd at: " + this_$iv.xmppRestApiUrl + command$iv, (Throwable)e$iv);
        }
        int response2 = ((Number)object).intValue();
        if (response2 != 0) {
            throw new XmppException("Sending stanza payload " + payload + " resulted in error (" + response2 + ")", null, 2, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void sendMessage(Set<ProfileId> recipients, String subject, String body2) {
        void $this$forEach$iv;
        XmppRestApiService profileId;
        void $this$mapTo$iv$iv;
        Iterable $this$mapToSet$iv;
        if (recipients.isEmpty()) {
            return;
        }
        Set connectedUsers = this.getConnectedUsers();
        Iterable iterable = CollectionsKt.intersect((Iterable)recipients, (Iterable)connectedUsers);
        boolean $i$f$mapToSet = false;
        Iterator iterator = $this$mapToSet$iv;
        Collection destination$iv$iv = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapToSet$iv));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            ProfileId profileId2 = (ProfileId)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(JabberId.Companion.toJabberId((ProfileId)profileId, this.domain));
        }
        $this$mapToSet$iv = (Set)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object object;
            void this_$iv;
            JabberId recipientJabberId = (JabberId)element$iv;
            boolean bl = false;
            XmppSendMessagePayload payload = new XmppSendMessagePayload(this.systemUserId, recipientJabberId.toString(), subject, body2, null, 16, null);
            profileId = this;
            XmppPayload payload$iv = (XmppPayload)payload;
            boolean $i$f$sendToXmppRestApi = false;
            Pair pair = TuplesKt.to((Object)"send_message", (Object)HttpMethod.POST);
            String command$iv = (String)pair.component1();
            HttpMethod httpMethod$iv = (HttpMethod)pair.component2();
            try {
                byte[] body$iv = this_$iv.objectMapper.writeValueAsBytes((Object)payload$iv);
                ResponseEntity response$iv = (ResponseEntity)XmppRestApiService.retryEjabberd$default((XmppRestApiService)this_$iv, (int)0, (Function0)((Function0)new /* Unavailable Anonymous Inner Class!! */), (int)1, null);
                if (response$iv.getStatusCode() != HttpStatus.OK) {
                    throw new XmppException("Sending command " + command$iv + " failed with http status: " + response$iv.getStatusCode().value(), null, 2, null);
                }
                if (response$iv.getBody() == null) {
                    throw new XmppException("ejabberd returned nothing for command " + command$iv, null, 2, null);
                }
            }
            catch (RestClientException e$iv) {
                throw new XmppException("Could not access ejabberd at: " + this_$iv.xmppRestApiUrl + command$iv, (Throwable)e$iv);
            }
            int response2 = ((Number)object).intValue();
            if (response2 == 0) continue;
            throw new XmppException("Sending message payload " + payload + " resulted in error (" + response2 + ")", null, 2, null);
        }
    }

    private void sendPublishStanza(String payload, String nodeName, Set<UserGroupId> userGroupIds) {
        this.sendStanza((XmppStanza)new PublishItemStanza(nodeName, payload, null, 4, null));
        Iterable $this$forEach$iv = userGroupIds;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            UserGroupId userGroupId = (UserGroupId)element$iv;
            boolean bl = false;
            this.sendStanza((XmppStanza)new PublishItemStanza(userGroupId.toCanonicalId(), payload, null, 4, null));
        }
    }

    /*
     * WARNING - void declaration
     */
    private Set<ProfileId> getConnectedUsers() {
        Object object;
        void this_$iv;
        Pair pair;
        XmppRestApiService xmppRestApiService = this;
        XmppPayload payload$iv = (XmppPayload)XmppConnectedUsersPayload.INSTANCE;
        boolean $i$f$sendToXmppRestApi = false;
        XmppPayload xmppPayload = payload$iv;
        if (xmppPayload instanceof XmppSendMessagePayload) {
            pair = TuplesKt.to((Object)"send_message", (Object)HttpMethod.POST);
        } else if (xmppPayload instanceof XmppSendStanzaPayload) {
            pair = TuplesKt.to((Object)"send_stanza", (Object)HttpMethod.POST);
        } else if (xmppPayload instanceof XmppConnectedUsersPayload) {
            pair = TuplesKt.to((Object)"connected_users", (Object)HttpMethod.GET);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        Pair pair2 = pair;
        String command$iv = (String)pair2.component1();
        HttpMethod httpMethod$iv = (HttpMethod)pair2.component2();
        try {
            byte[] body$iv = this_$iv.objectMapper.writeValueAsBytes((Object)payload$iv);
            ResponseEntity response$iv = (ResponseEntity)XmppRestApiService.retryEjabberd$default((XmppRestApiService)this_$iv, (int)0, (Function0)((Function0)new /* Unavailable Anonymous Inner Class!! */), (int)1, null);
            if (response$iv.getStatusCode() != HttpStatus.OK) {
                throw new XmppException("Sending command " + command$iv + " failed with http status: " + response$iv.getStatusCode().value(), null, 2, null);
            }
            if (response$iv.getBody() == null) {
                throw new XmppException("ejabberd returned nothing for command " + command$iv, null, 2, null);
            }
        }
        catch (RestClientException e$iv) {
            throw new XmppException("Could not access ejabberd at: " + this_$iv.xmppRestApiUrl + command$iv, (Throwable)e$iv);
        }
        return SequencesKt.toSet((Sequence)SequencesKt.map((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.filter((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)((Iterable)object)), (Function1)((Function1)new /* Unavailable Anonymous Inner Class!! */)), arg_0 -> XmppRestApiService.getConnectedUsers$lambda$0(this, arg_0)), XmppRestApiService::getConnectedUsers$lambda$1), (Function1)((Function1)getConnectedUsers.4.INSTANCE)));
    }

    private /* synthetic */ <T> T sendToXmppRestApi(XmppPayload payload) {
        Pair pair;
        boolean $i$f$sendToXmppRestApi = false;
        XmppPayload xmppPayload = payload;
        if (xmppPayload instanceof XmppSendMessagePayload) {
            pair = TuplesKt.to((Object)"send_message", (Object)HttpMethod.POST);
        } else if (xmppPayload instanceof XmppSendStanzaPayload) {
            pair = TuplesKt.to((Object)"send_stanza", (Object)HttpMethod.POST);
        } else if (xmppPayload instanceof XmppConnectedUsersPayload) {
            pair = TuplesKt.to((Object)"connected_users", (Object)HttpMethod.GET);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        Pair pair2 = pair;
        String command = (String)pair2.component1();
        HttpMethod httpMethod = (HttpMethod)pair2.component2();
        try {
            byte[] body2 = this.objectMapper.writeValueAsBytes((Object)payload);
            Intrinsics.needClassReification();
            ResponseEntity response2 = (ResponseEntity)XmppRestApiService.retryEjabberd$default((XmppRestApiService)this, (int)0, (Function0)((Function0)new /* Unavailable Anonymous Inner Class!! */), (int)1, null);
            if (response2.getStatusCode() != HttpStatus.OK) {
                throw new XmppException("Sending command " + command + " failed with http status: " + response2.getStatusCode().value(), null, 2, null);
            }
            Object object = response2.getBody();
            if (object == null) {
                throw new XmppException("ejabberd returned nothing for command " + command, null, 2, null);
            }
            return (T)object;
        }
        catch (RestClientException e) {
            throw new XmppException("Could not access ejabberd at: " + this.xmppRestApiUrl + command, (Throwable)e);
        }
    }

    private <T> T retryEjabberd(int count, Function0<? extends T> block) {
        Object object;
        try {
            object = block.invoke();
        }
        catch (ResourceAccessException e) {
            if (count > 3) {
                LOG.error("Error sending to ejabberd: \"" + e + "\" ... attempt " + count + "/3");
                throw e;
            }
            LOG.warn("Error sending to ejabberd: \"" + e + "\" ... attempt " + count + "/3");
            Thread.sleep(200L);
            object = this.retryEjabberd(count + 1, block);
        }
        return (T)object;
    }

    static /* synthetic */ Object retryEjabberd$default(XmppRestApiService xmppRestApiService, int n, Function0 function0, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: retryEjabberd");
        }
        if ((n2 & 1) != 0) {
            n = 1;
        }
        return xmppRestApiService.retryEjabberd(n, function0);
    }

    private static final boolean getConnectedUsers$lambda$0(XmppRestApiService this$0, JabberId it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)it.getDomain(), (Object)this$0.domain);
    }

    private static final Long getConnectedUsers$lambda$1(JabberId it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return StringsKt.toLongOrNull((String)it.getNode());
    }

    public static final /* synthetic */ RestClient access$getRestClient$p(XmppRestApiService $this) {
        return $this.restClient;
    }

    static {
        Companion $this$logger$iv = Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = LoggerFactory.getLogger(Reflection.getOrCreateKotlinClass(Companion.class).isCompanion() ? Companion.class.getEnclosingClass() : Companion.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        LOG = logger;
    }
}

