/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.chat.business;

import de.justsoftware.chat.model.ProfileId;
import de.justsoftware.chat.persistence.MailSettingsRepository;
import de.justsoftware.chat.persistence.model.DbMailSettings;
import de.justsoftware.chat.util.CollectionUtilsKt;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u001e\u0010\f\u001a\u00020\u00072\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\t0\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\"\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u000b0\u00122\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\t0\u000eH\u0016J\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\b\u001a\u00020\tH\u0012J\"\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00150\u00122\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\t0\u000eH\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lde/justsoftware/chat/business/SettingsService;", "", "mailSettingsRepository", "Lde/justsoftware/chat/persistence/MailSettingsRepository;", "<init>", "(Lde/justsoftware/chat/persistence/MailSettingsRepository;)V", "saveMailDeliverySetting", "", "profileId", "Lde/justsoftware/chat/model/ProfileId;", "isMailDeliveryEnabled", "", "saveMailDeliveryDates", "profileIds", "", "deliveryDate", "Ljava/time/Instant;", "getMailDeliveryEnabledSettingsForProfileIds", "", "findByProfileId", "Ljava/util/Optional;", "Lde/justsoftware/chat/persistence/model/DbMailSettings;", "findByProfileIds", "", "chat-service"})
@SourceDebugExtension(value={"SMAP\nSettingsService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SettingsService.kt\nde/justsoftware/chat/business/SettingsService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 CollectionUtils.kt\nde/justsoftware/chat/util/CollectionUtilsKt\n*L\n1#1,61:1\n1#2:62\n1563#3:63\n1634#3,3:64\n1634#3,3:68\n1563#3:71\n1634#3,3:72\n1193#3,2:75\n1267#3,4:77\n1563#3:81\n1634#3,3:82\n7#4:67\n*S KotlinDebug\n*F\n+ 1 SettingsService.kt\nde/justsoftware/chat/business/SettingsService\n*L\n33#1:63\n33#1:64,3\n35#1:68,3\n36#1:71\n36#1:72,3\n50#1:75,2\n50#1:77,4\n59#1:81\n59#1:82,3\n35#1:67\n*E\n"})
public class SettingsService {
    @NotNull
    private final MailSettingsRepository mailSettingsRepository;

    public SettingsService(@NotNull MailSettingsRepository mailSettingsRepository) {
        Intrinsics.checkNotNullParameter((Object)mailSettingsRepository, (String)"mailSettingsRepository");
        this.mailSettingsRepository = mailSettingsRepository;
    }

    public void saveMailDeliverySetting(@NotNull ProfileId profileId, boolean isMailDeliveryEnabled) {
        DbMailSettings dbMailSettings;
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        DbMailSettings $this$saveMailDeliverySetting_u24lambda_u240 = dbMailSettings = this.findByProfileId(profileId).orElse(new DbMailSettings(profileId.toCanonicalId(), Boolean.valueOf(isMailDeliveryEnabled), null));
        boolean bl = false;
        $this$saveMailDeliverySetting_u24lambda_u240.setMailDeliveryEnabled(Boolean.valueOf(isMailDeliveryEnabled));
        MailSettingsRepository mailSettingsRepository = this.mailSettingsRepository;
        DbMailSettings p0 = dbMailSettings;
        boolean bl2 = false;
        DbMailSettings cfr_ignored_0 = (DbMailSettings)mailSettingsRepository.save((Object)p0);
    }

    /*
     * WARNING - void declaration
     */
    public void saveMailDeliveryDates(@NotNull Set<ProfileId> profileIds, @NotNull Instant deliveryDate) {
        ProfileId p0;
        Iterable $this$mapTo$iv$iv;
        void $this$mapToSet$iv;
        String string;
        Collection<Object> collection;
        ProfileId.Companion $this$mapTo$iv$iv2;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(profileIds, (String)"profileIds");
        Intrinsics.checkNotNullParameter((Object)deliveryDate, (String)"deliveryDate");
        Map existingDbSettings = this.findByProfileIds(profileIds);
        Iterable iterable = existingDbSettings.values();
        boolean $i$f$map22 = false;
        void var7_7 = $this$map$iv;
        Set<ProfileId> destination$iv$iv = (Set<ProfileId>)((Object)new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10)));
        boolean $i$f$mapTo22 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void mailSettings;
            DbMailSettings dbMailSettings = (DbMailSettings)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            string = mailSettings;
            void $this$saveMailDeliveryDates_u24lambda_u240_u240 = string;
            boolean bl2 = false;
            $this$saveMailDeliveryDates_u24lambda_u240_u240.setLastMailDeliveryDate(deliveryDate);
            collection.add((ProfileId)string);
        }
        List updatedDbSettings = (List)((Object)destination$iv$iv);
        Iterable $i$f$map22 = existingDbSettings.keySet();
        $this$mapTo$iv$iv2 = ProfileId.Companion;
        collection = profileIds;
        boolean $i$f$mapToSet = false;
        void $i$f$mapTo22 = $this$mapToSet$iv;
        Collection destination$iv$iv2 = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapToSet$iv));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            string = (String)item$iv$iv;
            Collection collection2 = destination$iv$iv2;
            boolean bl = false;
            collection2.add($this$mapTo$iv$iv2.fromCanonicalId((String)p0));
        }
        Set newProfileIds = SetsKt.minus(collection, (Iterable)((Set)destination$iv$iv2));
        Iterable $this$map$iv2 = newProfileIds;
        boolean $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv2;
        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void profileId;
            p0 = (ProfileId)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl = false;
            collection.add((ProfileId)new DbMailSettings(profileId.toCanonicalId(), null, deliveryDate));
        }
        List newDbSettings = (List)destination$iv$iv2;
        this.mailSettingsRepository.saveAll((Iterable)CollectionsKt.plus((Collection)updatedDbSettings, (Iterable)newDbSettings));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Map<ProfileId, Boolean> getMailDeliveryEnabledSettingsForProfileIds(@NotNull Set<ProfileId> profileIds) {
        void $this$associateTo$iv$iv;
        Intrinsics.checkNotNullParameter(profileIds, (String)"profileIds");
        Iterable $this$associate$iv = this.findByProfileIds(profileIds).entrySet();
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        Iterable iterable = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv;
            boolean bl = false;
            String profileId = (String)entry.getKey();
            DbMailSettings setting = (DbMailSettings)entry.getValue();
            entry = TuplesKt.to((Object)ProfileId.Companion.fromCanonicalId(profileId), (Object)setting.getMailDeliveryEnabled());
            map.put(entry.getFirst(), entry.getSecond());
        }
        return CollectionUtilsKt.filterNotNullValues((Map)destination$iv$iv);
    }

    private Optional<DbMailSettings> findByProfileId(ProfileId profileId) {
        Optional optional = this.mailSettingsRepository.findById((Object)profileId.toCanonicalId());
        Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"findById(...)");
        return optional;
    }

    /*
     * WARNING - void declaration
     */
    private Map<String, DbMailSettings> findByProfileIds(Set<ProfileId> profileIds) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = profileIds;
        MailSettingsRepository mailSettingsRepository = this.mailSettingsRepository;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            ProfileId profileId = (ProfileId)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(p0.toCanonicalId());
        }
        return mailSettingsRepository.findByProfileIds((Iterable)((List)destination$iv$iv));
    }
}

