/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.chat.business;

import de.justsoftware.chat.authorization.AuthorizationService;
import de.justsoftware.chat.business.ChatCoreSearchService;
import de.justsoftware.chat.model.ChatCoreSearchFields;
import de.justsoftware.chat.model.ChatCoreSearchModelType;
import de.justsoftware.chat.model.ChatCoreSearchResult;
import de.justsoftware.chat.model.ChatCoreSearchSortType;
import de.justsoftware.chat.model.ChatId;
import de.justsoftware.chat.model.Offset;
import de.justsoftware.chat.model.ProfileId;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.params.SolrParams;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u0000 &2\u00020\u0001:\u0001&B\u0019\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J<\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\f2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\u0013\u001a\u00020\u0014H\u0016J\\\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u001a2\u0019\b\u0002\u0010\u001b\u001a\u0013\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u001e0\u001c\u00a2\u0006\u0002\b\u001fH\u0012\u00a2\u0006\u0002\u0010 JV\u0010!\u001a\u00020\u001d2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u001a2\u0019\b\u0002\u0010\u001b\u001a\u0013\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u001e0\u001c\u00a2\u0006\u0002\b\u001fH\u0012\u00a2\u0006\u0002\u0010\"J\u0010\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u001dH\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lde/justsoftware/chat/business/ChatCoreSearchService;", "", "chatCoreFollowerSolrClient", "Lorg/apache/solr/client/solrj/SolrClient;", "authorizationService", "Lde/justsoftware/chat/authorization/AuthorizationService;", "<init>", "(Lorg/apache/solr/client/solrj/SolrClient;Lde/justsoftware/chat/authorization/AuthorizationService;)V", "searchMessages", "Lorg/springframework/data/domain/Page;", "Lde/justsoftware/chat/model/ChatCoreSearchResult;", "query", "", "chatId", "Lde/justsoftware/chat/model/ChatId;", "searchBy", "Lde/justsoftware/chat/model/ProfileId;", "offset", "Lde/justsoftware/chat/model/Offset;", "sortBy", "Lde/justsoftware/chat/model/ChatCoreSearchSortType;", "sendSolrQuery", "types", "", "Lde/justsoftware/chat/model/ChatCoreSearchModelType;", "pageable", "Lorg/springframework/data/domain/Pageable;", "configure", "Lkotlin/Function1;", "Lorg/apache/solr/client/solrj/SolrQuery;", "", "Lkotlin/ExtensionFunctionType;", "(Ljava/lang/String;[Lde/justsoftware/chat/model/ChatCoreSearchModelType;Lde/justsoftware/chat/model/ChatCoreSearchSortType;Lde/justsoftware/chat/model/ProfileId;Lorg/springframework/data/domain/Pageable;Lkotlin/jvm/functions/Function1;)Lorg/springframework/data/domain/Page;", "buildSolrQuery", "(Ljava/lang/String;[Lde/justsoftware/chat/model/ChatCoreSearchModelType;Lde/justsoftware/chat/model/ChatCoreSearchSortType;Lde/justsoftware/chat/model/ProfileId;Lorg/springframework/data/domain/Pageable;Lkotlin/jvm/functions/Function1;)Lorg/apache/solr/client/solrj/SolrQuery;", "send", "Lorg/apache/solr/client/solrj/response/QueryResponse;", "solrQuery", "Companion", "chat-service"})
@SourceDebugExtension(value={"SMAP\nChatCoreSearchService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChatCoreSearchService.kt\nde/justsoftware/chat/business/ChatCoreSearchService\n+ 2 LoggerUtils.kt\nde/justsoftware/chat/util/LoggerUtilsKt\n*L\n1#1,164:1\n9#2:165\n8#2,3:166\n*S KotlinDebug\n*F\n+ 1 ChatCoreSearchService.kt\nde/justsoftware/chat/business/ChatCoreSearchService\n*L\n106#1:165\n106#1:166,3\n*E\n"})
public class ChatCoreSearchService {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final SolrClient chatCoreFollowerSolrClient;
    @NotNull
    private final AuthorizationService authorizationService;
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final String REQUESTED_FIELDS;

    public ChatCoreSearchService(@Qualifier(value="chatCoreFollowerSolrClient") @NotNull SolrClient chatCoreFollowerSolrClient, @NotNull AuthorizationService authorizationService) {
        Intrinsics.checkNotNullParameter((Object)chatCoreFollowerSolrClient, (String)"chatCoreFollowerSolrClient");
        Intrinsics.checkNotNullParameter((Object)authorizationService, (String)"authorizationService");
        this.chatCoreFollowerSolrClient = chatCoreFollowerSolrClient;
        this.authorizationService = authorizationService;
    }

    @NotNull
    public Page<ChatCoreSearchResult> searchMessages(@NotNull String query, @Nullable ChatId chatId, @NotNull ProfileId searchBy, @NotNull Offset offset, @NotNull ChatCoreSearchSortType sortBy) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Intrinsics.checkNotNullParameter((Object)searchBy, (String)"searchBy");
        Intrinsics.checkNotNullParameter((Object)offset, (String)"offset");
        Intrinsics.checkNotNullParameter((Object)sortBy, (String)"sortBy");
        ChatCoreSearchModelType[] chatCoreSearchModelTypeArray = new ChatCoreSearchModelType[]{ChatCoreSearchModelType.MESSAGE};
        return this.sendSolrQuery(query, chatCoreSearchModelTypeArray, sortBy, searchBy, ChatCoreSearchSortType.Companion.toPageable(offset, sortBy), arg_0 -> ChatCoreSearchService.searchMessages$lambda$0(chatId, arg_0));
    }

    public static /* synthetic */ Page searchMessages$default(ChatCoreSearchService chatCoreSearchService, String string, ChatId chatId, ProfileId profileId, Offset offset, ChatCoreSearchSortType chatCoreSearchSortType, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: searchMessages");
        }
        if ((n & 2) != 0) {
            chatId = null;
        }
        if ((n & 0x10) != 0) {
            chatCoreSearchSortType = ChatCoreSearchSortType.ACTIVITY;
        }
        return chatCoreSearchService.searchMessages(string, chatId, profileId, offset, chatCoreSearchSortType);
    }

    private Page<ChatCoreSearchResult> sendSolrQuery(String query, ChatCoreSearchModelType[] types, ChatCoreSearchSortType sortBy, ProfileId searchBy, Pageable pageable, Function1<? super SolrQuery, Unit> configure) {
        return Companion.access$toSearchResultsPage((Companion)Companion, (QueryResponse)this.send(this.buildSolrQuery(query, types, sortBy, searchBy, pageable, configure)), (Pageable)pageable);
    }

    static /* synthetic */ Page sendSolrQuery$default(ChatCoreSearchService chatCoreSearchService, String string, ChatCoreSearchModelType[] chatCoreSearchModelTypeArray, ChatCoreSearchSortType chatCoreSearchSortType, ProfileId profileId, Pageable pageable, Function1 function1, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: sendSolrQuery");
        }
        if ((n & 0x20) != 0) {
            function1 = ChatCoreSearchService::sendSolrQuery$lambda$0;
        }
        return chatCoreSearchService.sendSolrQuery(string, chatCoreSearchModelTypeArray, chatCoreSearchSortType, profileId, pageable, function1);
    }

    private SolrQuery buildSolrQuery(String query, ChatCoreSearchModelType[] types, ChatCoreSearchSortType sortBy, ProfileId searchBy, Pageable pageable, Function1<? super SolrQuery, Unit> configure) {
        SolrQuery solrQuery;
        SolrQuery $this$buildSolrQuery_u24lambda_u241 = solrQuery = new SolrQuery();
        boolean bl = false;
        if (!StringsKt.isBlank((CharSequence)query)) {
            $this$buildSolrQuery_u24lambda_u241.setQuery(Companion.access$toEscapedQuery((Companion)Companion, (String)query));
        }
        $this$buildSolrQuery_u24lambda_u241.setHighlight(true);
        String[] stringArray = new String[]{sortBy.getSolrSortValue()};
        $this$buildSolrQuery_u24lambda_u241.add("sort", stringArray);
        stringArray = new String[]{String.valueOf(pageable.getOffset())};
        $this$buildSolrQuery_u24lambda_u241.set("start", stringArray);
        stringArray = new String[]{String.valueOf(pageable.getPageSize())};
        $this$buildSolrQuery_u24lambda_u241.set("rows", stringArray);
        stringArray = new String[]{REQUESTED_FIELDS};
        $this$buildSolrQuery_u24lambda_u241.set("fl", stringArray);
        stringArray = new String[]{ArraysKt.joinToString$default((Object[])types, (CharSequence)" OR ", null, null, (int)0, null, ChatCoreSearchService::buildSolrQuery$lambda$1$0, (int)30, null)};
        $this$buildSolrQuery_u24lambda_u241.addFilterQuery(stringArray);
        String searchRoles = CollectionsKt.joinToString$default((Iterable)this.authorizationService.searchRolesBy(searchBy), (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
        String[] stringArray2 = new String[]{searchRoles};
        $this$buildSolrQuery_u24lambda_u241.add("jucoRoles", stringArray2);
        $this$buildSolrQuery_u24lambda_u241.setRequestHandler("justSearch");
        configure.invoke((Object)$this$buildSolrQuery_u24lambda_u241);
        return solrQuery;
    }

    static /* synthetic */ SolrQuery buildSolrQuery$default(ChatCoreSearchService chatCoreSearchService, String string, ChatCoreSearchModelType[] chatCoreSearchModelTypeArray, ChatCoreSearchSortType chatCoreSearchSortType, ProfileId profileId, Pageable pageable, Function1 function1, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: buildSolrQuery");
        }
        if ((n & 0x20) != 0) {
            function1 = ChatCoreSearchService::buildSolrQuery$lambda$0;
        }
        return chatCoreSearchService.buildSolrQuery(string, chatCoreSearchModelTypeArray, chatCoreSearchSortType, profileId, pageable, function1);
    }

    private QueryResponse send(SolrQuery solrQuery) {
        QueryResponse queryResponse;
        try {
            queryResponse = this.chatCoreFollowerSolrClient.query((SolrParams)solrQuery, SolrRequest.METHOD.POST);
            Intrinsics.checkNotNull((Object)queryResponse);
        }
        catch (Exception e) {
            LOG.error("Error occurred while executing query " + solrQuery, (Throwable)e);
            throw e;
        }
        return queryResponse;
    }

    private static final Unit searchMessages$lambda$0(ChatId $chatId, SolrQuery $this$sendSolrQuery) {
        Intrinsics.checkNotNullParameter((Object)$this$sendSolrQuery, (String)"$this$sendSolrQuery");
        if ($chatId != null) {
            String[] stringArray = new String[]{"chat_id:" + $chatId};
            $this$sendSolrQuery.addFilterQuery(stringArray);
        }
        return Unit.INSTANCE;
    }

    private static final Unit sendSolrQuery$lambda$0(SolrQuery solrQuery) {
        Intrinsics.checkNotNullParameter((Object)solrQuery, (String)"<this>");
        return Unit.INSTANCE;
    }

    private static final Unit buildSolrQuery$lambda$0(SolrQuery solrQuery) {
        Intrinsics.checkNotNullParameter((Object)solrQuery, (String)"<this>");
        return Unit.INSTANCE;
    }

    private static final CharSequence buildSolrQuery$lambda$1$0(ChatCoreSearchModelType it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return "type:" + it;
    }

    static {
        Companion $this$logger$iv = Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = LoggerFactory.getLogger(Reflection.getOrCreateKotlinClass(Companion.class).isCompanion() ? Companion.class.getEnclosingClass() : Companion.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        LOG = logger;
        ChatCoreSearchFields $this$REQUESTED_FIELDS_u24lambda_u240 = ChatCoreSearchFields.INSTANCE;
        boolean bl = false;
        REQUESTED_FIELDS = "id, chat_id, type, chat_type, modify_date, create_date, attachments, title, message, author_id";
    }
}

