/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.chat.authorization;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.chat.authorization.AuthorizationContext;
import de.justsoftware.chat.business.ProfileService;
import de.justsoftware.chat.business.UserGroupService;
import de.justsoftware.chat.business.model.ChatParticipant;
import de.justsoftware.chat.business.model.Profile;
import de.justsoftware.chat.exception.NotAllowedException;
import de.justsoftware.chat.exception.NotFoundException;
import de.justsoftware.chat.model.ChatId;
import de.justsoftware.chat.model.ParticipantId;
import de.justsoftware.chat.model.PermissionAction;
import de.justsoftware.chat.model.PermissionRole;
import de.justsoftware.chat.model.PermissionType;
import de.justsoftware.chat.model.ProfileId;
import de.justsoftware.chat.model.ProfileStatus;
import de.justsoftware.chat.model.TenantId;
import de.justsoftware.chat.model.UserGroupId;
import de.justsoftware.chat.persistence.ChatParticipantRepository;
import de.justsoftware.chat.persistence.model.DbChatParticipant;
import de.justsoftware.chat.util.CollectionUtilsKt;
import de.justsoftware.permission.client.model.AuthorizationResult;
import de.justsoftware.permission.client.model.Role;
import de.justsoftware.permission.client.rest.PermissionRequestConnector;
import io.micrometer.observation.annotation.Observed;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Service;

@Observed
@Service
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0012\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0013\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J*\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\r0\u00152\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00160\u00182\u0006\u0010\u0010\u001a\u00020\u0011H\u0016JB\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u0002H\u001a\u0012\u0004\u0012\u00020\r0\u0015\"\b\b\u0000\u0010\u001a*\u00020\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u0002H\u001a0\u00182\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u00182\u0006\u0010\u001f\u001a\u00020\u0011H\u0016J*\u0010 \u001a\u000e\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020\"0\u00152\f\u0010#\u001a\b\u0012\u0004\u0012\u00020!0\u00182\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0016\u0010$\u001a\b\u0012\u0004\u0012\u00020!0\u00182\u0006\u0010%\u001a\u00020\u0011H\u0016J \u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010*\u001a\u00020+H\u0016J\u0018\u0010,\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J$\u0010-\u001a\b\u0012\u0004\u0012\u00020)0\u00182\f\u0010.\u001a\b\u0012\u0004\u0012\u00020)0/2\u0006\u0010*\u001a\u00020+H\u0016J2\u00100\u001a\u000e\u0012\u0004\u0012\u00020)\u0012\u0004\u0012\u00020\r0\u00152\f\u0010.\u001a\b\u0012\u0004\u0012\u00020)0\u00182\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010*\u001a\u00020+H\u0016J6\u00101\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\r0\u00152\u0018\u00102\u001a\u0014\u0012\u0004\u0012\u000203\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u00180\u00152\u0006\u0010*\u001a\u00020+H\u0016J\u0018\u00104\u001a\u00020\r2\u0006\u00105\u001a\u00020!2\u0006\u0010\u0010\u001a\u00020\u0011H\u0012J*\u00104\u001a\u000e\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020\r0\u00152\f\u0010#\u001a\b\u0012\u0004\u0012\u00020!0\u00182\u0006\u0010\u0010\u001a\u00020\u0011H\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lde/justsoftware/chat/authorization/AuthorizationService;", "", "permissionRequestConnector", "Lde/justsoftware/permission/client/rest/PermissionRequestConnector;", "userGroupService", "Lde/justsoftware/chat/business/UserGroupService;", "profileService", "Lde/justsoftware/chat/business/ProfileService;", "chatParticipantRepository", "Lde/justsoftware/chat/persistence/ChatParticipantRepository;", "<init>", "(Lde/justsoftware/permission/client/rest/PermissionRequestConnector;Lde/justsoftware/chat/business/UserGroupService;Lde/justsoftware/chat/business/ProfileService;Lde/justsoftware/chat/persistence/ChatParticipantRepository;)V", "isMemberOfTenant", "", "tenantId", "Lde/justsoftware/chat/model/TenantId;", "profileId", "Lde/justsoftware/chat/model/ProfileId;", "mayProfileCreateOneOnOneChat", "mayProfileCreateMultiUserChat", "mayInteractWithParticipants", "", "Lde/justsoftware/chat/model/ParticipantId;", "participantIds", "", "mayAll", "T", "Lde/justsoftware/chat/model/PermissionRole;", "itemsToCheck", "permissionActions", "Lde/justsoftware/chat/model/PermissionAction;", "userId", "hasRoles", "Lde/justsoftware/permission/client/model/Role;", "Lde/justsoftware/permission/client/model/AuthorizationResult;", "rolesToCheck", "searchRolesBy", "searchBy", "checkChatPermission", "", "chatId", "Lde/justsoftware/chat/model/ChatId;", "permissionType", "Lde/justsoftware/chat/model/PermissionType;", "checkManageOrTempManageChat", "filterChatIdsWithoutPermission", "chatIds", "", "hasPermissionForChats", "havePermission", "profileIdsOfParticipants", "Lde/justsoftware/chat/business/model/ChatParticipant;", "may", "roleToCheck", "chat-service"})
@SourceDebugExtension(value={"SMAP\nAuthorizationService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AuthorizationService.kt\nde/justsoftware/chat/authorization/AuthorizationService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 CollectionUtils.kt\nde/justsoftware/chat/util/CollectionUtilsKt\n+ 5 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,183:1\n1374#2:184\n1460#2,2:185\n1563#2:187\n1634#2,3:188\n1462#2,3:191\n1285#2,2:194\n1299#2,2:196\n1563#2:198\n1634#2,3:199\n1740#2,3:202\n1302#2:205\n1285#2,2:206\n1299#2,4:208\n1563#2:212\n1634#2,3:213\n1563#2:219\n1634#2,3:220\n817#2,2:227\n1252#2,2:242\n774#2:244\n865#2,2:245\n1563#2:247\n1634#2,3:248\n1255#2:251\n1634#2,3:260\n1285#2,2:263\n1299#2,4:265\n1563#2:269\n1634#2,3:270\n1563#2:276\n1634#2,3:277\n774#2:280\n865#2,2:281\n1285#2,2:292\n1299#2,4:294\n1252#2,4:300\n77#3:216\n97#3,2:217\n99#3,3:223\n153#3,3:237\n126#3:273\n153#3,2:274\n155#3:284\n22#4:226\n16#4:236\n7#4:259\n504#5,7:229\n463#5:240\n413#5:241\n504#5,7:252\n536#5:285\n521#5,6:286\n463#5:298\n413#5:299\n1#6:283\n*S KotlinDebug\n*F\n+ 1 AuthorizationService.kt\nde/justsoftware/chat/authorization/AuthorizationService\n*L\n71#1:184\n71#1:185,2\n71#1:187\n71#1:188,3\n71#1:191,3\n73#1:194,2\n73#1:196,2\n74#1:198\n74#1:199,3\n74#1:202,3\n73#1:205\n83#1:206,2\n83#1:208,4\n112#1:212\n112#1:213,3\n114#1:219\n114#1:220,3\n115#1:227,2\n122#1:242,2\n123#1:244\n123#1:245,2\n130#1:247\n130#1:248,3\n122#1:251\n134#1:260,3\n143#1:263,2\n143#1:265,4\n147#1:269\n147#1:270,3\n150#1:276\n150#1:277,3\n151#1:280\n151#1:281,2\n174#1:292,2\n174#1:294,4\n181#1:300,4\n114#1:216\n114#1:217,2\n114#1:223,3\n119#1:237,3\n148#1:273\n148#1:274,2\n148#1:284\n115#1:226\n119#1:236\n134#1:259\n118#1:229,7\n122#1:240\n122#1:241\n132#1:252,7\n170#1:285\n170#1:286,6\n181#1:298\n181#1:299\n*E\n"})
public class AuthorizationService {
    @NotNull
    private final PermissionRequestConnector permissionRequestConnector;
    @NotNull
    private final UserGroupService userGroupService;
    @NotNull
    private final ProfileService profileService;
    @NotNull
    private final ChatParticipantRepository chatParticipantRepository;

    public AuthorizationService(@NotNull PermissionRequestConnector permissionRequestConnector, @NotNull UserGroupService userGroupService, @NotNull ProfileService profileService, @NotNull ChatParticipantRepository chatParticipantRepository) {
        Intrinsics.checkNotNullParameter((Object)permissionRequestConnector, (String)"permissionRequestConnector");
        Intrinsics.checkNotNullParameter((Object)userGroupService, (String)"userGroupService");
        Intrinsics.checkNotNullParameter((Object)profileService, (String)"profileService");
        Intrinsics.checkNotNullParameter((Object)chatParticipantRepository, (String)"chatParticipantRepository");
        this.permissionRequestConnector = permissionRequestConnector;
        this.userGroupService = userGroupService;
        this.profileService = profileService;
        this.chatParticipantRepository = chatParticipantRepository;
    }

    public boolean isMemberOfTenant(@NotNull TenantId tenantId, @NotNull ProfileId profileId) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        Role role = Role.tenantRole((UUID)tenantId.getValue());
        Intrinsics.checkNotNullExpressionValue((Object)role, (String)"tenantRole(...)");
        return this.may(role, profileId);
    }

    public boolean mayProfileCreateOneOnOneChat(@NotNull TenantId tenantId, @NotNull ProfileId profileId) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        Role role = Role.itemRole((String)"CHAT_CREATE_ONE_TO_ONE", (String)AuthorizationContext.Companion.chatAppItemId(tenantId));
        Intrinsics.checkNotNullExpressionValue((Object)role, (String)"itemRole(...)");
        return this.may(role, profileId);
    }

    public boolean mayProfileCreateMultiUserChat(@NotNull TenantId tenantId, @NotNull ProfileId profileId) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        Role role = Role.itemRole((String)"CHAT_CREATE_MANY_TO_MANY", (String)AuthorizationContext.Companion.chatAppItemId(tenantId));
        Intrinsics.checkNotNullExpressionValue((Object)role, (String)"itemRole(...)");
        return this.may(role, profileId);
    }

    @NotNull
    public Map<ParticipantId, Boolean> mayInteractWithParticipants(@NotNull Set<? extends ParticipantId> participantIds, @NotNull ProfileId profileId) {
        Intrinsics.checkNotNullParameter(participantIds, (String)"participantIds");
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        Object[] objectArray = new PermissionAction[]{PermissionAction.USE, PermissionAction.READ};
        return this.mayAll(participantIds, SetsKt.setOf((Object[])objectArray), profileId);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public <T extends PermissionRole> Map<T, Boolean> mayAll(@NotNull Set<? extends T> itemsToCheck, @NotNull Set<? extends PermissionAction> permissionActions, @NotNull ProfileId userId) {
        void $this$associateWithTo$iv$iv;
        Iterable $this$map$iv;
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter(itemsToCheck, (String)"itemsToCheck");
        Intrinsics.checkNotNullParameter(permissionActions, (String)"permissionActions");
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        if (itemsToCheck.isEmpty()) {
            return MapsKt.emptyMap();
        }
        Iterable $this$flatMap$iv = itemsToCheck;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo22 = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$mapTo$iv$iv;
            PermissionRole item = (PermissionRole)element$iv$iv;
            boolean bl = false;
            $this$map$iv = permissionActions;
            boolean $i$f$map = false;
            Iterable iterable2 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void action;
                PermissionAction permissionAction = (PermissionAction)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl2 = false;
                collection.add(item.toActionRole((PermissionAction)action));
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Set rolesToCheck = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        Map authResults = this.hasRoles(rolesToCheck, userId);
        Iterable $this$associateWith$iv = itemsToCheck;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $i$f$flatMapTo22 = $this$associateWith$iv;
        Map destination$iv$iv3 = result$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            boolean bl;
            Map map;
            Object t;
            block8: {
                void $this$all$iv;
                void $this$mapTo$iv$iv;
                $this$map$iv = (PermissionRole)element$iv$iv;
                t = element$iv$iv;
                map = destination$iv$iv3;
                boolean bl3 = false;
                Iterable $this$map$iv2 = permissionActions;
                boolean $i$f$map = false;
                Iterable $i$f$mapTo = $this$map$iv2;
                Collection destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                boolean $i$f$mapTo2 = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void action;
                    void item;
                    PermissionAction bl2 = (PermissionAction)item$iv$iv;
                    Collection collection = destination$iv$iv4;
                    boolean bl4 = false;
                    collection.add(item.toActionRole((PermissionAction)action));
                }
                $this$map$iv2 = (List)destination$iv$iv4;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        Role role = (Role)element$iv;
                        boolean bl5 = false;
                        if (authResults.get(role) == AuthorizationResult.OK) continue;
                        bl = false;
                        break block8;
                    }
                    bl = true;
                }
            }
            Boolean bl6 = bl;
            map.put(t, bl6);
        }
        return destination$iv$iv3;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Map<Role, AuthorizationResult> hasRoles(@NotNull Set<Role> rolesToCheck, @NotNull ProfileId profileId) {
        void $this$associateWithTo$iv$iv;
        Intrinsics.checkNotNullParameter(rolesToCheck, (String)"rolesToCheck");
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        if (rolesToCheck.isEmpty()) {
            return MapsKt.emptyMap();
        }
        ImmutableMap authResults = this.permissionRequestConnector.hasRoles((Iterable)rolesToCheck, (Iterable)SetsKt.setOf((Object)profileId.toRole()));
        Iterable $this$associateWith$iv = rolesToCheck;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable iterable = $this$associateWith$iv;
        Map destination$iv$iv = result$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void it;
            Role role = (Role)element$iv$iv;
            Object t = element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            AuthorizationResult authorizationResult = (AuthorizationResult)authResults.get((Object)it);
            if (authorizationResult == null) {
                authorizationResult = AuthorizationResult.NOT_FOUND;
            }
            AuthorizationResult authorizationResult2 = authorizationResult;
            map.put(t, authorizationResult2);
        }
        return destination$iv$iv;
    }

    @NotNull
    public Set<Role> searchRolesBy(@NotNull ProfileId searchBy) {
        Intrinsics.checkNotNullParameter((Object)searchBy, (String)"searchBy");
        ImmutableSet immutableSet = this.permissionRequestConnector.searchRoles(searchBy.toRole());
        Intrinsics.checkNotNullExpressionValue((Object)immutableSet, (String)"searchRoles(...)");
        return (Set)immutableSet;
    }

    public void checkChatPermission(@NotNull ChatId chatId, @NotNull ProfileId profileId, @NotNull PermissionType permissionType) {
        Intrinsics.checkNotNullParameter((Object)chatId, (String)"chatId");
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        Intrinsics.checkNotNullParameter((Object)permissionType, (String)"permissionType");
        Boolean bl = (Boolean)this.hasPermissionForChats(SetsKt.setOf((Object)chatId), profileId, permissionType).get(chatId);
        if (bl == null) {
            throw new NotFoundException("Chat with id " + chatId + " does not exist");
        }
        if (Intrinsics.areEqual((Object)bl, (Object)false)) {
            throw new NotAllowedException("Failed permission check on " + chatId);
        }
        if (!Intrinsics.areEqual((Object)bl, (Object)true)) {
            throw new NoWhenBranchMatchedException();
        }
    }

    public void checkManageOrTempManageChat(@NotNull ChatId chatId, @NotNull ProfileId profileId) {
        Intrinsics.checkNotNullParameter((Object)chatId, (String)"chatId");
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        boolean hasManagers = this.filterChatIdsWithoutPermission((Iterable)SetsKt.setOf((Object)chatId), PermissionType.MANAGER).isEmpty();
        if (hasManagers) {
            this.checkChatPermission(chatId, profileId, PermissionType.MANAGER);
            return;
        }
        boolean hasWriters = this.filterChatIdsWithoutPermission((Iterable)SetsKt.setOf((Object)chatId), PermissionType.WRITER).isEmpty();
        if (hasWriters) {
            this.checkChatPermission(chatId, profileId, PermissionType.WRITER);
            return;
        }
        this.checkChatPermission(chatId, profileId, PermissionType.READER);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Set<ChatId> filterChatIdsWithoutPermission(@NotNull Iterable<ChatId> chatIds, @NotNull PermissionType permissionType) {
        Iterable $this$filterValues$iv;
        void $this$associateByTo$iv$iv$iv;
        void $this$mapValuesTo$iv$iv;
        Iterator $this$mapValues$iv;
        void $this$mapTo$iv$iv;
        Map $this$mapToSet$iv;
        void $this$filterValues$iv2;
        void $this$filterIsInstanceTo$iv$iv;
        Map $this$filterIsInstanceToSet$iv;
        Iterable iterable;
        Object $this$map$iv;
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv;
        Map permissions;
        Collection<Object> collection;
        Object item$iv$iv2;
        void $this$mapTo$iv$iv2;
        void $this$map$iv2;
        Intrinsics.checkNotNullParameter(chatIds, (String)"chatIds");
        Intrinsics.checkNotNullParameter((Object)permissionType, (String)"permissionType");
        Iterable<ChatId> iterable2 = chatIds;
        Object object = this.chatParticipantRepository;
        boolean $i$f$map232 = false;
        void var6_7 = $this$map$iv2;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
            ChatId chatId = (ChatId)item$iv$iv2;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(chatId.getValue());
        }
        Map $i$f$map232 = permissions = object.findByChatIds((Iterable)((List)destination$iv$iv));
        boolean $i$f$flatMap = false;
        destination$iv$iv = $this$flatMap$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$flatMapTo = false;
        item$iv$iv2 = $this$flatMapTo$iv$iv.entrySet().iterator();
        while (item$iv$iv2.hasNext()) {
            void $this$mapTo$iv$iv3;
            Map.Entry entry;
            Map.Entry entry2 = entry = (Map.Entry)item$iv$iv2.next();
            boolean bl2 = false;
            List participants = (List)entry2.getValue();
            $this$map$iv = participants;
            boolean $i$f$map = false;
            Iterable iterable3 = $this$map$iv;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv3 : $this$mapTo$iv$iv3) {
                void it;
                DbChatParticipant dbChatParticipant = (DbChatParticipant)item$iv$iv3;
                iterable = destination$iv$iv3;
                boolean bl3 = false;
                iterable.add(ParticipantId.Companion.fromCanonicalId(it.getParticipantId()));
            }
            Iterable iterable4 = (List)destination$iv$iv3;
            CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)iterable4);
        }
        $this$flatMap$iv = (List)destination$iv$iv2;
        boolean $i$f$filterIsInstanceToSet = false;
        $this$flatMapTo$iv$iv = $this$filterIsInstanceToSet$iv;
        Object destination$iv$iv3 = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)((Object)$this$filterIsInstanceToSet$iv)));
        boolean $i$f$filterIsInstanceTo = false;
        for (Object e : $this$filterIsInstanceTo$iv$iv) {
            if (!(e instanceof ProfileId)) continue;
            destination$iv$iv3.add(e);
        }
        Set profiles2 = (Set)destination$iv$iv3;
        boolean $i$a$-let-AuthorizationService$filterChatIdsWithoutPermission$activeOrBlockedProfilePermissions$332 = false;
        destination$iv$iv3 = this.profileService.findByIds(profiles2);
        boolean $i$f$filterValues = false;
        Object result$iv = new LinkedHashMap();
        for (Map.Entry entry : $this$filterValues$iv2.entrySet()) {
            Profile it = (Profile)entry.getValue();
            boolean bl = false;
            if (!(it.getStatus() == ProfileStatus.ACTIVE || it.getStatus() == ProfileStatus.BLOCKED)) continue;
            ((HashMap)result$iv).put(entry.getKey(), entry.getValue());
        }
        $this$filterIsInstanceToSet$iv = (Map)result$iv;
        boolean $i$f$mapToSet = false;
        void $i$a$-let-AuthorizationService$filterChatIdsWithoutPermission$activeOrBlockedProfilePermissions$332 = $this$mapToSet$iv;
        destination$iv$iv3 = new LinkedHashSet($this$mapToSet$iv.size());
        boolean $i$f$mapTo3 = false;
        result$iv = $this$mapTo$iv$iv.entrySet().iterator();
        while (result$iv.hasNext()) {
            Map.Entry entry;
            Map.Entry entry3 = entry = (Map.Entry)result$iv.next();
            object = destination$iv$iv3;
            boolean bl = false;
            object.add((ProfileId)entry3.getKey());
        }
        Set activeOrBlockedProfilePermissions = (Set)destination$iv$iv3;
        $this$mapToSet$iv = permissions;
        boolean $i$f$mapValues = false;
        $this$mapTo$iv$iv = $this$mapValues$iv;
        destination$iv$iv3 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        result$iv = $this$mapValuesTo$iv$iv.entrySet();
        Iterator iterator = destination$iv$iv3;
        boolean bl = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void $this$mapTo$iv$iv4;
            void $this$map$iv3;
            DbChatParticipant it;
            void $this$filterTo$iv$iv;
            void it$iv$iv;
            $this$map$iv = (Map.Entry)element$iv$iv$iv;
            Iterator iterator2 = iterator;
            boolean bl2 = false;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            collection = it$iv$iv.getKey();
            object = iterator2;
            boolean bl4 = false;
            List participants = (List)entry.getValue();
            Iterable $this$filter$iv = participants;
            boolean $i$f$filter = false;
            iterable = $this$filter$iv;
            Collection destination$iv$iv4 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (DbChatParticipant)element$iv$iv;
                boolean bl5 = false;
                ParticipantId participantId = ParticipantId.Companion.fromCanonicalId(it.getParticipantId());
                boolean bl3 = participantId instanceof ProfileId ? activeOrBlockedProfilePermissions.contains(participantId) : true;
                if (!bl3) continue;
                destination$iv$iv4.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv4;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv3;
            Collection destination$iv$iv5 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
            boolean $i$f$mapTo4 = false;
            for (Object item$iv$iv4 : $this$mapTo$iv$iv4) {
                void p0;
                it = (DbChatParticipant)item$iv$iv4;
                Collection collection2 = destination$iv$iv5;
                boolean bl7 = false;
                collection2.add(p0.getPermissionType());
            }
            List list = (List)destination$iv$iv5;
            object.put(collection, list);
        }
        $this$mapValues$iv = iterator;
        boolean $i$f$filterValues2 = false;
        Map result$iv2 = new LinkedHashMap();
        for (Map.Entry entry$iv : $this$filterValues$iv.entrySet()) {
            List it = (List)entry$iv.getValue();
            boolean bl4 = false;
            if (!(!it.contains(permissionType))) continue;
            ((HashMap)result$iv2).put(entry$iv.getKey(), entry$iv.getValue());
        }
        $this$filterValues$iv = ((Map)result$iv2).keySet();
        $i$f$mapToSet = false;
        result$iv2 = $this$mapToSet$iv;
        destination$iv$iv3 = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)((Object)$this$mapToSet$iv)));
        boolean $i$f$mapTo2 = false;
        for (Object t : $this$mapTo$iv$iv) {
            UUID uUID = (UUID)t;
            object = destination$iv$iv3;
            boolean bl5 = false;
            object.add(new ChatId(uUID));
        }
        return (Set)destination$iv$iv3;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Map<ChatId, Boolean> hasPermissionForChats(@NotNull Set<ChatId> chatIds, @NotNull ProfileId profileId, @NotNull PermissionType permissionType) {
        Object item$iv$iv;
        Map $this$mapTo$iv$iv;
        Map $this$map$iv;
        Intrinsics.checkNotNullParameter(chatIds, (String)"chatIds");
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        Intrinsics.checkNotNullParameter((Object)permissionType, (String)"permissionType");
        if (this.profileService.getById(profileId).getStatus() != ProfileStatus.ACTIVE) {
            void $this$associateWithTo$iv$iv;
            Iterable $this$associateWith$iv = chatIds;
            boolean $i$f$associateWith = false;
            LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
            Iterable iterable = $this$associateWith$iv;
            Map destination$iv$iv = result$iv;
            boolean $i$f$associateWithTo = false;
            for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
                ChatId chatId = (ChatId)element$iv$iv;
                Object t = element$iv$iv;
                Map map = destination$iv$iv;
                boolean bl = false;
                Boolean bl2 = false;
                map.put(t, bl2);
            }
            return destination$iv$iv;
        }
        Set userGroupsOfProfileId = this.userGroupService.getUserGroupIdsByProfileId(profileId);
        Iterable $i$f$associateWith = chatIds;
        Object object = this.chatParticipantRepository;
        boolean $i$f$map = false;
        void $this$associateWithTo$iv$iv = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)((Object)$this$map$iv), (int)10));
        boolean $i$f$mapTo = false;
        Iterator<Object> iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            item$iv$iv = iterator.next();
            ChatId it = (ChatId)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getValue());
        }
        $this$map$iv = object.findByChatIds((Iterable)((List)destination$iv$iv));
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList($this$map$iv.size());
        $i$f$mapTo = false;
        iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            void it;
            Object object2;
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            ChatParticipant it2;
            void $this$mapTo$iv$iv2;
            Iterable $this$map$iv2;
            Object object3 = item$iv$iv = (Map.Entry)iterator.next();
            object = destination$iv$iv;
            boolean bl = false;
            UUID uuid = (UUID)object3.getKey();
            List participants = (List)object3.getValue();
            Iterable iterable = participants;
            ChatId chatId = new ChatId(uuid);
            boolean $i$f$map2 = false;
            void var19_36 = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                DbChatParticipant dbChatParticipant = (DbChatParticipant)item$iv$iv2;
                Collection collection = destination$iv$iv2;
                boolean bl3 = false;
                collection.add(DbChatParticipant.Companion.toChatParticipant((DbChatParticipant)it2));
            }
            $this$map$iv2 = (List)destination$iv$iv2;
            boolean $i$f$filter22 = false;
            $this$mapTo$iv$iv2 = $this$filter$iv;
            destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                boolean bl4;
                it2 = (ChatParticipant)element$iv$iv;
                boolean bl5 = false;
                ParticipantId participantId = it2.getParticipantId();
                if (participantId instanceof ProfileId) {
                    bl4 = Intrinsics.areEqual((Object)profileId, (Object)it2.getParticipantId());
                } else if (participantId instanceof UserGroupId) {
                    bl4 = CollectionsKt.contains((Iterable)userGroupsOfProfileId, (Object)it2.getParticipantId());
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                if (!bl4) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            iterable = (List)destination$iv$iv2;
            PermissionType $i$f$filter22 = iterable.iterator();
            if (!$i$f$filter22.hasNext()) {
                object2 = null;
            } else {
                Object p0 = (ChatParticipant)$i$f$filter22.next();
                boolean bl6 = false;
                p0 = (Comparable)p0.getPermissionType();
                while ($i$f$filter22.hasNext()) {
                    ChatParticipant p02 = (ChatParticipant)$i$f$filter22.next();
                    $i$a$-maxOfOrNull-AuthorizationService$hasPermissionForChats$3$3 = false;
                    Comparable comparable = (Comparable)p02.getPermissionType();
                    if (p0.compareTo(comparable) >= 0) continue;
                    p0 = comparable;
                }
                object2 = p0;
            }
            $i$f$filter22 = (PermissionType)object2;
            boolean bl7 = false;
            void v2 = it;
            object.add(TuplesKt.to((Object)chatId, (Object)(v2 == null ? false : v2.compareTo((Enum)permissionType) >= 0)));
        }
        return MapsKt.toMap((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Map<ProfileId, Boolean> havePermission(@NotNull Map<ChatParticipant, ? extends Set<ProfileId>> profileIdsOfParticipants, @NotNull PermissionType permissionType) {
        void $this$associateWithTo$iv$iv;
        void $this$associateWith$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Intrinsics.checkNotNullParameter(profileIdsOfParticipants, (String)"profileIdsOfParticipants");
        Intrinsics.checkNotNullParameter((Object)permissionType, (String)"permissionType");
        Map<ChatParticipant, ? extends Set<ProfileId>> map = profileIdsOfParticipants;
        boolean $i$f$filter = false;
        void var6_5 = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry entry = element$iv$iv = iterator.next();
            boolean bl = false;
            ChatParticipant participant = (ChatParticipant)entry.getKey();
            if (!(participant.getPermissionType().compareTo((Enum)permissionType) >= 0)) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Set allowedProfileIds = CollectionUtilsKt.flattenValuesToSet((Map)destination$iv$iv);
        $this$filter$iv = CollectionUtilsKt.flattenValuesToSet(profileIdsOfParticipants);
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        destination$iv$iv = $this$associateWith$iv;
        Map destination$iv$iv2 = result$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void profileId;
            ProfileId bl = (ProfileId)element$iv$iv;
            Object t = element$iv$iv;
            Map map2 = destination$iv$iv2;
            boolean bl2 = false;
            Boolean bl3 = allowedProfileIds.contains(profileId);
            map2.put(t, bl3);
        }
        return destination$iv$iv2;
    }

    private boolean may(Role roleToCheck, ProfileId profileId) {
        Object v = this.may(SetsKt.setOf((Object)roleToCheck), profileId).get(roleToCheck);
        if (v == null) {
            String string = "Required value was null.";
            throw new IllegalStateException(string.toString());
        }
        return (Boolean)v;
    }

    /*
     * WARNING - void declaration
     */
    private Map<Role, Boolean> may(Set<Role> rolesToCheck, ProfileId profileId) {
        void $this$associateByTo$iv$iv$iv;
        void $this$mapValuesTo$iv$iv;
        Map $this$mapValues$iv = this.hasRoles(rolesToCheck, profileId);
        boolean $i$f$mapValues = false;
        Map map = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable iterable = $this$mapValuesTo$iv$iv.entrySet();
        Map destination$iv$iv$iv = destination$iv$iv;
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map2 = destination$iv$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map3 = map2;
            boolean bl2 = false;
            Boolean bl3 = it.getValue() == AuthorizationResult.OK;
            map3.put(k, bl3);
        }
        return destination$iv$iv$iv;
    }
}

