/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.authorization.totp;

import de.justsoftware.authorization.totp.TOTPAuthentication;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.DefaultRedirectStrategy;
import org.springframework.security.web.access.AccessDeniedHandlerImpl;
import org.springframework.security.web.savedrequest.HttpSessionRequestCache;
import org.springframework.security.web.savedrequest.RequestCache;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0014"}, d2={"Lde/justsoftware/authorization/totp/TotpAwareAccessDeniedHandler;", "Lorg/springframework/security/web/access/AccessDeniedHandlerImpl;", "<init>", "()V", "redirectHandler", "Lorg/springframework/security/web/DefaultRedirectStrategy;", "getRedirectHandler", "()Lorg/springframework/security/web/DefaultRedirectStrategy;", "requestCache", "Lorg/springframework/security/web/savedrequest/RequestCache;", "getRequestCache", "()Lorg/springframework/security/web/savedrequest/RequestCache;", "handle", "", "request", "Ljakarta/servlet/http/HttpServletRequest;", "response", "Ljakarta/servlet/http/HttpServletResponse;", "accessDeniedException", "Lorg/springframework/security/access/AccessDeniedException;", "just-authorization-server"})
public final class TotpAwareAccessDeniedHandler
extends AccessDeniedHandlerImpl {
    @NotNull
    private final DefaultRedirectStrategy redirectHandler = new DefaultRedirectStrategy();
    @NotNull
    private final RequestCache requestCache = (RequestCache)new HttpSessionRequestCache();

    public TotpAwareAccessDeniedHandler() {
        this.setErrorPage("/error");
    }

    @NotNull
    public final DefaultRedirectStrategy getRedirectHandler() {
        return this.redirectHandler;
    }

    @NotNull
    public final RequestCache getRequestCache() {
        return this.requestCache;
    }

    public void handle(@NotNull HttpServletRequest request, @NotNull HttpServletResponse response, @NotNull AccessDeniedException accessDeniedException) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        Intrinsics.checkNotNullParameter((Object)accessDeniedException, (String)"accessDeniedException");
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication instanceof TOTPAuthentication) {
            this.redirectHandler.sendRedirect(request, response, "/totp/login");
        } else {
            super.handle(request, response, accessDeniedException);
        }
    }
}

