/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.authorization.settings;

import de.justsoftware.authorization.id.TenantId;
import de.justsoftware.authorization.settings.SettingsRepository;
import de.justsoftware.authorization.settings.TenantSettings;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0012\u0010\r\u001a\u0004\u0018\u00010\t2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lde/justsoftware/authorization/settings/SettingsService;", "", "settingsRepo", "Lde/justsoftware/authorization/settings/SettingsRepository;", "<init>", "(Lde/justsoftware/authorization/settings/SettingsRepository;)V", "upsert", "", "tenantSettings", "Lde/justsoftware/authorization/settings/TenantSettings;", "insertIfTenantDoesNotExist", "tenantId", "Lde/justsoftware/authorization/id/TenantId;", "find", "delete", "just-authorization-server"})
public class SettingsService {
    @NotNull
    private final SettingsRepository settingsRepo;

    public SettingsService(@NotNull SettingsRepository settingsRepo) {
        Intrinsics.checkNotNullParameter((Object)settingsRepo, (String)"settingsRepo");
        this.settingsRepo = settingsRepo;
    }

    public void upsert(@NotNull TenantSettings tenantSettings) {
        Intrinsics.checkNotNullParameter((Object)tenantSettings, (String)"tenantSettings");
        this.settingsRepo.upsert(tenantSettings);
    }

    public void insertIfTenantDoesNotExist(@NotNull TenantId tenantId) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        if (this.find(tenantId) == null) {
            this.settingsRepo.insert(new TenantSettings(tenantId, false, 2, null));
        }
    }

    @Nullable
    public TenantSettings find(@NotNull TenantId tenantId) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        return this.settingsRepo.find(tenantId);
    }

    public void delete(@NotNull TenantId tenantId) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        this.settingsRepo.delete(tenantId);
    }
}

