/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.authorization.oauth2;

import de.justsoftware.authorization.oauth2.client.OauthTokenService;
import de.justsoftware.authorization.stats.UserStatsRepository;
import de.justsoftware.authorization.token.RememberMeTokenRepository;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.scheduling.annotation.Scheduled;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0005\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\b\u0010\r\u001a\u00020\u000eH\u0007J\b\u0010\u000f\u001a\u00020\u000eH\u0007J\b\u0010\u0010\u001a\u00020\u000eH\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lde/justsoftware/authorization/oauth2/TokenCleanupScheduler;", "", "oauthTokenService", "Lde/justsoftware/authorization/oauth2/client/OauthTokenService;", "oauthTokensExpiredSince", "Ljava/time/Duration;", "rememberMeTokenRepository", "Lde/justsoftware/authorization/token/RememberMeTokenRepository;", "rememberMeTokenExpiredSince", "userStatsRepository", "Lde/justsoftware/authorization/stats/UserStatsRepository;", "<init>", "(Lde/justsoftware/authorization/oauth2/client/OauthTokenService;Ljava/time/Duration;Lde/justsoftware/authorization/token/RememberMeTokenRepository;Ljava/time/Duration;Lde/justsoftware/authorization/stats/UserStatsRepository;)V", "deleteExpiredOauthTokens", "", "deleteExpiredRememberMeTokens", "deleteUserStatsFromDeletedProfiles", "just-authorization-server"})
public final class TokenCleanupScheduler {
    @NotNull
    private final OauthTokenService oauthTokenService;
    @NotNull
    private final Duration oauthTokensExpiredSince;
    @NotNull
    private final RememberMeTokenRepository rememberMeTokenRepository;
    @NotNull
    private final Duration rememberMeTokenExpiredSince;
    @NotNull
    private final UserStatsRepository userStatsRepository;

    public TokenCleanupScheduler(@NotNull OauthTokenService oauthTokenService, @NotNull Duration oauthTokensExpiredSince, @NotNull RememberMeTokenRepository rememberMeTokenRepository, @NotNull Duration rememberMeTokenExpiredSince, @NotNull UserStatsRepository userStatsRepository) {
        Intrinsics.checkNotNullParameter((Object)oauthTokenService, (String)"oauthTokenService");
        Intrinsics.checkNotNullParameter((Object)oauthTokensExpiredSince, (String)"oauthTokensExpiredSince");
        Intrinsics.checkNotNullParameter((Object)rememberMeTokenRepository, (String)"rememberMeTokenRepository");
        Intrinsics.checkNotNullParameter((Object)rememberMeTokenExpiredSince, (String)"rememberMeTokenExpiredSince");
        Intrinsics.checkNotNullParameter((Object)userStatsRepository, (String)"userStatsRepository");
        this.oauthTokenService = oauthTokenService;
        this.oauthTokensExpiredSince = oauthTokensExpiredSince;
        this.rememberMeTokenRepository = rememberMeTokenRepository;
        this.rememberMeTokenExpiredSince = rememberMeTokenExpiredSince;
        this.userStatsRepository = userStatsRepository;
    }

    @Scheduled(fixedDelay=1L, timeUnit=TimeUnit.DAYS)
    public final void deleteExpiredOauthTokens() {
        this.oauthTokenService.deleteExpiredTokens(this.oauthTokensExpiredSince);
    }

    @Scheduled(fixedDelay=1L, timeUnit=TimeUnit.DAYS)
    public final void deleteExpiredRememberMeTokens() {
        this.rememberMeTokenRepository.deleteExpiredTokens(this.rememberMeTokenExpiredSince);
    }

    @Scheduled(fixedDelay=1L, timeUnit=TimeUnit.DAYS)
    public final void deleteUserStatsFromDeletedProfiles() {
        this.userStatsRepository.deleteStatsFromDeletedProfiles();
    }
}

