/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.authorization.controller;

import de.justsoftware.authorization.controller.TOTPSecretDto;
import de.justsoftware.authorization.totp.TOTPAuthentication;
import de.justsoftware.authorization.totp.TOTPAuthenticationService;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.core.env.Environment;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.csrf.CsrfToken;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.ui.ModelExtensionsKt;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(value={"/totp"})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J$\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\n\b\u0003\u0010\u0010\u001a\u0004\u0018\u00010\u000bH\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0011"}, d2={"Lde/justsoftware/authorization/controller/TOTPLoginController;", "", "totpAuthenticationService", "Lde/justsoftware/authorization/totp/TOTPAuthenticationService;", "env", "Lorg/springframework/core/env/Environment;", "<init>", "(Lde/justsoftware/authorization/totp/TOTPAuthenticationService;Lorg/springframework/core/env/Environment;)V", "getEnv", "()Lorg/springframework/core/env/Environment;", "showTOTPLoginPage", "", "model", "Lorg/springframework/ui/Model;", "csrfToken", "Lorg/springframework/security/web/csrf/CsrfToken;", "error", "just-authorization-server"})
public class TOTPLoginController {
    @NotNull
    private final TOTPAuthenticationService totpAuthenticationService;
    @NotNull
    private final Environment env;

    public TOTPLoginController(@NotNull TOTPAuthenticationService totpAuthenticationService, @NotNull Environment env) {
        Intrinsics.checkNotNullParameter((Object)totpAuthenticationService, (String)"totpAuthenticationService");
        Intrinsics.checkNotNullParameter((Object)env, (String)"env");
        this.totpAuthenticationService = totpAuthenticationService;
        this.env = env;
    }

    @NotNull
    public Environment getEnv() {
        return this.env;
    }

    @GetMapping(value={"/login"})
    @NotNull
    public String showTOTPLoginPage(@NotNull Model model, @NotNull CsrfToken csrfToken, @RequestParam(value="error", required=false) @Nullable String error) {
        boolean hasError;
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)csrfToken, (String)"csrfToken");
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        Intrinsics.checkNotNullExpressionValue((Object)authentication, (String)"getAuthentication(...)");
        Authentication authentication2 = authentication;
        TOTPAuthentication totpAuth = (TOTPAuthentication)authentication2;
        String[] stringArray = this.getEnv().getActiveProfiles();
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"getActiveProfiles(...)");
        ModelExtensionsKt.set((Model)model, (String)"devMode", (Object)ArraysKt.contains((Object[])stringArray, (Object)"dev"));
        ModelExtensionsKt.set((Model)model, (String)"csrf", (Object)csrfToken.getToken());
        boolean bl = hasError = error != null;
        if (hasError) {
            ModelExtensionsKt.set((Model)model, (String)"totpError", (Object)true);
        }
        String string = totpAuth.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        if (!this.totpAuthenticationService.userHasConfirmedTOTPDevice(string)) {
            String string2 = totpAuth.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
            TOTPSecretDto result = this.totpAuthenticationService.getOrCreateNewDevice(string2, !hasError);
            ModelExtensionsKt.set((Model)model, (String)"data", (Object)result);
        }
        return "totp-login";
    }

    public static /* synthetic */ String showTOTPLoginPage$default(TOTPLoginController tOTPLoginController, Model model, CsrfToken csrfToken, String string, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: showTOTPLoginPage");
        }
        if ((n & 4) != 0) {
            string = null;
        }
        return tOTPLoginController.showTOTPLoginPage(model, csrfToken, string);
    }
}

