/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.admin.kafka.consumer;

import de.justsoftware.admin.application.kafka.KafkaConsumerApplicationService;
import de.justsoftware.admin.domain.user.model.UserGroup;
import de.justsoftware.admin.id.UserGroupId;
import de.justsoftware.admin.kafka.consumer.KafkaConsumer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.kafka.annotation.KafkaListener;
import org.springframework.messaging.handler.annotation.Header;
import org.springframework.messaging.handler.annotation.Payload;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0017\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001e\u0010\b\u001a\u00020\t2\b\b\u0001\u0010\n\u001a\u00020\u00022\n\b\u0001\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u0017R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lde/justsoftware/admin/kafka/consumer/KafkaUserGroupConsumer;", "Lde/justsoftware/admin/kafka/consumer/KafkaConsumer;", "", "Lde/justsoftware/admin/domain/user/model/UserGroup;", "kafkaConsumerApplicationService", "Lde/justsoftware/admin/application/kafka/KafkaConsumerApplicationService;", "<init>", "(Lde/justsoftware/admin/application/kafka/KafkaConsumerApplicationService;)V", "listen", "", "key", "payload", "admin-service"})
public class KafkaUserGroupConsumer
implements KafkaConsumer<String, UserGroup> {
    @NotNull
    private final KafkaConsumerApplicationService kafkaConsumerApplicationService;

    public KafkaUserGroupConsumer(@NotNull KafkaConsumerApplicationService kafkaConsumerApplicationService) {
        Intrinsics.checkNotNullParameter((Object)kafkaConsumerApplicationService, (String)"kafkaConsumerApplicationService");
        this.kafkaConsumerApplicationService = kafkaConsumerApplicationService;
    }

    @KafkaListener(containerFactory="userGroupListenerContainerFactory", topics={"just.people.userGroup"})
    public void listen(@Header(value="kafka_receivedMessageKey") @NotNull String key, @Payload(required=false) @Nullable UserGroup payload) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        if (payload == null) {
            this.kafkaConsumerApplicationService.deleteUserGroupFromKafka(UserGroupId.Companion.fromString(key));
        } else {
            this.kafkaConsumerApplicationService.saveUserGroupFromKafka(payload);
        }
    }
}

