/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.admin.domain.user.persistence;

import de.justsoftware.admin.domain.user.model.Profile;
import de.justsoftware.admin.domain.user.persistence.repository.ProfileRepository;
import de.justsoftware.admin.id.ProfileId;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Repository;

@Repository
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u001e\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u001c\u0010\r\u001a\b\u0012\u0004\u0012\u00020\t0\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\f0\u0010H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lde/justsoftware/admin/domain/user/persistence/ProfileDao;", "", "repository", "Lde/justsoftware/admin/domain/user/persistence/repository/ProfileRepository;", "<init>", "(Lde/justsoftware/admin/domain/user/persistence/repository/ProfileRepository;)V", "save", "", "profile", "Lde/justsoftware/admin/domain/user/model/Profile;", "delete", "id", "Lde/justsoftware/admin/id/ProfileId;", "getByIds", "", "ids", "", "admin-service"})
public class ProfileDao {
    @NotNull
    private final ProfileRepository repository;

    public ProfileDao(@NotNull ProfileRepository repository) {
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        this.repository = repository;
    }

    public void save(@NotNull Profile profile) {
        Intrinsics.checkNotNullParameter((Object)profile, (String)"profile");
        this.repository.insertOrUpdate(profile.getId(), profile.getTenantId(), profile.getFirstName(), profile.getLastName(), profile.getEmail(), profile.getImageUrl(), profile.getActive(), profile.getBlocked());
    }

    public void delete(@NotNull ProfileId id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        this.repository.delete(id);
    }

    @NotNull
    public Set<Profile> getByIds(@NotNull Collection<ProfileId> ids) {
        Intrinsics.checkNotNullParameter(ids, (String)"ids");
        if (ids.isEmpty()) {
            return SetsKt.emptySet();
        }
        return this.repository.getByIds(ids);
    }
}

