/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.admin.connector.wiki;

import de.justsoftware.admin.application.web.wiki.WikiSettings;
import de.justsoftware.admin.connector.wiki.WikiAppConnectorException;
import de.justsoftware.admin.id.TenantId;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestClient;

@Service
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lde/justsoftware/admin/connector/wiki/WikiAppConnector;", "", "wikiClient", "Lorg/springframework/web/client/RestClient;", "<init>", "(Lorg/springframework/web/client/RestClient;)V", "setArticleVersionHistoryReadPermission", "", "role", "Lde/justsoftware/admin/application/web/wiki/WikiSettings$RoleToReadVersionHistory;", "tenantId", "Lde/justsoftware/admin/id/TenantId;", "getArticleVersionHistoryReadPermission", "admin-service"})
public class WikiAppConnector {
    @NotNull
    private final RestClient wikiClient;

    public WikiAppConnector(@Qualifier(value="wikiClient") @NotNull RestClient wikiClient) {
        Intrinsics.checkNotNullParameter((Object)wikiClient, (String)"wikiClient");
        this.wikiClient = wikiClient;
    }

    public void setArticleVersionHistoryReadPermission(@NotNull WikiSettings.RoleToReadVersionHistory role, @NotNull TenantId tenantId) {
        Intrinsics.checkNotNullParameter((Object)role, (String)"role");
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        ResponseEntity it = ((RestClient.RequestBodySpec)this.wikiClient.post().uri("/permissions/article_version_history/" + tenantId + "/" + role, new Object[0])).retrieve().toEntity(Map.class);
        boolean bl = false;
        if (it.getStatusCode() != HttpStatus.OK) {
            throw new WikiAppConnectorException(it.getStatusCode().toString());
        }
    }

    @NotNull
    public WikiSettings.RoleToReadVersionHistory getArticleVersionHistoryReadPermission(@NotNull TenantId tenantId) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        ResponseEntity it = this.wikiClient.get().uri("/permissions/article_version_history/" + tenantId, new Object[0]).retrieve().toEntity(WikiSettings.RoleToReadVersionHistory.class);
        boolean bl = false;
        WikiSettings.RoleToReadVersionHistory roleToReadVersionHistory = (WikiSettings.RoleToReadVersionHistory)it.getBody();
        if (roleToReadVersionHistory == null) {
            throw new WikiAppConnectorException(null, 1, null);
        }
        return roleToReadVersionHistory;
    }
}

