/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.admin.connector.llm;

import de.justsoftware.admin.connector.llm.LlmApiConnector;
import de.justsoftware.admin.connector.llm.exceptions.BadCredentialsException;
import de.justsoftware.admin.connector.llm.exceptions.RateLimitExceededException;
import de.justsoftware.admin.connector.superoperty.SuperopertyConnector;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.reactivestreams.Publisher;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;
import org.springframework.web.reactive.function.client.ClientResponse;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Service
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u0017\u0018\u0000 \u001b2\u00020\u0001:\u0006\u0016\u0017\u0018\u0019\u001a\u001bB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J$\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\t2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000bH\u0016J\u001e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000bH\u0012J\b\u0010\u0014\u001a\u00020\u0015H\u0012R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001c"}, d2={"Lde/justsoftware/admin/connector/llm/LlmApiConnector;", "", "superopertyConnector", "Lde/justsoftware/admin/connector/superoperty/SuperopertyConnector;", "<init>", "(Lde/justsoftware/admin/connector/superoperty/SuperopertyConnector;)V", "getSuperopertyConnector", "()Lde/justsoftware/admin/connector/superoperty/SuperopertyConnector;", "getStreamableModels", "Ljava/util/concurrent/CompletableFuture;", "", "", "baseUrl", "apiKey", "supportsStreaming", "Lreactor/core/publisher/Mono;", "", "client", "Lorg/springframework/web/reactive/function/client/WebClient;", "model", "checkSuperopertyAiAssistanceToggle", "", "Model", "ModelResponse", "Delta", "Choice", "ChatCompletionResponse", "Companion", "admin-service"})
@SourceDebugExtension(value={"SMAP\nLlmApiConnector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LlmApiConnector.kt\nde/justsoftware/admin/connector/llm/LlmApiConnector\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,93:1\n1#2:94\n*E\n"})
public class LlmApiConnector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SuperopertyConnector superopertyConnector;
    private static final int MAX_CONCURRENT_REQUESTS = 5;

    public LlmApiConnector(@NotNull SuperopertyConnector superopertyConnector) {
        Intrinsics.checkNotNullParameter((Object)superopertyConnector, (String)"superopertyConnector");
        this.superopertyConnector = superopertyConnector;
    }

    @NotNull
    public SuperopertyConnector getSuperopertyConnector() {
        return this.superopertyConnector;
    }

    @NotNull
    public CompletableFuture<List<String>> getStreamableModels(@NotNull String baseUrl, @NotNull String apiKey) {
        Intrinsics.checkNotNullParameter((Object)baseUrl, (String)"baseUrl");
        Intrinsics.checkNotNullParameter((Object)apiKey, (String)"apiKey");
        this.checkSuperopertyAiAssistanceToggle();
        String[] stringArray = new String[]{"Bearer " + apiKey};
        WebClient.Builder builder = WebClient.builder().baseUrl(baseUrl).defaultHeader("Authorization", stringArray);
        stringArray = new String[]{"application/json"};
        WebClient webClient = builder.defaultHeader("Content-Type", stringArray).build();
        Intrinsics.checkNotNullExpressionValue((Object)webClient, (String)"build(...)");
        WebClient client = webClient;
        CompletableFuture completableFuture = client.get().uri("/models", new Object[0]).retrieve().onStatus(LlmApiConnector::getStreamableModels$lambda$0, LlmApiConnector::getStreamableModels$lambda$1).onStatus(LlmApiConnector::getStreamableModels$lambda$2, LlmApiConnector::getStreamableModels$lambda$3).bodyToMono(ModelResponse.class).flatMapMany(arg_0 -> LlmApiConnector.getStreamableModels$lambda$5(LlmApiConnector::getStreamableModels$lambda$4, arg_0)).flatMap(arg_0 -> LlmApiConnector.getStreamableModels$lambda$9(arg_0 -> LlmApiConnector.getStreamableModels$lambda$8(this, client, arg_0), arg_0), 5).map(arg_0 -> LlmApiConnector.getStreamableModels$lambda$11(LlmApiConnector::getStreamableModels$lambda$10, arg_0)).collectList().toFuture();
        Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"toFuture(...)");
        return completableFuture;
    }

    private Mono<Boolean> supportsStreaming(WebClient client, String model) {
        Mono mono = new Pair[3];
        mono[0] = TuplesKt.to((Object)"model", (Object)model);
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"role", (Object)"user"), TuplesKt.to((Object)"content", (Object)"ping")};
        mono[1] = TuplesKt.to((Object)"messages", (Object)CollectionsKt.listOf((Object)MapsKt.mapOf((Pair[])pairArray)));
        mono[2] = TuplesKt.to((Object)"stream", (Object)true);
        Map body2 = MapsKt.mapOf((Pair[])mono);
        pairArray = new MediaType[]{MediaType.APPLICATION_JSON};
        mono = ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)client.post().uri("/chat/completions", new Object[0])).contentType(MediaType.APPLICATION_JSON).accept((MediaType[])pairArray)).bodyValue((Object)body2).retrieve().onStatus(LlmApiConnector::supportsStreaming$lambda$12, LlmApiConnector::supportsStreaming$lambda$13).onStatus(LlmApiConnector::supportsStreaming$lambda$14, LlmApiConnector::supportsStreaming$lambda$15).onStatus(LlmApiConnector::supportsStreaming$lambda$16, LlmApiConnector::supportsStreaming$lambda$17).bodyToFlux(ChatCompletionResponse.class).mapNotNull(arg_0 -> LlmApiConnector.supportsStreaming$lambda$19(LlmApiConnector::supportsStreaming$lambda$18, arg_0)).take(1L).hasElements();
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"hasElements(...)");
        return mono;
    }

    private void checkSuperopertyAiAssistanceToggle() {
        if (!this.getSuperopertyConnector().isAiAssistantAllowed()) {
            boolean bl = false;
            String string = "AI assistance is not enabled";
            throw new IllegalArgumentException(string.toString());
        }
    }

    private static final boolean getStreamableModels$lambda$0(HttpStatusCode it) {
        return it == HttpStatus.UNAUTHORIZED;
    }

    private static final Mono getStreamableModels$lambda$1(ClientResponse it) {
        return Mono.error((Throwable)((Throwable)new BadCredentialsException(null, 1, null)));
    }

    private static final boolean getStreamableModels$lambda$2(HttpStatusCode it) {
        return it == HttpStatus.TOO_MANY_REQUESTS;
    }

    private static final Mono getStreamableModels$lambda$3(ClientResponse it) {
        return Mono.error((Throwable)((Throwable)new RateLimitExceededException(null, 1, null)));
    }

    private static final Publisher getStreamableModels$lambda$4(ModelResponse response) {
        return (Publisher)Flux.fromIterable((Iterable)response.getData());
    }

    private static final Publisher getStreamableModels$lambda$5(Function1 $tmp0, Object p0) {
        return (Publisher)$tmp0.invoke(p0);
    }

    private static final String getStreamableModels$lambda$8$lambda$6(Model $model, Boolean supported) {
        return supported != false ? $model.getId() : null;
    }

    private static final String getStreamableModels$lambda$8$lambda$7(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }

    private static final Publisher getStreamableModels$lambda$8(LlmApiConnector this$0, WebClient $client, Model model) {
        return (Publisher)this$0.supportsStreaming($client, model.getId()).mapNotNull(arg_0 -> LlmApiConnector.getStreamableModels$lambda$8$lambda$7(arg_0 -> LlmApiConnector.getStreamableModels$lambda$8$lambda$6(model, arg_0), arg_0));
    }

    private static final Publisher getStreamableModels$lambda$9(Function1 $tmp0, Object p0) {
        return (Publisher)$tmp0.invoke(p0);
    }

    private static final String getStreamableModels$lambda$10(String it) {
        String string = it;
        Intrinsics.checkNotNull((Object)string);
        return string;
    }

    private static final String getStreamableModels$lambda$11(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }

    private static final boolean supportsStreaming$lambda$12(HttpStatusCode it) {
        return it == HttpStatus.UNAUTHORIZED;
    }

    private static final Mono supportsStreaming$lambda$13(ClientResponse it) {
        return Mono.error((Throwable)((Throwable)new BadCredentialsException(null, 1, null)));
    }

    private static final boolean supportsStreaming$lambda$14(HttpStatusCode it) {
        return it == HttpStatus.TOO_MANY_REQUESTS;
    }

    private static final Mono supportsStreaming$lambda$15(ClientResponse it) {
        return Mono.error((Throwable)((Throwable)new RateLimitExceededException(null, 1, null)));
    }

    private static final boolean supportsStreaming$lambda$16(HttpStatusCode it) {
        return it.is4xxClientError();
    }

    private static final Mono supportsStreaming$lambda$17(ClientResponse it) {
        return Mono.empty();
    }

    private static final String supportsStreaming$lambda$18(ChatCompletionResponse chunk) {
        List list = chunk.getChoices();
        return list != null && (list = (Choice)CollectionsKt.getOrNull((List)list, (int)0)) != null && (list = list.getDelta()) != null ? list.getContent() : null;
    }

    private static final String supportsStreaming$lambda$19(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }
}

