/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.admin.application.web.drive;

import de.justsoftware.admin.application.web.drive.DriveApplicationService;
import de.justsoftware.admin.application.web.drive.DriveSettings;
import de.justsoftware.admin.authorization.AuthorizationContext;
import de.justsoftware.admin.connector.drive.DriveApiConnector;
import de.justsoftware.admin.graphql.generated.types.DriveSettingsInput;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001:\u0001\u0012B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0006\u001a\u00060\u0007R\u00020\u0000X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0013"}, d2={"Lde/justsoftware/admin/application/web/drive/DriveApplicationService;", "", "driveApiConnector", "Lde/justsoftware/admin/connector/drive/DriveApiConnector;", "<init>", "(Lde/justsoftware/admin/connector/drive/DriveApiConnector;)V", "antiVirus", "Lde/justsoftware/admin/application/web/drive/DriveApplicationService$AntiVirus;", "getAntiVirus", "()Lde/justsoftware/admin/application/web/drive/DriveApplicationService$AntiVirus;", "getSettings", "Lde/justsoftware/admin/application/web/drive/DriveSettings;", "authContext", "Lde/justsoftware/admin/authorization/AuthorizationContext;", "updateSettings", "", "input", "Lde/justsoftware/admin/graphql/generated/types/DriveSettingsInput;", "AntiVirus", "admin-service"})
public class DriveApplicationService {
    @NotNull
    private final DriveApiConnector driveApiConnector;
    @NotNull
    private final AntiVirus antiVirus;

    public DriveApplicationService(@NotNull DriveApiConnector driveApiConnector) {
        Intrinsics.checkNotNullParameter((Object)driveApiConnector, (String)"driveApiConnector");
        this.driveApiConnector = driveApiConnector;
        this.antiVirus = new AntiVirus(this);
    }

    @NotNull
    public AntiVirus getAntiVirus() {
        return this.antiVirus;
    }

    @NotNull
    public DriveSettings getSettings(@NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        authContext.checkTenantManager();
        return this.driveApiConnector.getDriveSettings(authContext.getNonNullTenantId());
    }

    public void updateSettings(@NotNull DriveSettingsInput input, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        authContext.checkTenantManager();
        if (input.getPublicLinksEnabled() != null) {
            this.driveApiConnector.setDrivePublicLinksEnabled(input.getPublicLinksEnabled().booleanValue());
        }
        if (input.getAntivirusEnabled() != null) {
            this.driveApiConnector.getAntiVirus().setEnabled(input.getAntivirusEnabled().booleanValue());
        }
    }

    public static final /* synthetic */ DriveApiConnector access$getDriveApiConnector$p(DriveApplicationService $this) {
        return $this.driveApiConnector;
    }
}

