/*
 * Decompiled with CFR 0.152.
 */
package org.semver4j.internal;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.semver4j.Semver;

public class Comparator
implements Comparable<Semver> {
    @NotNull
    private static final String UNDEFINED_MARKER = "undef";
    @NotNull
    private final Semver version;

    public Comparator(@NotNull Semver version) {
        this.version = version;
    }

    @Override
    public int compareTo(@NotNull Semver other) {
        int result = this.mainCompare(other);
        if (result == 0) {
            return this.preReleaseCompare(other);
        }
        return result;
    }

    private int mainCompare(@NotNull Semver other) {
        int majorCompare = this.compareIdentifiers(this.version.getMajor(), other.getMajor());
        if (majorCompare == 0) {
            int minorCompare = this.compareIdentifiers(this.version.getMinor(), other.getMinor());
            if (minorCompare == 0) {
                return this.compareIdentifiers(this.version.getPatch(), other.getPatch());
            }
            return minorCompare;
        }
        return majorCompare;
    }

    private int preReleaseCompare(@NotNull Semver other) {
        if (!this.version.getPreRelease().isEmpty() && other.getPreRelease().isEmpty()) {
            return -1;
        }
        if (this.version.getPreRelease().isEmpty() && !other.getPreRelease().isEmpty()) {
            return 1;
        }
        if (this.version.getPreRelease().isEmpty() && other.getPreRelease().isEmpty()) {
            return 0;
        }
        int maxElements = Math.max(this.version.getPreRelease().size(), other.getPreRelease().size());
        int i = 0;
        do {
            String a = this.getString(i, this.version.getPreRelease());
            String b = this.getString(i, other.getPreRelease());
            ++i;
            if (a.equals(UNDEFINED_MARKER) && b.equals(UNDEFINED_MARKER)) {
                return 0;
            }
            if (b.equals(UNDEFINED_MARKER)) {
                return 1;
            }
            if (a.equals(UNDEFINED_MARKER)) {
                return -1;
            }
            if (a.equals(b)) continue;
            return this.compareIdentifiers(a, b);
        } while (maxElements > i);
        return 0;
    }

    private int compareIdentifiers(@NotNull String a, @NotNull String b) {
        try {
            long aAsLong = Long.parseLong(a);
            long bAsLong = Long.parseLong(b);
            return this.compareIdentifiers(aAsLong, bAsLong);
        }
        catch (NumberFormatException aAsLong) {
            String[] tokenArr2;
            String digitsExtract;
            String[] tokenArr1;
            if (this.isBothContainsDigits(a, b) && (tokenArr1 = a.split(digitsExtract = "(?<=\\D)(?=\\d)"))[0].equals((tokenArr2 = b.split(digitsExtract))[0])) {
                long digitA = Long.parseLong(tokenArr1[1]);
                long digitB = Long.parseLong(tokenArr2[1]);
                return this.compareIdentifiers(digitA, digitB);
            }
            int i = a.compareTo(b);
            if (i > 0) {
                return 1;
            }
            if (i < 0) {
                return -1;
            }
            return 0;
        }
    }

    private int compareIdentifiers(long a, long b) {
        return Long.compare(a, b);
    }

    private boolean isBothContainsDigits(@NotNull String a, @NotNull String b) {
        return a.matches(".*\\d.*") && b.matches(".*\\d.*");
    }

    @NotNull
    private String getString(int i, @NotNull @NotNull List<@NotNull String> list) {
        try {
            return list.get(i);
        }
        catch (IndexOutOfBoundsException e) {
            return UNDEFINED_MARKER;
        }
    }
}

