/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cli;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.security.GeneralSecurityException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.zip.GZIPInputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.solr.cli.CLIO;
import org.apache.solr.cli.SolrCLI;
import org.apache.solr.cli.ToolBase;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.common.util.Utils;
import org.apache.solr.util.RTimer;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class PostTool
extends ToolBase {
    public static final String DEFAULT_FILE_TYPES = "xml,json,jsonl,csv,pdf,doc,docx,ppt,pptx,xls,xlsx,odt,odp,ods,ott,otp,ots,rtf,htm,html,txt,log";
    static final String DATA_MODE_FILES = "files";
    static final String DATA_MODE_ARGS = "args";
    static final String DATA_MODE_STDIN = "stdin";
    static final String DEFAULT_DATA_MODE = "files";
    static final String FORMAT_SOLR = "solr";
    static final String DATA_MODE_WEB = "web";
    private static final int DEFAULT_WEB_DELAY = 10;
    private static final int MAX_WEB_DEPTH = 10;
    public static final String DEFAULT_CONTENT_TYPE = "application/json";
    int recursive = 0;
    int delay = 0;
    String fileTypes = "xml,json,jsonl,csv,pdf,doc,docx,ppt,pptx,xls,xlsx,odt,odp,ods,ott,otp,ots,rtf,htm,html,txt,log";
    URL solrUpdateUrl;
    String credentials;
    OutputStream out = null;
    String type;
    String format;
    String mode = "files";
    boolean commit;
    boolean optimize;
    boolean dryRun;
    String[] args;
    boolean auto = true;
    private int currentDepth;
    static HashMap<String, String> mimeMap;
    FileFilter fileFilter;
    List<LinkedHashSet<URI>> backlog = new ArrayList<LinkedHashSet<URI>>();
    Set<URI> visited = new HashSet<URI>();
    static final Set<String> DATA_MODES;
    PageFetcher pageFetcher = new PageFetcher();

    public PostTool() {
        this(CLIO.getOutStream());
    }

    public PostTool(PrintStream stdout) {
        super(stdout);
    }

    @Override
    public String getName() {
        return "post";
    }

    @Override
    public List<Option> getOptions() {
        return List.of(Option.builder((String)"url").argName("url").longOpt("solr-update-url").hasArg().required(false).desc("Solr Update URL, the full url to the update handler, including the /update.").build(), Option.builder((String)"c").longOpt("name").argName("NAME").hasArg().required(false).desc("Name of the collection.").build(), Option.builder((String)"skipcommit").required(false).desc("Do not 'commit', and thus changes won't be visible till a commit occurs.").build(), Option.builder((String)"optimize").required(false).desc("Issue an optimize at end of posting documents.").build(), Option.builder((String)"mode").argName("mode").hasArg(true).required(false).desc("Files crawls files, web crawls website, args processes input args, and stdin reads a command from standard in. default: files.").build(), Option.builder((String)"recursive").argName("recursive").hasArg(true).required(false).desc("For web crawl, how deep to go. default: 1").build(), Option.builder((String)"delay").argName("delay").hasArg(true).required(false).desc("If recursive then delay will be the wait time between posts.  default: 10 for web, 0 for files").build(), Option.builder((String)"type").argName("content-type").hasArg(true).required(false).desc("Specify a specific mimetype to use, such as application/json.").build(), Option.builder((String)"filetypes").argName("<type>[,<type>,...]").hasArg(true).required(false).desc("default: xml,json,jsonl,csv,pdf,doc,docx,ppt,pptx,xls,xlsx,odt,odp,ods,ott,otp,ots,rtf,htm,html,txt,log").build(), Option.builder((String)"params").argName("<key>=<value>[&<key>=<value>...]").hasArg(true).required(false).desc("values must be URL-encoded; these pass through to Solr update request.").build(), Option.builder((String)"out").required(false).desc("sends Solr response outputs to console").build(), Option.builder((String)"format").required(false).desc("sends application/json content as Solr commands to /update instead of /update/json/docs.").build(), Option.builder().longOpt("dry-run").required(false).desc("Performs a dry run of the posting process without actually sending documents to Solr.  Only works with files mode.").build());
    }

    @Override
    public void runImpl(CommandLine cli) throws Exception {
        Object url;
        SolrCLI.raiseLogLevelUnlessVerbose(cli);
        this.solrUpdateUrl = null;
        if (cli.hasOption("url")) {
            url = cli.getOptionValue("url");
            this.solrUpdateUrl = new URL((String)url);
        } else if (cli.hasOption("c")) {
            url = SolrCLI.getDefaultSolrUrl() + "/solr/" + cli.getOptionValue("c") + "/update";
            this.solrUpdateUrl = new URL((String)url);
        } else {
            throw new IllegalArgumentException("Must specify either -url or -c parameter to post documents.");
        }
        if (cli.hasOption("mode")) {
            this.mode = cli.getOptionValue("mode");
        }
        if (cli.hasOption("dry-run")) {
            this.dryRun = true;
        }
        if (cli.hasOption("type")) {
            this.type = cli.getOptionValue("type");
            this.auto = false;
        }
        String string = this.format = cli.hasOption("format") ? FORMAT_SOLR : "";
        if (cli.hasOption("filetypes")) {
            this.fileTypes = cli.getOptionValue("filetypes");
        }
        int defaultDelay = this.mode.equals(DATA_MODE_WEB) ? 10 : 0;
        this.delay = Integer.parseInt(cli.getOptionValue("delay", String.valueOf(defaultDelay)));
        this.recursive = Integer.parseInt(cli.getOptionValue("recursive", "1"));
        this.out = cli.hasOption("out") ? CLIO.getOutStream() : null;
        this.commit = !cli.hasOption("skipcommit");
        this.optimize = cli.hasOption("optimize");
        this.args = cli.getArgs();
        this.execute();
    }

    public void execute() throws SolrServerException, IOException {
        RTimer timer = new RTimer();
        if ("files".equals(this.mode)) {
            this.doFilesMode();
        } else if (DATA_MODE_ARGS.equals(this.mode)) {
            this.doArgsMode(this.args);
        } else if (DATA_MODE_WEB.equals(this.mode)) {
            this.doWebMode();
        } else if (DATA_MODE_STDIN.equals(this.mode)) {
            this.doStdinMode();
        } else {
            return;
        }
        if (this.commit) {
            this.commit();
        }
        if (this.optimize) {
            this.optimize();
        }
        this.displayTiming((long)timer.getTime());
    }

    private void doFilesMode() {
        this.currentDepth = 0;
        PostTool.info("Posting files to [base] url " + this.solrUpdateUrl + (String)(!this.auto ? " using content-type " + (this.type == null ? DEFAULT_CONTENT_TYPE : this.type) : "") + "...");
        if (this.auto) {
            PostTool.info("Entering auto mode. File endings considered are " + this.fileTypes);
        }
        if (this.recursive > 0 && this.recursionPossible(this.args)) {
            PostTool.info("Entering recursive mode, max depth=" + this.recursive + ", delay=" + this.delay + "s");
        }
        this.fileFilter = this.getFileFilterFromFileTypes(this.fileTypes);
        int numFilesPosted = this.postFiles(this.args, 0, this.out, this.type);
        if (this.dryRun) {
            PostTool.info("Dry run complete. " + numFilesPosted + " would have been indexed.");
        } else {
            PostTool.info(numFilesPosted + " files indexed.");
        }
    }

    private void doArgsMode(String[] args) {
        PostTool.info("POSTing args to " + this.solrUpdateUrl + "...");
        for (String a : args) {
            this.postData(PostTool.stringToStream(a), null, this.out, this.type, this.solrUpdateUrl);
        }
    }

    private void doWebMode() {
        this.reset();
        int numPagesPosted = 0;
        try {
            if (this.type != null) {
                throw new IllegalArgumentException("Specifying content-type with \"-Ddata=web\" is not supported");
            }
            this.solrUpdateUrl = PostTool.appendUrlPath(this.solrUpdateUrl, "/extract");
            PostTool.info("Posting web pages to Solr url " + this.solrUpdateUrl);
            this.auto = true;
            PostTool.info("Entering auto mode. Indexing pages with content-types corresponding to file endings " + this.fileTypes);
            if (this.recursive > 0) {
                if (this.recursive > 10) {
                    this.recursive = 10;
                    PostTool.warn("Too large recursion depth for web mode, limiting to 10...");
                }
                if (this.delay < 10) {
                    PostTool.warn("Never crawl an external web site faster than every 10 seconds, your IP will probably be blocked");
                }
                PostTool.info("Entering recursive mode, depth=" + this.recursive + ", delay=" + this.delay + "s");
            }
            numPagesPosted = this.postWebPages(this.args, 0, this.out);
            PostTool.info(numPagesPosted + " web pages indexed.");
        }
        catch (MalformedURLException e) {
            PostTool.warn("Wrong URL trying to append /extract to " + this.solrUpdateUrl);
        }
    }

    private void doStdinMode() {
        PostTool.info("POSTing stdin to " + this.solrUpdateUrl + "...");
        this.postData(System.in, null, this.out, this.type, this.solrUpdateUrl);
    }

    private void reset() {
        this.backlog = new ArrayList<LinkedHashSet<URI>>();
        this.visited = new HashSet<URI>();
    }

    private void displayTiming(long millis) {
        SimpleDateFormat df = new SimpleDateFormat("H:mm:ss.SSS", Locale.getDefault());
        df.setTimeZone(TimeZone.getTimeZone("UTC"));
        CLIO.out("Time spent: " + df.format(new Date(millis)));
    }

    private boolean checkIsValidPath(File srcFile) {
        return Files.exists(srcFile.toPath(), new LinkOption[0]);
    }

    boolean recursionPossible(String[] args) {
        boolean recursionPossible = false;
        for (String arg : args) {
            File f = new File(arg);
            if (!f.isDirectory()) continue;
            recursionPossible = true;
        }
        return recursionPossible;
    }

    public int postFiles(String[] args, int startIndexInArgs, OutputStream out, String type) {
        this.reset();
        int filesPosted = 0;
        for (int j = startIndexInArgs; j < args.length; ++j) {
            File srcFile = new File(args[j]);
            filesPosted = this.getFilesPosted(out, type, srcFile);
        }
        return filesPosted;
    }

    private int getFilesPosted(OutputStream out, String type, File srcFile) {
        int filesPosted = 0;
        boolean isValidPath = this.checkIsValidPath(srcFile);
        filesPosted = isValidPath && srcFile.isDirectory() && srcFile.canRead() ? (filesPosted += this.postDirectory(srcFile, out, type)) : (isValidPath && srcFile.isFile() && srcFile.canRead() ? (filesPosted += this.postFiles(new File[]{srcFile}, out, type)) : (filesPosted += this.handleGlob(srcFile, out, type)));
        return filesPosted;
    }

    private int postDirectory(File dir, OutputStream out, String type) {
        if (dir.isHidden() && !dir.getName().equals(".")) {
            return 0;
        }
        PostTool.info("Indexing directory " + dir.getPath() + " (" + dir.listFiles(this.fileFilter).length + " files, depth=" + this.currentDepth + ")");
        int posted = 0;
        posted += this.postFiles(dir.listFiles(this.fileFilter), out, type);
        if (this.recursive > this.currentDepth) {
            for (File d : dir.listFiles()) {
                if (!d.isDirectory()) continue;
                ++this.currentDepth;
                posted += this.postDirectory(d, out, type);
                --this.currentDepth;
            }
        }
        return posted;
    }

    int postFiles(File[] files, OutputStream out, String type) {
        int filesPosted = 0;
        for (File srcFile : files) {
            try {
                if (!srcFile.isFile() || srcFile.isHidden()) continue;
                this.postFile(srcFile, out, type);
                Thread.sleep((long)this.delay * 1000L);
                ++filesPosted;
            }
            catch (InterruptedException | MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }
        return filesPosted;
    }

    int handleGlob(File globFile, OutputStream out, String type) {
        String fileGlob;
        GlobFileFilter ff;
        File[] fileList;
        int filesPosted = 0;
        File parent = globFile.getParentFile();
        if (parent == null) {
            parent = new File(".");
        }
        if ((fileList = parent.listFiles(ff = new GlobFileFilter(fileGlob = globFile.getName(), false))) == null || fileList.length == 0) {
            PostTool.warn("No files or directories matching " + globFile);
        } else {
            filesPosted = this.postFiles(fileList, out, type);
        }
        return filesPosted;
    }

    public int postWebPages(String[] args, int startIndexInArgs, OutputStream out) {
        this.reset();
        LinkedHashSet<URI> s = new LinkedHashSet<URI>();
        for (int j = startIndexInArgs; j < args.length; ++j) {
            try {
                URI uri = new URI(PostTool.normalizeUrlEnding(args[j]));
                s.add(uri);
                continue;
            }
            catch (URISyntaxException e) {
                PostTool.warn("Skipping malformed input URL: " + args[j]);
            }
        }
        this.backlog.add(s);
        return this.webCrawl(0, out);
    }

    protected static String normalizeUrlEnding(String link) {
        if (link.contains("#")) {
            link = link.substring(0, link.indexOf(35));
        }
        if (link.endsWith("?")) {
            link = link.substring(0, link.length() - 1);
        }
        if (link.endsWith("/")) {
            link = link.substring(0, link.length() - 1);
        }
        return link;
    }

    protected int webCrawl(int level, OutputStream out) {
        int numPages = 0;
        LinkedHashSet<URI> stack = this.backlog.get(level);
        int rawStackSize = stack.size();
        stack.removeAll(this.visited);
        int stackSize = stack.size();
        LinkedHashSet<URI> subStack = new LinkedHashSet<URI>();
        PostTool.info("Entering crawl at level " + level + " (" + rawStackSize + " links total, " + stackSize + " new)");
        for (URI uri : stack) {
            try {
                this.visited.add(uri);
                URL url = uri.toURL();
                PageFetcherResult result = this.pageFetcher.readPageFromUrl(url);
                if (result.httpStatus == 200) {
                    url = result.redirectUrl != null ? result.redirectUrl : url;
                    URL postUrl = new URL(PostTool.appendParam(this.solrUpdateUrl.toString(), "literal.id=" + URLEncoder.encode(url.toString(), StandardCharsets.UTF_8) + "&literal.url=" + URLEncoder.encode(url.toString(), StandardCharsets.UTF_8)));
                    ByteBuffer content = result.content;
                    boolean success = this.postData(new ByteArrayInputStream(content.array(), content.arrayOffset(), content.limit()), null, out, result.contentType, postUrl);
                    if (success) {
                        PostTool.info("POSTed web resource " + url + " (depth: " + level + ")");
                        Thread.sleep((long)this.delay * 1000L);
                        ++numPages;
                        if (this.recursive <= level || !result.contentType.equals("text/html")) continue;
                        Set<URI> children = this.pageFetcher.getLinksFromWebPage(url, new ByteArrayInputStream(content.array(), content.arrayOffset(), content.limit()), result.contentType, postUrl);
                        subStack.addAll(children);
                        continue;
                    }
                    PostTool.warn("An error occurred while posting " + uri);
                    continue;
                }
                PostTool.warn("The URL " + uri + " returned a HTTP result status of " + result.httpStatus);
            }
            catch (IOException | URISyntaxException e) {
                PostTool.warn("Caught exception when trying to open connection to " + uri + ": " + e.getMessage());
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        if (!subStack.isEmpty()) {
            this.backlog.add(subStack);
            numPages += this.webCrawl(level + 1, out);
        }
        return numPages;
    }

    protected String computeFullUrl(URL baseUrl, String link) {
        String l;
        if (link == null || ((String)link).length() == 0) {
            return null;
        }
        if (!((String)link).startsWith("http")) {
            if (((String)link).startsWith("/")) {
                link = baseUrl.getProtocol() + "://" + baseUrl.getAuthority() + (String)link;
            } else {
                int sep;
                String file;
                if (((String)link).contains(":")) {
                    return null;
                }
                String path = baseUrl.getPath();
                if (!path.endsWith("/") && ((file = path.substring((sep = path.lastIndexOf(47)) + 1)).contains(".") || file.contains("?"))) {
                    path = path.substring(0, sep);
                }
                link = baseUrl.getProtocol() + "://" + baseUrl.getAuthority() + path + "/" + (String)link;
            }
        }
        if ((l = ((String)(link = PostTool.normalizeUrlEnding((String)link))).toLowerCase(Locale.ROOT)).endsWith(".jpg") || l.endsWith(".jpeg") || l.endsWith(".png") || l.endsWith(".gif")) {
            return null;
        }
        return link;
    }

    protected boolean typeSupported(String type) {
        for (Map.Entry<String, String> entry : mimeMap.entrySet()) {
            if (!entry.getValue().equals(type) || !this.fileTypes.contains(entry.getKey())) continue;
            return true;
        }
        return false;
    }

    static void warn(String msg) {
        CLIO.err("PostTool: WARNING: " + msg);
    }

    static void info(String msg) {
        CLIO.out(msg);
    }

    public void commit() throws IOException, SolrServerException {
        PostTool.info("COMMITting Solr index changes to " + this.solrUpdateUrl + "...");
        String url = this.solrUpdateUrl.toString();
        url = url.substring(0, url.lastIndexOf("/update"));
        try (SolrClient client = SolrCLI.getSolrClient(url);){
            client.commit();
        }
    }

    public void optimize() throws IOException, SolrServerException {
        PostTool.info("Performing an OPTIMIZE to " + this.solrUpdateUrl + "...");
        String url = this.solrUpdateUrl.toString();
        url = url.substring(0, url.lastIndexOf("/update"));
        try (SolrClient client = SolrCLI.getSolrClient(url);){
            client.optimize();
        }
    }

    public static String appendParam(String url, String param) {
        String[] pa;
        for (String p : pa = param.split("&")) {
            if (p.trim().length() == 0) continue;
            String[] kv = p.split("=");
            if (kv.length == 2) {
                url = (String)url + (((String)url).contains("?") ? "&" : "?") + kv[0] + "=" + kv[1];
                continue;
            }
            PostTool.warn("Skipping param " + p + " which is not on form key=value");
        }
        return url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postFile(File file, OutputStream output, String type) throws MalformedURLException {
        InputStream is = null;
        URL url = this.solrUpdateUrl;
        String suffix = "";
        if (this.auto) {
            String urlStr;
            if (type == null) {
                type = PostTool.guessType(file);
            }
            if (type.equals(DEFAULT_CONTENT_TYPE) && !FORMAT_SOLR.equals(this.format)) {
                suffix = "/json/docs";
                urlStr = PostTool.appendUrlPath(this.solrUpdateUrl, suffix).toString();
                url = new URL(urlStr);
            } else if (!(type.equals("application/xml") || type.equals("text/csv") || type.equals(DEFAULT_CONTENT_TYPE))) {
                suffix = "/extract";
                urlStr = PostTool.appendUrlPath(this.solrUpdateUrl, suffix).toString();
                if (!urlStr.contains("resource.name")) {
                    urlStr = PostTool.appendParam(urlStr, "resource.name=" + URLEncoder.encode(file.getAbsolutePath(), StandardCharsets.UTF_8));
                }
                if (!urlStr.contains("literal.id")) {
                    urlStr = PostTool.appendParam(urlStr, "literal.id=" + URLEncoder.encode(file.getAbsolutePath(), StandardCharsets.UTF_8));
                }
                url = new URL(urlStr);
            }
        } else if (type == null) {
            type = DEFAULT_CONTENT_TYPE;
        }
        if (this.dryRun) {
            PostTool.info("DRY RUN of POSTing file " + file.getName() + (String)(this.auto ? " (" + type + ")" : "") + " to [base]" + suffix);
        } else {
            try {
                PostTool.info("POSTing file " + file.getName() + (String)(this.auto ? " (" + type + ")" : "") + " to [base]" + suffix);
                is = new FileInputStream(file);
                this.postData(is, file.length(), output, type, url);
            }
            catch (IOException e) {
                PostTool.warn("Can't open/read file: " + file);
            }
            finally {
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (IOException e) {
                    PostTool.warn("IOException while closing file: " + e);
                }
            }
        }
    }

    protected static URL appendUrlPath(URL url, String append) throws MalformedURLException {
        return new URL(url.getProtocol() + "://" + url.getAuthority() + url.getPath() + append + (String)(url.getQuery() != null ? "?" + url.getQuery() : ""));
    }

    protected static String guessType(File file) {
        String name = file.getName();
        String suffix = name.substring(name.lastIndexOf(46) + 1);
        String type = mimeMap.get(suffix.toLowerCase(Locale.ROOT));
        return type != null ? type : "application/octet-stream";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean postData(InputStream data, Long length, OutputStream output, String type, URL url) {
        if (this.dryRun) {
            return true;
        }
        boolean success = true;
        if (type == null) {
            type = DEFAULT_CONTENT_TYPE;
        }
        HttpURLConnection urlConnection = null;
        try {
            try {
                urlConnection = (HttpURLConnection)url.openConnection();
                try {
                    urlConnection.setRequestMethod("POST");
                }
                catch (ProtocolException e) {
                    PostTool.warn("Shouldn't happen: HttpURLConnection doesn't support POST??" + e);
                }
                urlConnection.setDoOutput(true);
                urlConnection.setDoInput(true);
                urlConnection.setUseCaches(false);
                urlConnection.setAllowUserInteraction(false);
                urlConnection.setRequestProperty("Content-type", type);
                this.basicAuth(urlConnection);
                if (null != length) {
                    urlConnection.setFixedLengthStreamingMode(length);
                } else {
                    urlConnection.setChunkedStreamingMode(-1);
                }
                urlConnection.connect();
            }
            catch (IOException e) {
                PostTool.warn("Connection error (is Solr running at " + this.solrUpdateUrl + " ?): " + e);
                success = false;
            }
            catch (Exception e) {
                PostTool.warn("POST failed with error " + e.getMessage());
            }
            try (OutputStream out = urlConnection.getOutputStream();){
                PostTool.pipe(data, out);
            }
            catch (IOException e) {
                PostTool.warn("IOException while posting data: " + e);
            }
            try {
                success &= PostTool.checkResponseCode(urlConnection);
                try (InputStream in = urlConnection.getInputStream();){
                    PostTool.pipe(in, output);
                }
            }
            catch (IOException e) {
                PostTool.warn("IOException while reading response: " + e);
                success = false;
            }
            catch (GeneralSecurityException e) {
                PostTool.warn("Looks like Solr is secured and would not let us in. Try with another user in '-u' parameter");
            }
        }
        finally {
            if (urlConnection != null) {
                urlConnection.disconnect();
            }
        }
        return success;
    }

    private void basicAuth(HttpURLConnection urlc) throws Exception {
        if (urlc.getURL().getUserInfo() != null) {
            String encoding = Base64.getEncoder().encodeToString(urlc.getURL().getUserInfo().getBytes(StandardCharsets.US_ASCII));
            urlc.setRequestProperty("Authorization", "Basic " + encoding);
        } else if (this.credentials != null) {
            if (!this.credentials.contains(":")) {
                throw new Exception("credentials '" + this.credentials + "' must be of format user:pass");
            }
            urlc.setRequestProperty("Authorization", "Basic " + Base64.getEncoder().encodeToString(this.credentials.getBytes(StandardCharsets.UTF_8)));
        }
    }

    private static boolean checkResponseCode(HttpURLConnection urlc) throws IOException, GeneralSecurityException {
        if (urlc.getResponseCode() >= 400) {
            int idx;
            PostTool.warn("Solr returned an error #" + urlc.getResponseCode() + " (" + urlc.getResponseMessage() + ") for url: " + urlc.getURL());
            Charset charset = StandardCharsets.ISO_8859_1;
            String contentType = urlc.getContentType();
            if (contentType != null && (idx = contentType.toLowerCase(Locale.ROOT).indexOf("charset=")) > 0) {
                charset = Charset.forName(contentType.substring(idx + "charset=".length()).trim());
            }
            try (InputStream errStream = urlc.getErrorStream();){
                if (errStream != null) {
                    int ch;
                    BufferedReader br = new BufferedReader(new InputStreamReader(errStream, charset));
                    StringBuilder response = new StringBuilder("Response: ");
                    while ((ch = br.read()) != -1) {
                        response.append((char)ch);
                    }
                    PostTool.warn(response.toString().trim());
                }
            }
            if (urlc.getResponseCode() == 401) {
                throw new GeneralSecurityException("Solr requires authentication (response 401). Please try again with '-u' option");
            }
            if (urlc.getResponseCode() == 403) {
                throw new GeneralSecurityException("You are not authorized to perform this action against Solr. (response 403)");
            }
            return false;
        }
        return true;
    }

    public static InputStream stringToStream(String s) {
        return new ByteArrayInputStream(s.getBytes(StandardCharsets.UTF_8));
    }

    private static void pipe(InputStream source, OutputStream dest) throws IOException {
        byte[] buf = new byte[1024];
        int read = 0;
        while ((read = source.read(buf)) >= 0) {
            if (null == dest) continue;
            dest.write(buf, 0, read);
        }
        if (null != dest) {
            dest.flush();
        }
    }

    public FileFilter getFileFilterFromFileTypes(String fileTypes) {
        Object glob = fileTypes.equals("*") ? ".*" : "^.*\\.(" + fileTypes.replace(",", "|") + ")$";
        return new GlobFileFilter((String)glob, true);
    }

    public static NodeList getNodesFromXP(Node n, String xpath) throws XPathExpressionException {
        XPathFactory factory = XPathFactory.newInstance();
        XPath xp = factory.newXPath();
        XPathExpression expr = xp.compile(xpath);
        return (NodeList)expr.evaluate(n, XPathConstants.NODESET);
    }

    public static String getXP(Node n, String xpath, boolean concatAll) throws XPathExpressionException {
        NodeList nodes = PostTool.getNodesFromXP(n, xpath);
        StringBuilder sb = new StringBuilder();
        if (nodes.getLength() > 0) {
            for (int i = 0; i < nodes.getLength(); ++i) {
                sb.append(nodes.item(i).getNodeValue()).append(' ');
                if (!concatAll) break;
            }
            return sb.toString().trim();
        }
        return "";
    }

    public static Document makeDom(byte[] in) throws SAXException, IOException, ParserConfigurationException {
        ByteArrayInputStream is = new ByteArrayInputStream(in);
        Document dom = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(is);
        return dom;
    }

    static {
        DATA_MODES = new HashSet<String>();
        DATA_MODES.add("files");
        DATA_MODES.add(DATA_MODE_ARGS);
        DATA_MODES.add(DATA_MODE_STDIN);
        DATA_MODES.add(DATA_MODE_WEB);
        mimeMap = new HashMap();
        mimeMap.put("xml", "application/xml");
        mimeMap.put("csv", "text/csv");
        mimeMap.put("json", DEFAULT_CONTENT_TYPE);
        mimeMap.put("jsonl", "application/jsonl");
        mimeMap.put("pdf", "application/pdf");
        mimeMap.put("rtf", "text/rtf");
        mimeMap.put("html", "text/html");
        mimeMap.put("htm", "text/html");
        mimeMap.put("doc", "application/msword");
        mimeMap.put("docx", "application/vnd.openxmlformats-officedocument.wordprocessingml.document");
        mimeMap.put("ppt", "application/vnd.ms-powerpoint");
        mimeMap.put("pptx", "application/vnd.openxmlformats-officedocument.presentationml.presentation");
        mimeMap.put("xls", "application/vnd.ms-excel");
        mimeMap.put("xlsx", "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        mimeMap.put("odt", "application/vnd.oasis.opendocument.text");
        mimeMap.put("ott", "application/vnd.oasis.opendocument.text");
        mimeMap.put("odp", "application/vnd.oasis.opendocument.presentation");
        mimeMap.put("otp", "application/vnd.oasis.opendocument.presentation");
        mimeMap.put("ods", "application/vnd.oasis.opendocument.spreadsheet");
        mimeMap.put("ots", "application/vnd.oasis.opendocument.spreadsheet");
        mimeMap.put("txt", "text/plain");
        mimeMap.put("log", "text/plain");
    }

    public static class PageFetcherResult {
        int httpStatus = 200;
        String contentType = "text/html";
        URL redirectUrl = null;
        ByteBuffer content;
    }

    class PageFetcher {
        Map<String, List<String>> robotsCache = new HashMap<String, List<String>>();
        static final String DISALLOW = "Disallow:";

        public PageFetcherResult readPageFromUrl(URL u) throws URISyntaxException {
            PageFetcherResult res = new PageFetcherResult();
            try {
                if (this.isDisallowedByRobots(u)) {
                    PostTool.warn("The URL " + u + " is disallowed by robots.txt and will not be crawled.");
                    res.httpStatus = 403;
                    URI uri = u.toURI();
                    PostTool.this.visited.add(uri);
                    return res;
                }
                res.httpStatus = 404;
                HttpURLConnection conn = (HttpURLConnection)u.openConnection();
                conn.setRequestProperty("User-Agent", "PostTool-crawler/9.6.0 (https://solr.apache.org/)");
                conn.setRequestProperty("Accept-Encoding", "gzip, deflate");
                conn.connect();
                res.httpStatus = conn.getResponseCode();
                if (!PostTool.normalizeUrlEnding(conn.getURL().toString()).equals(PostTool.normalizeUrlEnding(u.toString()))) {
                    PostTool.info("The URL " + u + " caused a redirect to " + conn.getURL());
                    res.redirectUrl = u = conn.getURL();
                    URI uri = u.toURI();
                    PostTool.this.visited.add(uri);
                }
                if (res.httpStatus == 200) {
                    String rawContentType = conn.getContentType();
                    String type = rawContentType.split(";")[0];
                    if (PostTool.this.typeSupported(type) || "*".equals(PostTool.this.fileTypes)) {
                        String encoding = conn.getContentEncoding();
                        InputStream is = encoding != null && encoding.equalsIgnoreCase("gzip") ? new GZIPInputStream(conn.getInputStream()) : (encoding != null && encoding.equalsIgnoreCase("deflate") ? new InflaterInputStream(conn.getInputStream(), new Inflater(true)) : conn.getInputStream());
                        res.content = Utils.toByteArray((InputStream)is);
                        is.close();
                    } else {
                        PostTool.warn("Skipping URL with unsupported type " + type);
                        res.httpStatus = 415;
                    }
                }
            }
            catch (IOException e) {
                PostTool.warn("IOException when reading page from url " + u + ": " + e.getMessage());
            }
            return res;
        }

        public boolean isDisallowedByRobots(URL url) {
            String host = url.getHost();
            String strRobot = url.getProtocol() + "://" + host + "/robots.txt";
            List<String> disallows = this.robotsCache.get(host);
            if (disallows == null) {
                disallows = new ArrayList<String>();
                try {
                    URL urlRobot = new URL(strRobot);
                    disallows = this.parseRobotsTxt(urlRobot.openStream());
                }
                catch (MalformedURLException e) {
                    return true;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this.robotsCache.put(host, disallows);
            String strURL = url.getFile();
            for (String path : disallows) {
                if (!path.equals("/") && strURL.indexOf(path) != 0) continue;
                return true;
            }
            return false;
        }

        protected List<String> parseRobotsTxt(InputStream is) throws IOException {
            String l;
            ArrayList<String> disallows = new ArrayList<String>();
            BufferedReader r = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));
            while ((l = r.readLine()) != null) {
                String[] arr = l.split("#");
                if (arr.length == 0 || !(l = arr[0].trim()).startsWith(DISALLOW) || (l = l.substring(DISALLOW.length()).trim()).length() == 0) continue;
                disallows.add(l);
            }
            is.close();
            return disallows;
        }

        protected Set<URI> getLinksFromWebPage(URL url, InputStream is, String type, URL postUrl) {
            HashSet<URI> linksFromPage = new HashSet<URI>();
            try {
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                URL extractUrl = new URL(PostTool.appendParam(postUrl.toString(), "extractOnly=true"));
                extractUrl = new URL(PostTool.appendParam(extractUrl.toString(), "wt=xml"));
                boolean success = PostTool.this.postData(is, null, os, type, extractUrl);
                if (success) {
                    Document d = PostTool.makeDom(os.toByteArray());
                    String innerXml = PostTool.getXP(d, "/response/str/text()[1]", false);
                    d = PostTool.makeDom(innerXml.getBytes(StandardCharsets.UTF_8));
                    NodeList links = PostTool.getNodesFromXP(d, "/html/body//a/@href");
                    for (int i = 0; i < links.getLength(); ++i) {
                        URI newUri;
                        String link = links.item(i).getTextContent();
                        if ((link = PostTool.this.computeFullUrl(url, link)) == null || (newUri = new URI(link)).getAuthority() != null && newUri.getAuthority().equals(url.getAuthority())) continue;
                        linksFromPage.add(newUri);
                    }
                }
            }
            catch (MalformedURLException e) {
                PostTool.warn("Malformed URL " + url);
            }
            catch (IOException e) {
                PostTool.warn("IOException opening URL " + url + ": " + e.getMessage());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return linksFromPage;
        }
    }

    static class GlobFileFilter
    implements FileFilter {
        private final Pattern p;

        public GlobFileFilter(String pattern, boolean isRegex) {
            Object _pattern = pattern;
            if (!isRegex) {
                _pattern = ((String)_pattern).replace("^", "\\^").replace("$", "\\$").replace(".", "\\.").replace("(", "\\(").replace(")", "\\)").replace("+", "\\+").replace("*", ".*").replace("?", ".");
                _pattern = "^" + (String)_pattern + "$";
            }
            try {
                this.p = Pattern.compile((String)_pattern, 2);
            }
            catch (PatternSyntaxException e) {
                throw new IllegalArgumentException("Invalid type list " + pattern + ". " + e.getDescription());
            }
        }

        @Override
        public boolean accept(File file) {
            return this.p.matcher(file.getName()).find();
        }
    }
}

