/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.people.config;

import de.justsoftware.people.config.FeatureConfig;
import de.justsoftware.people.model.TenantId;
import de.justsoftware.people.persistence.ConfigRepository;
import de.justsoftware.people.persistence.model.DbConfig;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0017\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0012J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0010\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0011\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lde/justsoftware/people/config/ConfigService;", "", "configRepository", "Lde/justsoftware/people/persistence/ConfigRepository;", "<init>", "(Lde/justsoftware/people/persistence/ConfigRepository;)V", "getFeatureConfig", "Lde/justsoftware/people/config/FeatureConfig;", "tenantId", "Lde/justsoftware/people/model/TenantId;", "getFeatureConfigForTenant", "Lde/justsoftware/people/persistence/model/DbConfig;", "setBirthdayListEnabled", "", "enabled", "", "setAbsenceStatusEnabled", "setAbsenceNoteEnabled", "people-api"})
@SourceDebugExtension(value={"SMAP\nConfigService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConfigService.kt\nde/justsoftware/people/config/ConfigService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,55:1\n1#2:56\n*E\n"})
public class ConfigService {
    @NotNull
    private final ConfigRepository configRepository;

    public ConfigService(@NotNull ConfigRepository configRepository) {
        Intrinsics.checkNotNullParameter((Object)configRepository, (String)"configRepository");
        this.configRepository = configRepository;
    }

    @NotNull
    public FeatureConfig getFeatureConfig(@NotNull TenantId tenantId) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        return FeatureConfig.Companion.toFeatureConfig(this.getFeatureConfigForTenant(tenantId));
    }

    private DbConfig getFeatureConfigForTenant(TenantId tenantId) {
        DbConfig dbConfig = this.configRepository.findById(tenantId.getId()).orElse(new DbConfig((UUID)tenantId.getId(), false, false, false, 300000));
        Intrinsics.checkNotNullExpressionValue((Object)dbConfig, (String)"orElse(...)");
        return dbConfig;
    }

    /*
     * WARNING - void declaration
     */
    public void setBirthdayListEnabled(@NotNull TenantId tenantId, boolean enabled) {
        void $this$setBirthdayListEnabled_u24lambda_u240;
        DbConfig dbConfig;
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        DbConfig dbConfig2 = dbConfig = this.getFeatureConfigForTenant(tenantId);
        ConfigRepository configRepository = this.configRepository;
        boolean bl = false;
        $this$setBirthdayListEnabled_u24lambda_u240.setBirthdayListEnabled(enabled);
        configRepository.save((Object)dbConfig);
    }

    /*
     * WARNING - void declaration
     */
    public void setAbsenceStatusEnabled(@NotNull TenantId tenantId, boolean enabled) {
        void $this$setAbsenceStatusEnabled_u24lambda_u241;
        DbConfig dbConfig;
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        DbConfig dbConfig2 = dbConfig = this.getFeatureConfigForTenant(tenantId);
        ConfigRepository configRepository = this.configRepository;
        boolean bl = false;
        $this$setAbsenceStatusEnabled_u24lambda_u241.setAbsenceStatusEnabled(enabled);
        configRepository.save((Object)dbConfig);
    }

    /*
     * WARNING - void declaration
     */
    public void setAbsenceNoteEnabled(@NotNull TenantId tenantId, boolean enabled) {
        void $this$setAbsenceNoteEnabled_u24lambda_u242;
        DbConfig dbConfig;
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        DbConfig dbConfig2 = dbConfig = this.getFeatureConfigForTenant(tenantId);
        ConfigRepository configRepository = this.configRepository;
        boolean bl = false;
        $this$setAbsenceNoteEnabled_u24lambda_u242.setAbsenceNoteEnabled(enabled);
        configRepository.save((Object)dbConfig);
    }
}

