/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.wikiservice.kafka;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.justsoftware.kafka.client.KafkaCleaningProducer;
import de.justsoftware.wikiservice.kafka.DriveItemIdProducer;
import de.justsoftware.wikiservice.model.ArticleDeletedEvent;
import de.justsoftware.wikiservice.model.ArticleId;
import de.justsoftware.wikiservice.model.ItemId;
import de.justsoftware.wikiservice.model.TenantId;
import de.justsoftware.wikiservice.model.WikiId;
import de.justsoftware.wikiservice.persistence.ArticleRepository;
import de.justsoftware.wikiservice.persistence.WikiRepository;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.jetbrains.annotations.NotNull;
import org.springframework.context.event.EventListener;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u0000 \u00182\u00020\u0001:\u0002\u0017\u0018B3\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0017J\b\u0010\u0011\u001a\u00020\u000eH\u0017J\u001c\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u00142\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0012R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lde/justsoftware/wikiservice/kafka/DriveItemIdProducer;", "", "kafkaProducer", "Lde/justsoftware/kafka/client/KafkaCleaningProducer;", "", "wikiRepository", "Lde/justsoftware/wikiservice/persistence/WikiRepository;", "articleRepository", "Lde/justsoftware/wikiservice/persistence/ArticleRepository;", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "<init>", "(Lde/justsoftware/kafka/client/KafkaCleaningProducer;Lde/justsoftware/wikiservice/persistence/WikiRepository;Lde/justsoftware/wikiservice/persistence/ArticleRepository;Lcom/fasterxml/jackson/databind/ObjectMapper;)V", "handleArticleDeletedEvent", "", "evt", "Lde/justsoftware/wikiservice/model/ArticleDeletedEvent;", "syncAllItems", "send", "itemId", "Lde/justsoftware/wikiservice/model/ItemId;", "driveCreateItem", "Lde/justsoftware/wikiservice/kafka/DriveItemIdProducer$DriveCreateItem;", "DriveCreateItem", "Companion", "wiki-service"})
public class DriveItemIdProducer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final KafkaCleaningProducer<String, String> kafkaProducer;
    @NotNull
    private final WikiRepository wikiRepository;
    @NotNull
    private final ArticleRepository articleRepository;
    @NotNull
    private final ObjectMapper objectMapper;
    @NotNull
    public static final String TOPIC = "just.items";

    public DriveItemIdProducer(@NotNull KafkaCleaningProducer<String, String> kafkaProducer, @NotNull WikiRepository wikiRepository, @NotNull ArticleRepository articleRepository, @NotNull ObjectMapper objectMapper) {
        Intrinsics.checkNotNullParameter(kafkaProducer, (String)"kafkaProducer");
        Intrinsics.checkNotNullParameter((Object)wikiRepository, (String)"wikiRepository");
        Intrinsics.checkNotNullParameter((Object)articleRepository, (String)"articleRepository");
        Intrinsics.checkNotNullParameter((Object)objectMapper, (String)"objectMapper");
        this.kafkaProducer = kafkaProducer;
        this.wikiRepository = wikiRepository;
        this.articleRepository = articleRepository;
        this.objectMapper = objectMapper;
    }

    @Async
    @EventListener
    public void handleArticleDeletedEvent(@NotNull ArticleDeletedEvent evt) {
        Intrinsics.checkNotNullParameter((Object)evt, (String)"evt");
        DriveItemIdProducer.send$default((DriveItemIdProducer)this, (ItemId)((ItemId)evt.getId()), null, (int)2, null);
    }

    @Transactional
    public void syncAllItems() {
        this.wikiRepository.streamAllIdsAndTenantsOfWikisWithCoverImage().forEach(arg_0 -> DriveItemIdProducer.syncAllItems$lambda$1(arg_0 -> DriveItemIdProducer.syncAllItems$lambda$0(this, arg_0), arg_0));
        this.articleRepository.streamAllIdsAndTenants().forEach(arg_0 -> DriveItemIdProducer.syncAllItems$lambda$3(arg_0 -> DriveItemIdProducer.syncAllItems$lambda$2(this, arg_0), arg_0));
    }

    private void send(ItemId itemId, DriveCreateItem driveCreateItem) {
        String value = driveCreateItem != null ? this.objectMapper.writeValueAsString((Object)driveCreateItem) : null;
        this.kafkaProducer.send(new ProducerRecord("just.items", (Object)itemId.toString(), (Object)value));
    }

    static /* synthetic */ void send$default(DriveItemIdProducer driveItemIdProducer, ItemId itemId, DriveCreateItem driveCreateItem, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: send");
        }
        if ((n & 2) != 0) {
            driveCreateItem = null;
        }
        driveItemIdProducer.send(itemId, driveCreateItem);
    }

    private static final Unit syncAllItems$lambda$0(DriveItemIdProducer this$0, Pair it) {
        this$0.send((ItemId)new WikiId((UUID)it.getFirst()), new DriveCreateItem(new TenantId((UUID)it.getSecond()).toString()));
        return Unit.INSTANCE;
    }

    private static final void syncAllItems$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit syncAllItems$lambda$2(DriveItemIdProducer this$0, Pair it) {
        this$0.send((ItemId)new ArticleId((UUID)it.getFirst()), new DriveCreateItem(new TenantId((UUID)it.getSecond()).toString()));
        return Unit.INSTANCE;
    }

    private static final void syncAllItems$lambda$3(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }
}

