/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.wikiservice.config;

import de.justsoftware.wikiservice.ai.assistant.controller.AiAssistantController;
import de.justsoftware.wikiservice.config.ExceptionHandlerConfiguration;
import de.justsoftware.wikiservice.exception.BadGatewayException;
import de.justsoftware.wikiservice.exception.BadLlmCredentials;
import de.justsoftware.wikiservice.exception.RateLimitException;
import jakarta.servlet.http.HttpServletResponse;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestControllerAdvice;

@RestControllerAdvice(assignableTypes={AiAssistantController.class})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0018\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0017J\u0018\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\tH\u0017\u00a8\u0006\u000e"}, d2={"Lde/justsoftware/wikiservice/config/AiAssistantExceptionHandlerConfiguration;", "", "<init>", "()V", "handleBadLlmCredentialsException", "Lde/justsoftware/wikiservice/config/ExceptionHandlerConfiguration$ErrorResponse;", "e", "Lde/justsoftware/wikiservice/exception/BadLlmCredentials;", "response", "Ljakarta/servlet/http/HttpServletResponse;", "handleRateLimitException", "Lde/justsoftware/wikiservice/exception/RateLimitException;", "handleBadGatewayException", "Lde/justsoftware/wikiservice/exception/BadGatewayException;", "wiki-service"})
public class AiAssistantExceptionHandlerConfiguration {
    @ExceptionHandler(value={BadLlmCredentials.class})
    @ResponseStatus(value=HttpStatus.UNPROCESSABLE_ENTITY)
    @ResponseBody
    @NotNull
    public ExceptionHandlerConfiguration.ErrorResponse handleBadLlmCredentialsException(@NotNull BadLlmCredentials e, @NotNull HttpServletResponse response) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        response.setContentType("application/json");
        return new ExceptionHandlerConfiguration.ErrorResponse(e.getMessage());
    }

    @ExceptionHandler(value={RateLimitException.class})
    @ResponseStatus(value=HttpStatus.TOO_MANY_REQUESTS)
    @ResponseBody
    @NotNull
    public ExceptionHandlerConfiguration.ErrorResponse handleRateLimitException(@NotNull RateLimitException e, @NotNull HttpServletResponse response) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        response.setContentType("application/json");
        return new ExceptionHandlerConfiguration.ErrorResponse(e.getMessage());
    }

    @ExceptionHandler(value={BadGatewayException.class})
    @ResponseStatus(value=HttpStatus.BAD_GATEWAY)
    @ResponseBody
    @NotNull
    public ExceptionHandlerConfiguration.ErrorResponse handleBadGatewayException(@NotNull BadGatewayException e, @NotNull HttpServletResponse response) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        response.setContentType("application/json");
        return new ExceptionHandlerConfiguration.ErrorResponse(e.getMessage());
    }
}

