/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.wikiservice.business;

import de.justsoftware.wikiservice.business.AncestorService;
import de.justsoftware.wikiservice.business.ArticleService;
import de.justsoftware.wikiservice.business.exceptions.EmptyChapterTitleException;
import de.justsoftware.wikiservice.business.model.Chapter;
import de.justsoftware.wikiservice.model.ChapterId;
import de.justsoftware.wikiservice.model.ChapterModifiedEvent;
import de.justsoftware.wikiservice.model.DeletionId;
import de.justsoftware.wikiservice.model.IdType;
import de.justsoftware.wikiservice.model.ParentId;
import de.justsoftware.wikiservice.model.ProfileId;
import de.justsoftware.wikiservice.model.WikiId;
import de.justsoftware.wikiservice.persistence.ChapterRepository;
import de.justsoftware.wikiservice.persistence.model.DbChapter;
import de.justsoftware.wikiservice.util.CollectionUtilsKt;
import de.justsoftware.wikiservice.util.TransactionUtils;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u0017\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ&\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0017J\u0010\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0018H\u0017J\u000e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aH\u0016J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0017\u001a\u00020\u0018H\u0017J\"\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00100\u001f2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00180!H\u0016J(\u0010\"\u001a\u0014\u0012\u0004\u0012\u00020#\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f0\u001f2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020#0!H\u0016J\"\u0010%\u001a\u000e\u0012\u0004\u0012\u00020&\u0012\u0004\u0012\u00020\u00140\u001f2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020&0!H\u0016J0\u0010(\u001a\u00020\u00102\u0006\u0010)\u001a\u00020&2\u0006\u0010*\u001a\u00020#2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020\u00122\u0006\u0010.\u001a\u00020\u0014H\u0017J,\u0010/\u001a\u00020\u00102\u0006\u00100\u001a\u00020\u00182\b\u0010+\u001a\u0004\u0018\u00010,2\u0006\u00101\u001a\u00020\u00122\b\b\u0002\u00102\u001a\u00020\u001dH\u0017J \u00103\u001a\u0002042\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u00105\u001a\u0002062\u0006\u00107\u001a\u00020\u0012H\u0017J\u0016\u00108\u001a\b\u0012\u0004\u0012\u00020\u00180!2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0018\u00109\u001a\u0002042\u0006\u0010:\u001a\u00020&2\u0006\u00105\u001a\u000206H\u0017J\u0016\u0010;\u001a\u0002042\f\u0010<\u001a\b\u0012\u0004\u0012\u0002060!H\u0017J\"\u0010=\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00100\u001f2\f\u0010>\u001a\b\u0012\u0004\u0012\u00020\u00180!H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006?"}, d2={"Lde/justsoftware/wikiservice/business/ChapterService;", "", "chapterRepository", "Lde/justsoftware/wikiservice/persistence/ChapterRepository;", "articleService", "Lde/justsoftware/wikiservice/business/ArticleService;", "ancestorService", "Lde/justsoftware/wikiservice/business/AncestorService;", "transactionUtils", "Lde/justsoftware/wikiservice/util/TransactionUtils;", "applicationEventPublisher", "Lorg/springframework/context/ApplicationEventPublisher;", "<init>", "(Lde/justsoftware/wikiservice/persistence/ChapterRepository;Lde/justsoftware/wikiservice/business/ArticleService;Lde/justsoftware/wikiservice/business/AncestorService;Lde/justsoftware/wikiservice/util/TransactionUtils;Lorg/springframework/context/ApplicationEventPublisher;)V", "readBySubscriber", "", "Lde/justsoftware/wikiservice/business/model/Chapter;", "subscriber", "Lde/justsoftware/wikiservice/model/ProfileId;", "page", "", "limit", "read", "chapterId", "Lde/justsoftware/wikiservice/model/ChapterId;", "streamAllIds", "Ljava/util/stream/Stream;", "Ljava/util/UUID;", "exists", "", "readByIds", "", "ids", "", "readByParentIds", "Lde/justsoftware/wikiservice/model/ParentId;", "parentIds", "countByWikiIds", "Lde/justsoftware/wikiservice/model/WikiId;", "wikiIds", "create", "wiki", "parentId", "title", "", "creator", "position", "update", "id", "updater", "chapterWasMoved", "delete", "", "deletionId", "Lde/justsoftware/wikiservice/model/DeletionId;", "deleter", "findDescendantChapterIdsByChapterId", "deleteWikiChapters", "wikiId", "removeDeletedChapters", "deletionIds", "getChaptersByIds", "chapterIds", "wiki-service"})
@SourceDebugExtension(value={"SMAP\nChapterService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChapterService.kt\nde/justsoftware/wikiservice/business/ChapterService\n+ 2 CollectionUtils.kt\nde/justsoftware/wikiservice/util/CollectionUtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,212:1\n7#2:213\n7#2:227\n7#2:240\n7#2:256\n7#2:260\n7#2:268\n7#2:272\n7#2:276\n1628#3,3:214\n1557#3:217\n1628#3,3:218\n1202#3,2:221\n1230#3,4:223\n1628#3,3:228\n1279#3,2:231\n1293#3,2:233\n1557#3:235\n1628#3,3:236\n1296#3:239\n1628#3,3:241\n1246#3,4:246\n1279#3,2:250\n1293#3,4:252\n1628#3,3:257\n1628#3,3:261\n1557#3:264\n1628#3,3:265\n1628#3,3:269\n1628#3,3:273\n1628#3,3:277\n1557#3:280\n1628#3,3:281\n1202#3,2:284\n1230#3,4:286\n1863#3,2:290\n1863#3,2:292\n477#4:244\n423#4:245\n*S KotlinDebug\n*F\n+ 1 ChapterService.kt\nde/justsoftware/wikiservice/business/ChapterService\n*L\n61#1:213\n69#1:227\n78#1:240\n168#1:256\n180#1:260\n192#1:268\n205#1:272\n208#1:276\n61#1:214,3\n62#1:217\n62#1:218,3\n63#1:221,2\n63#1:223,4\n69#1:228,3\n71#1:231,2\n71#1:233,2\n72#1:235\n72#1:236,3\n71#1:239\n78#1:241,3\n78#1:246,4\n80#1:250,2\n80#1:252,4\n168#1:257,3\n180#1:261,3\n184#1:264\n184#1:265,3\n192#1:269,3\n205#1:273,3\n208#1:277,3\n209#1:280\n209#1:281,3\n210#1:284,2\n210#1:286,4\n174#1:290,2\n195#1:292,2\n78#1:244\n78#1:245\n*E\n"})
public class ChapterService {
    @NotNull
    private final ChapterRepository chapterRepository;
    @NotNull
    private final ArticleService articleService;
    @NotNull
    private final AncestorService ancestorService;
    @NotNull
    private final TransactionUtils transactionUtils;
    @NotNull
    private final ApplicationEventPublisher applicationEventPublisher;

    public ChapterService(@NotNull ChapterRepository chapterRepository, @NotNull ArticleService articleService, @NotNull AncestorService ancestorService, @NotNull TransactionUtils transactionUtils, @NotNull ApplicationEventPublisher applicationEventPublisher) {
        Intrinsics.checkNotNullParameter((Object)chapterRepository, (String)"chapterRepository");
        Intrinsics.checkNotNullParameter((Object)articleService, (String)"articleService");
        Intrinsics.checkNotNullParameter((Object)ancestorService, (String)"ancestorService");
        Intrinsics.checkNotNullParameter((Object)transactionUtils, (String)"transactionUtils");
        Intrinsics.checkNotNullParameter((Object)applicationEventPublisher, (String)"applicationEventPublisher");
        this.chapterRepository = chapterRepository;
        this.articleService = articleService;
        this.ancestorService = ancestorService;
        this.transactionUtils = transactionUtils;
        this.applicationEventPublisher = applicationEventPublisher;
    }

    @Transactional(readOnly=true)
    @NotNull
    public List<Chapter> readBySubscriber(@NotNull ProfileId subscriber, int page, int limit) {
        Intrinsics.checkNotNullParameter((Object)subscriber, (String)"subscriber");
        long l = subscriber.getId();
        String[] stringArray = new String[]{"id"};
        PageRequest pageRequest = PageRequest.of((int)page, (int)limit, (Sort)Sort.by((Sort.Direction)Sort.Direction.ASC, (String[])stringArray));
        Intrinsics.checkNotNullExpressionValue((Object)pageRequest, (String)"of(...)");
        List<Chapter> list = this.chapterRepository.findAllBySubscriber(l, (Pageable)pageRequest).get().map(arg_0 -> ChapterService.readBySubscriber$lambda$1(ChapterService::readBySubscriber$lambda$0, arg_0)).toList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"toList(...)");
        return list;
    }

    @Transactional
    @NotNull
    public Chapter read(@NotNull ChapterId chapterId) {
        Intrinsics.checkNotNullParameter((Object)chapterId, (String)"chapterId");
        Object object = this.chapterRepository.getReferenceById((Object)chapterId.getId());
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getReferenceById(...)");
        return DbChapter.Companion.toChapter((DbChapter)object);
    }

    @NotNull
    public Stream<UUID> streamAllIds() {
        return this.chapterRepository.streamAllIds();
    }

    @Transactional
    public boolean exists(@NotNull ChapterId chapterId) {
        Intrinsics.checkNotNullParameter((Object)chapterId, (String)"chapterId");
        return this.chapterRepository.existsById((Object)chapterId.getId());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Map<ChapterId, Chapter> readByIds(@NotNull Set<ChapterId> ids) {
        Map map;
        Intrinsics.checkNotNullParameter(ids, (String)"ids");
        if (ids.isEmpty()) {
            map = MapsKt.emptyMap();
        } else {
            void $this$associateByTo$iv$iv;
            DbChapter it;
            Iterable $this$mapTo$iv$iv;
            void $this$mapToSet$iv;
            Iterable iterable = ids;
            Object object = this.chapterRepository;
            boolean $i$f$mapToSet = false;
            void var4_5 = $this$mapToSet$iv;
            Iterable destination$iv$iv = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapToSet$iv));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                ChapterId chapterId = (ChapterId)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getId());
            }
            Iterable $this$map$iv = ChapterRepository.findByIds$default((ChapterRepository)object, (Set)((Set)destination$iv$iv), null, (int)2, null);
            boolean $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (DbChapter)item$iv$iv;
                object = destination$iv$iv;
                boolean bl = false;
                object.add(DbChapter.Companion.toChapter(it));
            }
            Iterable $this$associateBy$iv = (List)destination$iv$iv;
            boolean $i$f$associateBy = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
            destination$iv$iv = $this$associateBy$iv;
            Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                void it2;
                Chapter bl = (Chapter)element$iv$iv;
                object = destination$iv$iv2;
                boolean bl2 = false;
                object.put(it2.getId(), element$iv$iv);
            }
            map = destination$iv$iv2;
        }
        return map;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Map<ParentId, List<Chapter>> readByParentIds(@NotNull Set<? extends ParentId> parentIds) {
        ParentId it;
        Collection<Object> collection;
        void $this$mapTo$iv$iv;
        void $this$mapToSet$iv;
        Intrinsics.checkNotNullParameter(parentIds, (String)"parentIds");
        Iterable iterable = parentIds;
        Object object = this.chapterRepository;
        boolean $i$f$mapToSet = false;
        void var5_5 = $this$mapToSet$iv;
        Collection destination$iv$iv = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapToSet$iv));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            ParentId parentId = (ParentId)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getId());
        }
        Map fromDB = ChapterRepository.findByParentIds$default((ChapterRepository)object, (Set)((Set)destination$iv$iv), null, (int)2, null);
        Iterable $this$associateWith$iv = parentIds;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void $this$mapTo$iv$iv2;
            void $this$map$iv;
            it = (ParentId)element$iv$iv;
            collection = element$iv$iv;
            object = result$iv;
            boolean bl = false;
            List list = (List)fromDB.get(it);
            if (list == null) {
                list = CollectionsKt.emptyList();
            }
            Iterable iterable2 = list;
            boolean $i$f$map = false;
            void var14_16 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void dbChapter;
                DbChapter dbChapter2 = (DbChapter)item$iv$iv;
                Collection collection2 = destination$iv$iv2;
                boolean bl2 = false;
                collection2.add(DbChapter.Companion.toChapter((DbChapter)dbChapter));
            }
            List list2 = (List)destination$iv$iv2;
            object.put(collection, list2);
        }
        return result$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Map<WikiId, Integer> countByWikiIds(@NotNull Set<WikiId> wikiIds) {
        void $this$mapKeysTo$iv$iv;
        WikiId it;
        Collection<Object> collection;
        Map $this$mapTo$iv$iv;
        void $this$mapToSet$iv;
        Intrinsics.checkNotNullParameter(wikiIds, (String)"wikiIds");
        Iterable iterable = wikiIds;
        Object object = this.chapterRepository;
        boolean $i$f$mapToSet = false;
        void var5_5 = $this$mapToSet$iv;
        Object destination$iv$iv = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapToSet$iv));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object item$iv$iv = iterator.next();
            WikiId wikiId = (WikiId)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getId());
        }
        Map $this$mapKeys$iv = object.countByWikiIds((Set)destination$iv$iv);
        boolean $i$f$mapKeys = false;
        $this$mapTo$iv$iv = $this$mapKeys$iv;
        destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapKeys$iv.size()));
        boolean $i$f$mapKeysTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapKeysTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it$iv$iv;
            void it2;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            WikiId wikiId = new WikiId((UUID)it2.getKey());
            Object object2 = object;
            boolean bl2 = false;
            entry = it$iv$iv.getValue();
            object2.put(wikiId, entry);
        }
        Object countsByWiki = destination$iv$iv;
        Iterable $this$associateWith$iv = wikiIds;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            it = (WikiId)element$iv$iv;
            collection = element$iv$iv;
            object = result$iv;
            boolean bl = false;
            Integer n = (int)((Number)countsByWiki.getOrDefault(it, 0L)).longValue();
            object.put(collection, n);
        }
        return MapsKt.toMap((Map)result$iv);
    }

    @Transactional
    @NotNull
    public Chapter create(@NotNull WikiId wiki, @NotNull ParentId parentId, @NotNull String title, @NotNull ProfileId creator, int position) {
        Intrinsics.checkNotNullParameter((Object)wiki, (String)"wiki");
        Intrinsics.checkNotNullParameter((Object)parentId, (String)"parentId");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)creator, (String)"creator");
        if (StringsKt.isBlank((CharSequence)title)) {
            throw new EmptyChapterTitleException();
        }
        UUID uUID = UUID.randomUUID();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"randomUUID(...)");
        UUID uUID2 = uUID;
        UUID uUID3 = wiki.getId();
        Object object = parentId.getId();
        IdType idType = parentId.type();
        String string = StringUtils.normalizeSpace((String)title);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"normalizeSpace(...)");
        String string2 = string;
        long l = creator.getId();
        Object object2 = this.chapterRepository.saveAndFlush((Object)new DbChapter(uUID2, uUID3, idType, (UUID)object, string2, l, null, Integer.valueOf(position), 64, null));
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"saveAndFlush(...)");
        Object it = object2 = DbChapter.Companion.toChapter((DbChapter)object2);
        boolean bl = false;
        Instant instant = it.getUpdatedAt();
        if (instant == null) {
            object = "Required value was null.";
            throw new IllegalStateException(object.toString());
        }
        this.ancestorService.updateEditedStatusForAncestors(it.getParentId(), instant, it.getModifiedBy());
        this.transactionUtils.afterCommit(() -> ChapterService.create$lambda$12$lambda$11(this, (Chapter)it));
        return object2;
    }

    @Transactional
    @NotNull
    public Chapter update(@NotNull ChapterId id, @Nullable String title, @NotNull ProfileId updater, boolean chapterWasMoved) {
        Chapter chapter;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)updater, (String)"updater");
        if (title != null && StringsKt.isBlank((CharSequence)title)) {
            throw new EmptyChapterTitleException();
        }
        DbChapter chapter2 = (DbChapter)this.chapterRepository.getReferenceById((Object)id.getId());
        if ((title == null || Intrinsics.areEqual((Object)((Object)StringsKt.trim((CharSequence)title)).toString(), (Object)chapter2.getTitle())) && !chapterWasMoved) {
            Intrinsics.checkNotNull((Object)chapter2);
            return DbChapter.Companion.toChapter(chapter2);
        }
        if (title != null) {
            chapter2.setTitle(StringUtils.normalizeSpace((String)title));
        }
        chapter2.setModifiedBy(updater.getId());
        Object object = this.chapterRepository.saveAndFlush((Object)chapter2);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"saveAndFlush(...)");
        Chapter it = chapter = DbChapter.Companion.toChapter((DbChapter)object);
        boolean bl = false;
        this.ancestorService.updateEditedStatusForAncestors(it.getParentId(), it.getUpdatedAt(), it.getModifiedBy());
        this.transactionUtils.afterCommit(() -> ChapterService.update$lambda$14$lambda$13(this, it));
        return chapter;
    }

    public static /* synthetic */ Chapter update$default(ChapterService chapterService, ChapterId chapterId, String string, ProfileId profileId, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: update");
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        return chapterService.update(chapterId, string, profileId, bl);
    }

    /*
     * WARNING - void declaration
     */
    @Transactional
    public void delete(@NotNull ChapterId chapterId, @NotNull DeletionId deletionId, @NotNull ProfileId deleter) {
        void $this$mapTo$iv$iv;
        void $this$mapToSet$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        Intrinsics.checkNotNullParameter((Object)chapterId, (String)"chapterId");
        Intrinsics.checkNotNullParameter((Object)deletionId, (String)"deletionId");
        Intrinsics.checkNotNullParameter((Object)deleter, (String)"deleter");
        Object object = this.chapterRepository.getReferenceById((Object)chapterId.getId());
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getReferenceById(...)");
        Chapter chapterToDelete = DbChapter.Companion.toChapter((DbChapter)object);
        ParentId parentId = chapterToDelete.getParentId();
        Instant instant = Instant.now();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now(...)");
        this.ancestorService.updateEditedStatusForAncestors(parentId, instant, deleter);
        Iterable $this$mapToSet$iv2 = this.findDescendantChapterIdsByChapterId(chapterId);
        boolean $i$f$mapToSet22 = false;
        Iterable iterable = $this$mapToSet$iv2;
        Collection destination$iv$iv = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapToSet$iv2));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            ChapterId chapterId2 = (ChapterId)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getId());
        }
        Set descendantChapterIds = (Set)destination$iv$iv;
        Set toDeletedChapterIds = CollectionsKt.union((Iterable)SetsKt.setOf((Object)chapterId.getId()), (Iterable)descendantChapterIds);
        this.chapterRepository.deleteByIds(toDeletedChapterIds, deletionId.getId());
        this.transactionUtils.afterCommit(() -> ChapterService.delete$lambda$17(toDeletedChapterIds, this));
        Iterable $i$f$mapToSet22 = toDeletedChapterIds;
        collection = this.articleService;
        boolean $i$f$mapToSet = false;
        destination$iv$iv = $this$mapToSet$iv;
        Collection destination$iv$iv2 = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapToSet$iv));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            UUID bl = (UUID)item$iv$iv;
            Collection collection2 = destination$iv$iv2;
            boolean bl2 = false;
            collection2.add(new ChapterId((UUID)it));
        }
        collection.deleteByParentIds((Set)destination$iv$iv2, deletionId);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Set<ChapterId> findDescendantChapterIdsByChapterId(@NotNull ChapterId chapterId) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)chapterId, (String)"chapterId");
        Iterable $this$map$iv = this.chapterRepository.findAllDescendantChapterIds(chapterId.getId());
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            UUID uUID = (UUID)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new ChapterId((UUID)it));
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    @Transactional
    public void deleteWikiChapters(@NotNull WikiId wikiId, @NotNull DeletionId deletionId) {
        void $this$mapTo$iv$iv;
        void $this$mapToSet$iv;
        Intrinsics.checkNotNullParameter((Object)wikiId, (String)"wikiId");
        Intrinsics.checkNotNullParameter((Object)deletionId, (String)"deletionId");
        Iterable iterable = this.chapterRepository.deleteByWikiId(wikiId.getId(), deletionId.getId());
        boolean $i$f$mapToSet = false;
        void var6_5 = $this$mapToSet$iv;
        Collection destination$iv$iv = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapToSet$iv));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            DbChapter dbChapter = (DbChapter)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new ChapterId(it.getId()));
        }
        Set deletedChapters = (Set)destination$iv$iv;
        this.transactionUtils.afterCommit(() -> ChapterService.deleteWikiChapters$lambda$22(deletedChapters, this));
    }

    /*
     * WARNING - void declaration
     */
    @Transactional
    public void removeDeletedChapters(@NotNull Set<DeletionId> deletionIds) {
        void $this$mapTo$iv$iv;
        void $this$mapToSet$iv;
        Intrinsics.checkNotNullParameter(deletionIds, (String)"deletionIds");
        Iterable iterable = deletionIds;
        ChapterRepository chapterRepository = this.chapterRepository;
        boolean $i$f$mapToSet = false;
        void var4_5 = $this$mapToSet$iv;
        Collection destination$iv$iv = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapToSet$iv));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            DeletionId deletionId = (DeletionId)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getId());
        }
        chapterRepository.deleteAllByDeletionIds((Set)destination$iv$iv);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Map<ChapterId, Chapter> getChaptersByIds(@NotNull Set<ChapterId> chapterIds) {
        void $this$associateByTo$iv$iv;
        DbChapter it;
        Iterable $this$mapTo$iv$iv;
        void $this$mapToSet$iv;
        Intrinsics.checkNotNullParameter(chapterIds, (String)"chapterIds");
        Iterable iterable = chapterIds;
        Object object = this.chapterRepository;
        boolean $i$f$mapToSet = false;
        void var4_5 = $this$mapToSet$iv;
        Iterable destination$iv$iv = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapToSet$iv));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            ChapterId chapterId = (ChapterId)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getId());
        }
        Iterable $this$map$iv = ChapterRepository.findByIds$default((ChapterRepository)object, (Set)((Set)destination$iv$iv), null, (int)2, null);
        boolean $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (DbChapter)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            object.add(DbChapter.Companion.toChapter(it));
        }
        Iterable $this$associateBy$iv = (List)destination$iv$iv;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        destination$iv$iv = $this$associateBy$iv;
        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it2;
            Chapter bl = (Chapter)element$iv$iv;
            object = destination$iv$iv2;
            boolean bl2 = false;
            object.put(it2.getId(), element$iv$iv);
        }
        return destination$iv$iv2;
    }

    private static final Chapter readBySubscriber$lambda$0(DbChapter it) {
        Intrinsics.checkNotNull((Object)it);
        return DbChapter.Companion.toChapter(it);
    }

    private static final Chapter readBySubscriber$lambda$1(Function1 $tmp0, Object p0) {
        return (Chapter)$tmp0.invoke(p0);
    }

    private static final Unit create$lambda$12$lambda$11(ChapterService this$0, Chapter $it) {
        this$0.applicationEventPublisher.publishEvent((ApplicationEvent)new ChapterModifiedEvent($it.getId()));
        return Unit.INSTANCE;
    }

    private static final Unit update$lambda$14$lambda$13(ChapterService this$0, Chapter $it) {
        this$0.applicationEventPublisher.publishEvent((ApplicationEvent)new ChapterModifiedEvent($it.getId()));
        return Unit.INSTANCE;
    }

    private static final Unit delete$lambda$17(Set $toDeletedChapterIds, ChapterService this$0) {
        Iterable $this$forEach$iv = $toDeletedChapterIds;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            UUID it = (UUID)element$iv;
            boolean bl = false;
            this$0.applicationEventPublisher.publishEvent((ApplicationEvent)new ChapterModifiedEvent(new ChapterId(it)));
        }
        return Unit.INSTANCE;
    }

    private static final Unit deleteWikiChapters$lambda$22(Set $deletedChapters, ChapterService this$0) {
        Iterable $this$forEach$iv = $deletedChapters;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ChapterId it = (ChapterId)element$iv;
            boolean bl = false;
            this$0.applicationEventPublisher.publishEvent((ApplicationEvent)new ChapterModifiedEvent(it));
        }
        return Unit.INSTANCE;
    }
}

