/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.wikiservice.application;

import de.justsoftware.search.shared.SearchServiceInternalConnector;
import de.justsoftware.search.shared.model.ProfileId;
import de.justsoftware.search.shared.model.SearchParam;
import de.justsoftware.search.shared.model.SearchResult;
import de.justsoftware.search.shared.model.SearchType;
import de.justsoftware.search.shared.model.SortBy;
import de.justsoftware.search.shared.model.SortDirection;
import de.justsoftware.search.shared.model.TenantId;
import de.justsoftware.wikiservice.application.ExportApplicationService;
import de.justsoftware.wikiservice.application.model.ArticleExportDto;
import de.justsoftware.wikiservice.authorization.AuthContext;
import de.justsoftware.wikiservice.business.ArticleService;
import de.justsoftware.wikiservice.model.ArticleId;
import de.justsoftware.wikiservice.model.WikiId;
import de.justsoftware.wikiservice.util.CollectionUtilsKt;
import jakarta.annotation.PostConstruct;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0001\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\n\u001a\u00020\u000bH\u0017J0\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J*\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00070\u00172\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00180\r2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lde/justsoftware/wikiservice/application/ExportApplicationService;", "", "searchServiceInternalConnector", "Lde/justsoftware/search/shared/SearchServiceInternalConnector;", "articleService", "Lde/justsoftware/wikiservice/business/ArticleService;", "injectedDomainPrefix", "", "<init>", "(Lde/justsoftware/search/shared/SearchServiceInternalConnector;Lde/justsoftware/wikiservice/business/ArticleService;Ljava/lang/String;)V", "init", "", "exportArticles", "", "Lde/justsoftware/wikiservice/application/model/ArticleExportDto;", "modifiedAfter", "Ljava/time/Instant;", "offset", "", "limit", "authContext", "Lde/justsoftware/wikiservice/authorization/AuthContext;", "exportProsemirror", "", "Lde/justsoftware/wikiservice/model/ArticleId;", "articleIds", "Companion", "wiki-service"})
@SourceDebugExtension(value={"SMAP\nExportApplicationService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExportApplicationService.kt\nde/justsoftware/wikiservice/application/ExportApplicationService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 CollectionUtils.kt\nde/justsoftware/wikiservice/util/CollectionUtilsKt\n*L\n1#1,76:1\n1#2:77\n1557#3:78\n1628#3,3:79\n1628#3,3:83\n7#4:82\n*S KotlinDebug\n*F\n+ 1 ExportApplicationService.kt\nde/justsoftware/wikiservice/application/ExportApplicationService\n*L\n53#1:78\n53#1:79,3\n60#1:83,3\n60#1:82\n*E\n"})
public class ExportApplicationService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SearchServiceInternalConnector searchServiceInternalConnector;
    @NotNull
    private final ArticleService articleService;
    @NotNull
    private String injectedDomainPrefix;
    @NotNull
    private static String domainPrefix = "";
    @NotNull
    private static String urlPrefix = "";

    public ExportApplicationService(@NotNull SearchServiceInternalConnector searchServiceInternalConnector, @NotNull ArticleService articleService, @Value(value="${just.common.system.domainprefix:}") @NotNull String injectedDomainPrefix) {
        Intrinsics.checkNotNullParameter((Object)searchServiceInternalConnector, (String)"searchServiceInternalConnector");
        Intrinsics.checkNotNullParameter((Object)articleService, (String)"articleService");
        Intrinsics.checkNotNullParameter((Object)injectedDomainPrefix, (String)"injectedDomainPrefix");
        this.searchServiceInternalConnector = searchServiceInternalConnector;
        this.articleService = articleService;
        this.injectedDomainPrefix = injectedDomainPrefix;
    }

    @PostConstruct
    public void init() {
        domainPrefix = this.injectedDomainPrefix;
        urlPrefix = ((CharSequence)domainPrefix).length() == 0 ? "" : domainPrefix + "/just";
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<ArticleExportDto> exportArticles(@Nullable Instant modifiedAfter, int offset, int limit, @NotNull AuthContext authContext) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Date date;
        SortDirection p0;
        Object object;
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        SearchServiceInternalConnector searchServiceInternalConnector = this.searchServiceInternalConnector;
        Object object2 = new ProfileId(authContext.getUser().getId());
        TenantId tenantId = new TenantId(authContext.getTenantId().getId());
        Instant instant = modifiedAfter;
        if (instant != null) {
            Instant instant2 = instant;
            object = searchServiceInternalConnector;
            boolean $i$f$exportArticles$stub_for_inlining = false;
            boolean bl = false;
            date = Date.from((Instant)p0);
            searchServiceInternalConnector = object;
        } else {
            date = null;
        }
        Date date2 = date;
        Set set = SetsKt.setOf((Object)SearchType.WIKI_ARTICLE);
        p0 = SortDirection.DESC;
        SortBy $i$f$exportArticles$stub_for_inlining = SortBy.MODIFY_DATE;
        object2 = searchServiceInternalConnector.search(new SearchParam(tenantId, object2, null, set, null, null, null, null, null, null, null, null, null, null, date2, null, true, offset, limit, $i$f$exportArticles$stub_for_inlining, p0, 49140, null)).getResults();
        tenantId = ArticleExportDto.Companion;
        boolean $i$f$map = false;
        set = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p02;
            SearchResult searchResult = (SearchResult)item$iv$iv;
            object = destination$iv$iv;
            boolean $i$f$exportArticles$stub_for_inlining$0 = false;
            boolean bl = false;
            object.add(tenantId.fromSearchResult((SearchResult)p02));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Map<ArticleId, String> exportProsemirror(@NotNull List<ArticleId> articleIds, @NotNull AuthContext authContext) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(articleIds, (String)"articleIds");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        Iterable $this$mapToSet$iv = this.articleService.findWikiIdsForArticles(articleIds);
        boolean $i$f$mapToSet = false;
        Iterable iterable = $this$mapToSet$iv;
        Collection destination$iv$iv = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapToSet$iv));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Pair pair = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new WikiId((UUID)it.getSecond()));
        }
        Set wikiIds = (Set)destination$iv$iv;
        authContext.checkReadWikis(wikiIds);
        return this.articleService.exportArticles(articleIds);
    }

    @NotNull
    public static final String getDomainPrefix() {
        return Companion.getDomainPrefix();
    }

    @NotNull
    public static final String getUrlPrefix() {
        return Companion.getUrlPrefix();
    }

    public static final /* synthetic */ String access$getDomainPrefix$cp() {
        return domainPrefix;
    }

    public static final /* synthetic */ String access$getUrlPrefix$cp() {
        return urlPrefix;
    }
}

