--liquibase formatted sql

--changeset vinh.phu.phan:create_solr_document_visibility_table
CREATE TABLE solr_document_visibility (
    id VARCHAR(255) NOT NULL PRIMARY KEY,
    type VARCHAR(255) NOT NULL,
    visible_by_parent_id VARCHAR(255),
    visible_for_roles VARCHAR(4096),
    restricted_visible_for_roles VARCHAR(4096),
    use_restricted_visibility BOOLEAN,
    tenant_id UUID,
    created_at TIMESTAMP,
    updated_at TIMESTAMP
);
CREATE INDEX solr_document_visibility_type_index ON solr_document_visibility(type);
CREATE INDEX solr_document_visibility_visible_by_parent_id_index ON solr_document_visibility(visible_by_parent_id);

--changeset vinh.phu.phan:update_visible_for_roles_and_restricted_visible_for_roles_to_text
ALTER TABLE solr_document_visibility ALTER COLUMN visible_for_roles TYPE text;
ALTER TABLE solr_document_visibility ALTER COLUMN restricted_visible_for_roles TYPE text;

-- changeset vinh.phu.phan:migrate_visibilities_to_text_Array
ALTER TABLE solr_document_visibility
  ALTER COLUMN visible_for_roles TYPE text[] USING
    CASE
      WHEN visible_for_roles IS NULL OR visible_for_roles = '' THEN ARRAY[]::text[]
      ELSE string_to_array(visible_for_roles, ';')
    END;

ALTER TABLE solr_document_visibility
  ALTER COLUMN restricted_visible_for_roles TYPE text[] USING
    CASE
      WHEN restricted_visible_for_roles IS NULL OR restricted_visible_for_roles = '' THEN ARRAY[]::text[]
      ELSE string_to_array(restricted_visible_for_roles, ';')
    END;

CREATE INDEX IF NOT EXISTS solr_document_visibility_roles_gin_idx
  ON solr_document_visibility USING GIN (visible_for_roles);

CREATE INDEX IF NOT EXISTS solr_document_visibility_restricted_roles_gin_idx
  ON solr_document_visibility USING GIN (restricted_visible_for_roles);

CREATE INDEX IF NOT EXISTS solr_document_visibility_tenant_id_idx
  ON solr_document_visibility(tenant_id);


--changeset vinh.phu.phan:add_content_chunk_and_embeddings_tables
CREATE TABLE content_chunk (
  id UUID PRIMARY KEY NOT NULL,
  document_id VARCHAR(255) NOT NULL,
  chunk_index INT NOT NULL,
  content TEXT NOT NULL,
  content_md5 VARCHAR(32) NOT NULL,
  embedding VECTOR(384),
  created_at TIMESTAMP,
  updated_at TIMESTAMP,
  CONSTRAINT uq_content_chunk UNIQUE (document_id, chunk_index)
);

CREATE INDEX content_chunk_document_id_idx  ON content_chunk(document_id);
CREATE INDEX content_chunk_content_md5_idx  ON content_chunk(content_md5);

CREATE INDEX content_chunk_embedding_hnsw_idx ON content_chunk
USING hnsw (embedding vector_cosine_ops) WITH (m=16, ef_construction=200);
