/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.permission.kafka.impl;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.NewTopic;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.kafka.core.KafkaAdmin;

/*
 * Exception performing whole class analysis ignored.
 */
@Profile(value={"!test"})
@Configuration
public class KafkaTopicConfiguration {
    private static final String SEVEN_DAYS_IN_MS = "604800000";
    private static final ImmutableMap<String, String> DEFAULT_TOPIC_CONFIG = ImmutableMap.of((Object)"delete.retention.ms", (Object)"604800000", (Object)"segment.ms", (Object)"604800000", (Object)"cleanup.policy", (Object)"compact");

    @Bean
    public @Nullable KafkaAdmin admin(@Value(value="${kafka.boostrapServers:}") @Nullable String bootstrapServer) {
        if (Strings.isNullOrEmpty((String)bootstrapServer)) {
            return null;
        }
        ImmutableMap configs = ImmutableMap.of((Object)"bootstrap.servers", (Object)bootstrapServer);
        KafkaAdmin kafkaAdmin = new KafkaAdmin((Map)configs);
        kafkaAdmin.setFatalIfBrokerNotAvailable(true);
        return kafkaAdmin;
    }

    @Bean
    public @Nullable AdminClient adminClient(@Value(value="${kafka.boostrapServers:}") @Nullable String bootstrapServer) {
        if (Strings.isNullOrEmpty((String)bootstrapServer)) {
            return null;
        }
        ImmutableMap configs = ImmutableMap.of((Object)"bootstrap.servers", (Object)bootstrapServer);
        return AdminClient.create((Map)configs);
    }

    private static NewTopic topicFactory(String topicName) {
        return KafkaTopicConfiguration.topicFactory((String)topicName, (int)1);
    }

    private static NewTopic topicFactory(String topicName, int partitions) {
        NewTopic topic = new NewTopic(topicName, partitions, 1);
        return topic.configs((Map)DEFAULT_TOPIC_CONFIG);
    }

    @Bean
    public NewTopic permissionConfigTopic() {
        return KafkaTopicConfiguration.topicFactory((String)"just.permission.config");
    }

    @Bean
    public NewTopic permissionItemTopic() {
        return KafkaTopicConfiguration.topicFactory((String)"just.permission.item", (int)5);
    }

    @Bean
    public NewTopic permissionSingleRoleAssignment() {
        return KafkaTopicConfiguration.topicFactory((String)"just.permission.singleRoleAssignment", (int)5);
    }

    @Bean
    public NewTopic permissionMultiRoleAssignment() {
        return KafkaTopicConfiguration.topicFactory((String)"just.permission.multiRoleAssignment", (int)5);
    }
}

