/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.news.scheduled;

import de.justsoftware.news.domain.delete.DeleteService;
import de.justsoftware.news.domain.post.Post;
import de.justsoftware.news.domain.post.PostService;
import de.justsoftware.news.domain.post.unreadmark.PostUnreadMarkService;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0017\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0001\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0017J\b\u0010\u000f\u001a\u00020\u0010H\u0017J\b\u0010\u0011\u001a\u00020\u0010H\u0017J\b\u0010\u0012\u001a\u00020\u0010H\u0017J\b\u0010\u0013\u001a\u00020\u0010H\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lde/justsoftware/news/scheduled/ScheduledJobs;", "", "deleteService", "Lde/justsoftware/news/domain/delete/DeleteService;", "postUnreadMarkService", "Lde/justsoftware/news/domain/post/unreadmark/PostUnreadMarkService;", "postService", "Lde/justsoftware/news/domain/post/PostService;", "cleanUpPostUnreadMarksDelay", "Ljava/time/Duration;", "<init>", "(Lde/justsoftware/news/domain/delete/DeleteService;Lde/justsoftware/news/domain/post/unreadmark/PostUnreadMarkService;Lde/justsoftware/news/domain/post/PostService;Ljava/time/Duration;)V", "publishScheduledPosts", "", "Lde/justsoftware/news/domain/post/Post;", "markPostsForDeletion", "", "delete", "cleanUpOldPostUnreadMarks", "unpinPostsAfterPinExpiration", "news-service"})
public class ScheduledJobs {
    @NotNull
    private final DeleteService deleteService;
    @NotNull
    private final PostUnreadMarkService postUnreadMarkService;
    @NotNull
    private final PostService postService;
    @NotNull
    private final Duration cleanUpPostUnreadMarksDelay;

    public ScheduledJobs(@NotNull DeleteService deleteService, @NotNull PostUnreadMarkService postUnreadMarkService, @NotNull PostService postService, @Value(value="${just.news.postunreadmarks.cleanup.delay:P30D}") @NotNull Duration cleanUpPostUnreadMarksDelay) {
        Intrinsics.checkNotNullParameter((Object)deleteService, (String)"deleteService");
        Intrinsics.checkNotNullParameter((Object)postUnreadMarkService, (String)"postUnreadMarkService");
        Intrinsics.checkNotNullParameter((Object)postService, (String)"postService");
        Intrinsics.checkNotNullParameter((Object)cleanUpPostUnreadMarksDelay, (String)"cleanUpPostUnreadMarksDelay");
        this.deleteService = deleteService;
        this.postUnreadMarkService = postUnreadMarkService;
        this.postService = postService;
        this.cleanUpPostUnreadMarksDelay = cleanUpPostUnreadMarksDelay;
    }

    @Scheduled(fixedRate=1L, timeUnit=TimeUnit.MINUTES)
    @NotNull
    public List<Post> publishScheduledPosts() {
        return this.postService.publishScheduledPosts();
    }

    @Scheduled(fixedRate=1L, timeUnit=TimeUnit.MINUTES)
    public void markPostsForDeletion() {
        this.deleteService.markPostsForDeletion();
    }

    @Scheduled(fixedRate=1L, timeUnit=TimeUnit.DAYS)
    public void delete() {
        this.deleteService.delete();
    }

    @Scheduled(fixedRateString="${just.news.postunreadmarks.cleanup.rate:P1D}")
    public void cleanUpOldPostUnreadMarks() {
        this.postUnreadMarkService.cleanUpOldEntries(this.cleanUpPostUnreadMarksDelay);
    }

    @Scheduled(fixedRate=1L, timeUnit=TimeUnit.MINUTES)
    public void unpinPostsAfterPinExpiration() {
        this.postService.unpinPostsAfterPinExpiration();
    }
}

