/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.news.domain.poll;

import com.fasterxml.jackson.core.FormatSchema;
import com.fasterxml.jackson.databind.SequenceWriter;
import com.fasterxml.jackson.dataformat.csv.CsvMapper;
import com.fasterxml.jackson.dataformat.csv.CsvSchema;
import de.justsoftware.news.auth.AuthorizationContext;
import de.justsoftware.news.domain.csv.CsvExport;
import de.justsoftware.news.domain.csv.CsvExportContext;
import de.justsoftware.news.domain.csv.CsvExportEntry;
import de.justsoftware.news.domain.csv.CsvExportLanguage;
import de.justsoftware.news.domain.poll.Poll;
import de.justsoftware.news.domain.poll.PollAnswer;
import de.justsoftware.news.domain.poll.PollAnswerRepo;
import de.justsoftware.news.domain.poll.PollPrivacy;
import de.justsoftware.news.domain.poll.PollRepo;
import de.justsoftware.news.domain.poll.PollVote;
import de.justsoftware.news.domain.poll.PollVoteRepo;
import de.justsoftware.news.domain.post.Post;
import de.justsoftware.news.domain.post.PostRepo;
import de.justsoftware.news.domain.post.model.PostAction;
import de.justsoftware.news.domain.user.Profile;
import de.justsoftware.news.domain.user.ProfileRepo;
import de.justsoftware.news.id.ItemId;
import de.justsoftware.news.id.PollId;
import de.justsoftware.news.id.ProfileId;
import java.io.Closeable;
import java.io.StringWriter;
import java.io.Writer;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0017J4\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00182\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u0012\u001a\u00020\u0013H\u0012J$\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u00172\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001f0\u00172\u0006\u0010\u0019\u001a\u00020\u001aH\u0012J\u001e\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010!\u001a\u00020\u001e2\u0006\u0010\u0012\u001a\u00020\u0013H\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lde/justsoftware/news/domain/poll/PollCsvExportService;", "", "pollRepo", "Lde/justsoftware/news/domain/poll/PollRepo;", "pollAnswerRepo", "Lde/justsoftware/news/domain/poll/PollAnswerRepo;", "pollVoteRepo", "Lde/justsoftware/news/domain/poll/PollVoteRepo;", "postRepo", "Lde/justsoftware/news/domain/post/PostRepo;", "profileRepo", "Lde/justsoftware/news/domain/user/ProfileRepo;", "<init>", "(Lde/justsoftware/news/domain/poll/PollRepo;Lde/justsoftware/news/domain/poll/PollAnswerRepo;Lde/justsoftware/news/domain/poll/PollVoteRepo;Lde/justsoftware/news/domain/post/PostRepo;Lde/justsoftware/news/domain/user/ProfileRepo;)V", "export", "Lde/justsoftware/news/domain/csv/CsvExport;", "pollId", "Lde/justsoftware/news/id/PollId;", "language", "Lde/justsoftware/news/domain/csv/CsvExportLanguage;", "authContext", "Lde/justsoftware/news/auth/AuthorizationContext;", "buildHeadersRow", "", "", "isAnonymousExport", "", "question", "answers", "fetchAndBuildCsvExportEntries", "Lde/justsoftware/news/domain/csv/CsvExportEntry;", "Lde/justsoftware/news/domain/poll/PollAnswer;", "buildRow", "rowData", "news-service"})
@SourceDebugExtension(value={"SMAP\nPollCsvExportService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PollCsvExportService.kt\nde/justsoftware/news/domain/poll/PollCsvExportService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,159:1\n1563#2:160\n1634#2,3:161\n1563#2:165\n1634#2,3:166\n1563#2:169\n1634#2,3:170\n1669#2,8:173\n1563#2:181\n1634#2,3:182\n1056#2:185\n1573#2:186\n1604#2,3:187\n1563#2:190\n1634#2,2:191\n774#2:193\n865#2,2:194\n1636#2:196\n1607#2:197\n1563#2:198\n1634#2,3:199\n1#3:164\n*S KotlinDebug\n*F\n+ 1 PollCsvExportService.kt\nde/justsoftware/news/domain/poll/PollCsvExportService\n*L\n57#1:160\n57#1:161,3\n62#1:165\n62#1:166,3\n98#1:169\n98#1:170,3\n101#1:173,8\n106#1:181\n106#1:182,3\n110#1:185\n111#1:186\n111#1:187,3\n118#1:190\n118#1:191,2\n120#1:193\n120#1:194,2\n118#1:196\n111#1:197\n131#1:198\n131#1:199,3\n*E\n"})
public class PollCsvExportService {
    @NotNull
    private final PollRepo pollRepo;
    @NotNull
    private final PollAnswerRepo pollAnswerRepo;
    @NotNull
    private final PollVoteRepo pollVoteRepo;
    @NotNull
    private final PostRepo postRepo;
    @NotNull
    private final ProfileRepo profileRepo;

    public PollCsvExportService(@NotNull PollRepo pollRepo, @NotNull PollAnswerRepo pollAnswerRepo, @NotNull PollVoteRepo pollVoteRepo, @NotNull PostRepo postRepo, @NotNull ProfileRepo profileRepo) {
        Intrinsics.checkNotNullParameter((Object)pollRepo, (String)"pollRepo");
        Intrinsics.checkNotNullParameter((Object)pollAnswerRepo, (String)"pollAnswerRepo");
        Intrinsics.checkNotNullParameter((Object)pollVoteRepo, (String)"pollVoteRepo");
        Intrinsics.checkNotNullParameter((Object)postRepo, (String)"postRepo");
        Intrinsics.checkNotNullParameter((Object)profileRepo, (String)"profileRepo");
        this.pollRepo = pollRepo;
        this.pollAnswerRepo = pollAnswerRepo;
        this.pollVoteRepo = pollVoteRepo;
        this.postRepo = postRepo;
        this.profileRepo = profileRepo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Transactional
    @NotNull
    public CsvExport export(@NotNull PollId pollId, @NotNull CsvExportLanguage language, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)pollId, (String)"pollId");
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        Poll poll = this.pollRepo.getById(pollId);
        Post post = this.postRepo.getByIdAndDeletedFalse(poll.getPostId());
        authContext.checkPostAction(post, PostAction.POLL_EXPORT);
        List answers = this.pollAnswerRepo.findAllByPollId(poll.getId());
        boolean isAnonymousExport = poll.getPrivacy() == PollPrivacy.ANONYMOUS || poll.getPrivacy() == PollPrivacy.MANAGERS_ONLY && !authContext.mayManage((ItemId)post.getId());
        Closeable closeable = new StringWriter();
        Throwable throwable = null;
        try {
            CsvExport csvExport;
            StringWriter stringWriter = (StringWriter)closeable;
            boolean bl = false;
            stringWriter.write("\ufeff");
            Closeable closeable2 = (Closeable)new CsvMapper().writer((FormatSchema)CsvSchema.emptySchema().withColumnSeparator(';')).writeValues((Writer)stringWriter);
            Throwable throwable2 = null;
            try {
                void $this$mapTo$iv$iv;
                CsvExportEntry it;
                Collection<String> collection;
                void $this$mapTo$iv$iv2;
                Iterable $this$map$iv;
                SequenceWriter sequenceWriter = (SequenceWriter)closeable2;
                boolean bl2 = false;
                Iterable iterable = answers;
                String string = poll.getQuestion();
                boolean bl3 = isAnonymousExport;
                Object object = this;
                boolean $i$f$map = false;
                void var21_28 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                    PollAnswer pollAnswer = (PollAnswer)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl4 = false;
                    collection.add(it.getText());
                }
                collection = (List)destination$iv$iv;
                List it2 = object.buildHeadersRow(bl3, string, (List)collection, language);
                boolean $i$a$-let-PollCsvExportService$export$1$1$32 = false;
                sequenceWriter.write((Object)it2);
                $this$map$iv = this.fetchAndBuildCsvExportEntries(answers, isAnonymousExport);
                $i$f$map = false;
                Iterable $i$a$-let-PollCsvExportService$export$1$1$32 = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    it = (CsvExportEntry)item$iv$iv;
                    object = destination$iv$iv;
                    boolean bl5 = false;
                    object.add(this.buildRow(it, language));
                }
                it = (List)destination$iv$iv;
                boolean bl6 = false;
                sequenceWriter.write((Object)it);
                String string2 = post.getTitle();
                String string3 = stringWriter.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
                csvExport = new CsvExport(string2, ((Object)StringsKt.trim((CharSequence)string3)).toString());
            }
            catch (Throwable throwable3) {
                try {
                    try {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        CloseableKt.closeFinally((Closeable)closeable2, throwable2);
                        throw throwable4;
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
            }
            CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            CsvExport csvExport2 = csvExport;
            return csvExport2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private List<String> buildHeadersRow(boolean isAnonymousExport, String question, List<String> answers, CsvExportLanguage language) {
        List list;
        if (language == CsvExportLanguage.DE) {
            if (isAnonymousExport) {
                Object[] objectArray = new String[]{"Teilnehmer-Nr.", "Datum der Antwort", question};
                list = CollectionsKt.plus((Collection)CollectionsKt.listOf((Object[])objectArray), (Iterable)answers);
            } else {
                Object[] objectArray = new String[]{"Teilnehmer-Nr.", "Datum der Antwort", "Profile-ID", "Titel", "Vorname", "Nachname", "Nachtitel", question};
                list = CollectionsKt.plus((Collection)CollectionsKt.listOf((Object[])objectArray), (Iterable)answers);
            }
        } else if (isAnonymousExport) {
            Object[] objectArray = new String[]{"No.", "Date of response", question};
            list = CollectionsKt.plus((Collection)CollectionsKt.listOf((Object[])objectArray), (Iterable)answers);
        } else {
            Object[] objectArray = new String[]{"No.", "Date of response", "Profile ID", "Title", "First name", "Last name", "Additional title", question};
            list = CollectionsKt.plus((Collection)CollectionsKt.listOf((Object[])objectArray), (Iterable)answers);
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    private List<CsvExportEntry> fetchAndBuildCsvExportEntries(List<PollAnswer> answers, boolean isAnonymousExport) {
        void $this$mapIndexedTo$iv$iv;
        void $this$mapIndexed$iv;
        Iterable $this$sortedBy$iv;
        List it;
        Iterable iterable;
        void $this$distinctBy$iv;
        PollVote it2;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable2 = answers;
        Object object = this.pollVoteRepo;
        boolean $i$f$map22 = false;
        void var6_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            PollAnswer pollAnswer = (PollAnswer)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it2.getId());
        }
        Set votesForAllAnswers = object.findByAnswerIdIn(CollectionsKt.toSet((Iterable)((List)destination$iv$iv)));
        Iterable $i$f$map22 = votesForAllAnswers;
        boolean $i$f$distinctBy22 = false;
        Iterable<ProfileId> set$iv = new HashSet();
        ArrayList list$iv = new ArrayList();
        for (Object e$iv : $this$distinctBy$iv) {
            it2 = (PollVote)e$iv;
            boolean bl = false;
            ProfileId key$iv = it2.getProfileId();
            if (!((HashSet)set$iv).add(key$iv)) continue;
            list$iv.add(e$iv);
        }
        List distinctVotes = list$iv;
        if (isAnonymousExport) {
            iterable = SetsKt.emptySet();
        } else {
            void $this$mapTo$iv$iv2;
            void $this$map$iv2;
            set$iv = distinctVotes;
            boolean $i$f$map = false;
            Iterator iterator = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void it3;
                PollVote pollVote = (PollVote)item$iv$iv;
                object = destination$iv$iv2;
                boolean bl = false;
                object.add(it3.getProfileId());
            }
            it = (List)destination$iv$iv2;
            boolean bl = false;
            Iterable iterable3 = this.profileRepo.findAllById((Iterable)it);
            iterable = iterable3;
            Intrinsics.checkNotNullExpressionValue((Object)iterable3, (String)"let(...)");
        }
        Iterable voters = iterable;
        Iterable $i$f$distinctBy22 = distinctVotes;
        boolean $i$f$sortedBy = false;
        $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)((Comparator)new /* Unavailable Anonymous Inner Class!! */));
        boolean $i$f$mapIndexed = false;
        it = $this$mapIndexed$iv;
        Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            Collection<Pair> collection;
            void $this$mapTo$iv$iv3;
            void $this$map$iv3;
            Object object2;
            void var20_37;
            Instant instant;
            void vote;
            Iterable iterable4;
            block11: {
                void index;
                int n;
                if ((n = index$iv$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                PollVote bl = (PollVote)item$iv$iv;
                int n2 = n;
                object = destination$iv$iv3;
                boolean bl2 = false;
                iterable4 = voters;
                instant = vote.getVoteDate();
                var20_37 = index + true;
                Iterable iterable5 = iterable4;
                for (Object t : iterable5) {
                    Profile it4 = (Profile)t;
                    boolean bl3 = false;
                    if (!Intrinsics.areEqual((Object)it4.getId(), (Object)vote.getProfileId())) continue;
                    object2 = t;
                    break block11;
                }
                object2 = null;
            }
            Profile profile = object2;
            iterable4 = answers;
            profile = profile;
            boolean $i$f$map = false;
            Iterator iterator = $this$map$iv3;
            Collection destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
            boolean $i$f$mapTo3 = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv3) {
                Object v3;
                void answer;
                block12: {
                    void $this$filterTo$iv$iv;
                    PollAnswer pollAnswer = (PollAnswer)item$iv$iv2;
                    collection = destination$iv$iv4;
                    boolean bl = false;
                    Iterable $this$filter$iv = votesForAllAnswers;
                    boolean $i$f$filter = false;
                    Iterable iterable6 = $this$filter$iv;
                    Collection destination$iv$iv5 = new ArrayList();
                    boolean $i$f$filterTo = false;
                    for (Object element$iv$iv : $this$filterTo$iv$iv) {
                        PollVote it5 = (PollVote)element$iv$iv;
                        boolean bl4 = false;
                        if (!Intrinsics.areEqual((Object)it5.getAnswerId(), (Object)answer.getId())) continue;
                        destination$iv$iv5.add(element$iv$iv);
                    }
                    List votesForAnswer = (List)destination$iv$iv5;
                    iterable6 = votesForAnswer;
                    for (Object t : iterable6) {
                        PollVote it6 = (PollVote)t;
                        boolean bl5 = false;
                        if (!Intrinsics.areEqual((Object)it6.getProfileId(), (Object)vote.getProfileId())) continue;
                        v3 = t;
                        break block12;
                    }
                    v3 = null;
                }
                PollVote voteOfCurrentProfile = v3;
                boolean hasVoted = voteOfCurrentProfile != null;
                collection.add(new Pair((Object)answer.getId(), (Object)hasVoted));
            }
            Collection<Pair> collection2 = collection = (List)destination$iv$iv4;
            Profile profile2 = profile;
            Instant instant2 = instant;
            void var46_66 = var20_37;
            object.add(new CsvExportEntry((int)var46_66, instant2, profile2, (List)collection2));
        }
        return (List)destination$iv$iv3;
    }

    /*
     * WARNING - void declaration
     */
    private List<String> buildRow(CsvExportEntry rowData, CsvExportLanguage language) {
        List list;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = rowData.getVotes();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Pair pair = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((Boolean)it.getSecond() != false ? CsvExportContext.INSTANCE.getYesTranslation(language) : CsvExportContext.INSTANCE.getNoTranslation(language));
        }
        List translatedVotes = (List)destination$iv$iv;
        String index = String.valueOf(rowData.getIndex());
        String voteDate = CsvExportContext.INSTANCE.getDateTimeFormatter().format(rowData.getVoteDate());
        Profile profile = rowData.getProfile();
        String question = "";
        if (profile == null) {
            Object[] objectArray = new String[]{index, voteDate, question};
            list = CollectionsKt.plus((Collection)CollectionsKt.listOf((Object[])objectArray), (Iterable)translatedVotes);
        } else {
            Object[] objectArray = new String[8];
            objectArray[0] = index;
            objectArray[1] = voteDate;
            objectArray[2] = profile.getId().toTypedString();
            String string = profile.getPrefix();
            if (string == null) {
                string = "";
            }
            objectArray[3] = string;
            objectArray[4] = profile.getFirstName();
            objectArray[5] = profile.getLastName();
            String string2 = profile.getSuffix();
            if (string2 == null) {
                string2 = "";
            }
            objectArray[6] = string2;
            objectArray[7] = question;
            list = CollectionsKt.plus((Collection)CollectionsKt.listOf((Object[])objectArray), (Iterable)translatedVotes);
        }
        return list;
    }
}

