/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.news.domain.channel;

import com.netflix.graphql.dgs.DgsComponent;
import com.netflix.graphql.dgs.DgsDataFetchingEnvironment;
import com.netflix.graphql.dgs.DgsMutation;
import com.netflix.graphql.dgs.InputArgument;
import com.netflix.graphql.dgs.context.DgsContext;
import de.justsoftware.news.auth.AuthorizationContext;
import de.justsoftware.news.domain.channel.Channel;
import de.justsoftware.news.domain.channel.ChannelDataFetcherKt;
import de.justsoftware.news.domain.channel.ChannelService;
import de.justsoftware.news.domain.delete.DeleteService;
import de.justsoftware.news.domain.subscription.ChannelSubscriptionService;
import de.justsoftware.news.id.ChannelId;
import graphql.schema.DataFetchingEnvironment;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@DgsComponent
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u001a\u0010\n\u001a\u00020\u000b2\b\b\u0001\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0017J\"\u0010\u0010\u001a\u00020\u000b2\b\b\u0001\u0010\u0011\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0017J\u001a\u0010\u0013\u001a\u00020\u00122\b\b\u0001\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\u000fH\u0017J$\u0010\u0014\u001a\u00020\u000b2\b\b\u0001\u0010\u0015\u001a\u00020\u00122\b\b\u0001\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000e\u001a\u00020\u000fH\u0017J\u001a\u0010\u0018\u001a\u00020\u000b2\b\b\u0001\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\u000fH\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lde/justsoftware/news/domain/channel/ChannelMutations;", "", "channelService", "Lde/justsoftware/news/domain/channel/ChannelService;", "deleteService", "Lde/justsoftware/news/domain/delete/DeleteService;", "channelSubscriptionService", "Lde/justsoftware/news/domain/subscription/ChannelSubscriptionService;", "<init>", "(Lde/justsoftware/news/domain/channel/ChannelService;Lde/justsoftware/news/domain/delete/DeleteService;Lde/justsoftware/news/domain/subscription/ChannelSubscriptionService;)V", "addChannel", "Lde/justsoftware/news/graphql/generated/types/Channel;", "title", "", "dfe", "Lcom/netflix/graphql/dgs/DgsDataFetchingEnvironment;", "updateChannel", "id", "Lde/justsoftware/news/id/ChannelId;", "deleteChannel", "subscribeChannel", "channelId", "notificationsEnabled", "", "unsubscribeChannel", "news-service"})
public class ChannelMutations {
    @NotNull
    private final ChannelService channelService;
    @NotNull
    private final DeleteService deleteService;
    @NotNull
    private final ChannelSubscriptionService channelSubscriptionService;

    public ChannelMutations(@NotNull ChannelService channelService, @NotNull DeleteService deleteService, @NotNull ChannelSubscriptionService channelSubscriptionService) {
        Intrinsics.checkNotNullParameter((Object)channelService, (String)"channelService");
        Intrinsics.checkNotNullParameter((Object)deleteService, (String)"deleteService");
        Intrinsics.checkNotNullParameter((Object)channelSubscriptionService, (String)"channelSubscriptionService");
        this.channelService = channelService;
        this.deleteService = deleteService;
        this.channelSubscriptionService = channelSubscriptionService;
    }

    @DgsMutation(field="addChannel")
    @NotNull
    public de.justsoftware.news.graphql.generated.types.Channel addChannel(@InputArgument @NotNull String title, @NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        return ChannelDataFetcherKt.toGql((Channel)this.channelService.create(title, (AuthorizationContext)DgsContext.Companion.getCustomContext((DataFetchingEnvironment)dfe)));
    }

    @DgsMutation(field="updateChannel")
    @NotNull
    public de.justsoftware.news.graphql.generated.types.Channel updateChannel(@InputArgument @NotNull ChannelId id, @NotNull String title, @NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        return ChannelDataFetcherKt.toGql((Channel)this.channelService.update(id, title, (AuthorizationContext)DgsContext.Companion.getCustomContext((DataFetchingEnvironment)dfe)));
    }

    @DgsMutation(field="deleteChannel")
    @NotNull
    public ChannelId deleteChannel(@InputArgument @NotNull ChannelId id, @NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        return this.deleteService.markChannelAsDeleted(id, (AuthorizationContext)DgsContext.Companion.getCustomContext((DataFetchingEnvironment)dfe));
    }

    @DgsMutation(field="subscribeChannel")
    @NotNull
    public de.justsoftware.news.graphql.generated.types.Channel subscribeChannel(@InputArgument @NotNull ChannelId channelId, @InputArgument boolean notificationsEnabled, @NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        AuthorizationContext authContext = (AuthorizationContext)DgsContext.Companion.getCustomContext((DataFetchingEnvironment)dfe);
        this.channelSubscriptionService.subscribe(channelId, notificationsEnabled, authContext);
        return ChannelDataFetcherKt.toGql((Channel)this.channelService.getById(channelId, authContext));
    }

    @DgsMutation(field="unsubscribeChannel")
    @NotNull
    public de.justsoftware.news.graphql.generated.types.Channel unsubscribeChannel(@InputArgument @NotNull ChannelId channelId, @NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        AuthorizationContext authContext = (AuthorizationContext)DgsContext.Companion.getCustomContext((DataFetchingEnvironment)dfe);
        this.channelSubscriptionService.unsubscribe(channelId, authContext);
        return ChannelDataFetcherKt.toGql((Channel)this.channelService.getById(channelId, authContext));
    }
}

