/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.news.connector.drive;

import de.justsoftware.news.connector.drive.DriveApiAddException;
import de.justsoftware.news.connector.drive.DriveApiDeleteException;
import de.justsoftware.news.connector.drive.DriveDocument;
import de.justsoftware.news.id.DocumentId;
import de.justsoftware.news.id.DriveFileReferenceId;
import de.justsoftware.news.id.ProfileId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.stereotype.Service;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestClient;

@Service
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B!\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ$\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lde/justsoftware/news/connector/drive/DriveApiConnector;", "", "driveInternalUrl", "", "restClientBuilder", "Lorg/springframework/web/client/RestClient$Builder;", "authInterceptor", "Lorg/springframework/http/client/ClientHttpRequestInterceptor;", "<init>", "(Ljava/lang/String;Lorg/springframework/web/client/RestClient$Builder;Lorg/springframework/http/client/ClientHttpRequestInterceptor;)V", "authorizedRestClient", "Lorg/springframework/web/client/RestClient;", "addFiles", "", "Lde/justsoftware/news/connector/drive/DriveDocument;", "tempIds", "Lde/justsoftware/news/id/DocumentId;", "itemId", "Lde/justsoftware/news/id/DriveFileReferenceId;", "deleteFile", "", "documentId", "userId", "Lde/justsoftware/news/id/ProfileId;", "news-service"})
@SourceDebugExtension(value={"SMAP\nDriveApiConnector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DriveApiConnector.kt\nde/justsoftware/news/connector/drive/DriveApiConnector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,98:1\n1563#2:99\n1634#2,3:100\n1563#2:103\n1634#2,3:104\n1563#2:107\n1634#2,3:108\n1563#2:111\n1634#2,2:112\n1636#2:115\n1#3:114\n*S KotlinDebug\n*F\n+ 1 DriveApiConnector.kt\nde/justsoftware/news/connector/drive/DriveApiConnector\n*L\n47#1:99\n47#1:100,3\n57#1:103\n57#1:104,3\n58#1:107\n58#1:108,3\n68#1:111\n68#1:112,2\n68#1:115\n*E\n"})
public class DriveApiConnector {
    @NotNull
    private final String driveInternalUrl;
    @NotNull
    private final RestClient authorizedRestClient;

    public DriveApiConnector(@Value(value="${just.drive.internal}") @NotNull String driveInternalUrl, @NotNull RestClient.Builder restClientBuilder, @NotNull ClientHttpRequestInterceptor authInterceptor) {
        Intrinsics.checkNotNullParameter((Object)driveInternalUrl, (String)"driveInternalUrl");
        Intrinsics.checkNotNullParameter((Object)restClientBuilder, (String)"restClientBuilder");
        Intrinsics.checkNotNullParameter((Object)authInterceptor, (String)"authInterceptor");
        this.driveInternalUrl = driveInternalUrl;
        RestClient restClient = restClientBuilder.baseUrl(this.driveInternalUrl).requestInterceptor(authInterceptor).build();
        Intrinsics.checkNotNullExpressionValue((Object)restClient, (String)"build(...)");
        this.authorizedRestClient = restClient;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<DriveDocument> addFiles(@NotNull List<DocumentId> tempIds, @NotNull DriveFileReferenceId itemId) {
        LinkedHashMap entry;
        Object it;
        Collection<UUID> collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Intrinsics.checkNotNullParameter(tempIds, (String)"tempIds");
        Intrinsics.checkNotNullParameter((Object)itemId, (String)"itemId");
        if (tempIds.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        Object object = new Pair[2];
        object[0] = TuplesKt.to((Object)"targetItemId", (Object)itemId.toTypedString());
        Iterable iterable = tempIds;
        String string = "tempFileIds";
        int n = 1;
        Pair[] pairArray = object;
        Object object2 = (RestClient.RequestBodySpec)this.authorizedRestClient.post().uri(this.driveInternalUrl + "/tmp/move", new Object[0]);
        boolean $i$f$map = false;
        void var8_10 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            DocumentId documentId = (DocumentId)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getValue());
        }
        collection = (List)destination$iv$iv;
        pairArray[n] = TuplesKt.to((Object)string, (Object)collection);
        ResponseEntity responseEntity = object2.body((Object)MapsKt.mapOf((Pair[])object)).retrieve().toEntity(Map.class);
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"toEntity(...)");
        ResponseEntity response = responseEntity;
        Map body = (Map)response.getBody();
        if (response.getStatusCode() != HttpStatus.OK || (object = body) == null || object.isEmpty()) {
            Collection collection2 = tempIds;
            HttpStatusCode httpStatusCode = response.getStatusCode();
            Intrinsics.checkNotNullExpressionValue((Object)httpStatusCode, (String)"getStatusCode(...)");
            throw new DriveApiAddException(collection2, httpStatusCode);
        }
        $this$map$iv = body.values();
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object item$iv$iv;
            it = item$iv$iv = iterator.next();
            object2 = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)entry, (String)"null cannot be cast to non-null type java.util.LinkedHashMap<*, *>");
            object2.add((LinkedHashMap)entry);
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            entry = (LinkedHashMap)item$iv$iv;
            object2 = destination$iv$iv;
            boolean bl = false;
            Object v = ((Map)entry).get("id");
            Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type kotlin.String");
            DocumentId documentId = DocumentId.Companion.fromStringValue((String)v);
            Object v2 = ((Map)entry).get("mimeType");
            Intrinsics.checkNotNull(v2, (String)"null cannot be cast to non-null type kotlin.String");
            String string2 = (String)v2;
            Object v3 = ((Map)entry).get("name");
            Intrinsics.checkNotNull(v3, (String)"null cannot be cast to non-null type kotlin.String");
            String string3 = (String)v3;
            Object v4 = ((Map)entry).get("size");
            Intrinsics.checkNotNull(v4, (String)"null cannot be cast to non-null type kotlin.Int");
            object2.add(new DriveDocument(documentId, string2, string3, ((Integer)v4).intValue()));
        }
        List documents = (List)destination$iv$iv;
        $this$map$iv = tempIds;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Object v10;
            block7: {
                entry = (DocumentId)item$iv$iv;
                object2 = destination$iv$iv;
                boolean bl = false;
                Iterable iterable2 = documents;
                for (Object t : iterable2) {
                    void tempId;
                    DriveDocument doc = (DriveDocument)t;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)doc.getDocumentId(), (Object)tempId)) continue;
                    v10 = t;
                    break block7;
                }
                v10 = null;
            }
            Intrinsics.checkNotNull(v10);
            object2.add(v10);
        }
        return (List)destination$iv$iv;
    }

    public void deleteFile(@NotNull DocumentId documentId, @NotNull ProfileId userId) {
        Intrinsics.checkNotNullParameter((Object)documentId, (String)"documentId");
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        try {
            this.authorizedRestClient.delete().uri(this.driveInternalUrl + "/file/" + documentId.getValue() + "/delete?deletingUser=" + userId.getValue(), new Object[0]).retrieve().toBodilessEntity();
        }
        catch (HttpClientErrorException ex) {
            throw new DriveApiDeleteException(documentId, ex);
        }
    }
}

