/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.justimport.kafka.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Multimap;
import de.justsoftware.justimport.domain.model.common.TenantId;
import de.justsoftware.justimport.domain.model.profile.ProfileId;
import de.justsoftware.justimport.persistence.model.DbScimProfileFieldMapping;
import java.time.Instant;
import java.util.UUID;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public record KafkaFieldMapping(int version, TenantId tenantId, Multimap<String, String> mapping, Instant createdAt, ProfileId createdBy) {
    private final int version;
    private final TenantId tenantId;
    private final Multimap<String, String> mapping;
    private final Instant createdAt;
    private final ProfileId createdBy;

    @JsonCreator
    public KafkaFieldMapping(@JsonProperty(value="version") int version, @JsonProperty(value="tenantId") TenantId tenantId, @JsonProperty(value="mapping") Multimap<String, String> mapping, @JsonProperty(value="createdAt") int createdAt, @JsonProperty(value="createdBy") ProfileId createdBy) {
        this(version, tenantId, mapping, Instant.ofEpochSecond(createdAt), createdBy);
    }

    public KafkaFieldMapping(int version, TenantId tenantId, Multimap<String, String> mapping, Instant createdAt, ProfileId createdBy) {
        this.version = version;
        this.tenantId = tenantId;
        this.mapping = mapping;
        this.createdAt = createdAt;
        this.createdBy = createdBy;
    }

    public DbScimProfileFieldMapping toDbEntity() {
        return new DbScimProfileFieldMapping((UUID)this.tenantId.getId(), this.version, this.mapping, this.createdAt, this.createdBy.getLongId());
    }

    public int version() {
        return this.version;
    }

    public TenantId tenantId() {
        return this.tenantId;
    }

    public Multimap<String, String> mapping() {
        return this.mapping;
    }

    public Instant createdAt() {
        return this.createdAt;
    }

    public ProfileId createdBy() {
        return this.createdBy;
    }
}

