/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.justimport.domain.model.common;

import com.fasterxml.jackson.annotation.JsonCreator;
import de.justsoftware.justimport.domain.model.common.AbstractUUIDBasedId;
import de.justsoftware.justimport.domain.model.common.IdParser;
import de.justsoftware.justimport.domain.model.common.ItemType;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class TenantId
extends AbstractUUIDBasedId {
    public TenantId(UUID id) {
        super(id, ItemType.TENANT);
    }

    @Nonnull
    public static TenantId random() {
        return new TenantId(UUID.randomUUID());
    }

    @JsonCreator
    @Nonnull
    public static TenantId parse(String tenantId) {
        return (TenantId)IdParser.parse((ItemType)ItemType.TENANT, (String)tenantId, s -> new TenantId(UUID.fromString(s)));
    }
}

