/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.justimport.config;

import de.justsoftware.jwtfilter.JwtAuthenticationProcessingFilter;
import jakarta.servlet.Filter;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.config.Customizer;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.authentication.preauth.AbstractPreAuthenticatedProcessingFilter;
import org.springframework.security.web.servlet.util.matcher.PathPatternRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;

@Configuration
@EnableWebSecurity
@ParametersAreNonnullByDefault
public class WebSecurityConfiguration {
    private static final String INTERNAL_API = "/internal/**";
    private final JwtAuthenticationProcessingFilter _jwtAuthenticationProcessingFilter;

    @Autowired
    public WebSecurityConfiguration(JwtAuthenticationProcessingFilter jwtAuthenticationProcessingFilter) {
        this._jwtAuthenticationProcessingFilter = jwtAuthenticationProcessingFilter;
    }

    @Bean
    public SecurityFilterChain securityFilterChain(HttpSecurity http) throws Exception {
        this._jwtAuthenticationProcessingFilter.applyIgnoreFilterMatcher((RequestMatcher)PathPatternRequestMatcher.withDefaults().matcher(INTERNAL_API));
        return (SecurityFilterChain)http.sessionManagement(manager -> manager.sessionCreationPolicy(SessionCreationPolicy.STATELESS)).csrf(AbstractHttpConfigurer::disable).exceptionHandling(Customizer.withDefaults()).anonymous(Customizer.withDefaults()).headers(headers -> headers.cacheControl(Customizer.withDefaults())).authorizeHttpRequests(authManager -> {
            ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)authManager.requestMatchers(new String[]{INTERNAL_API})).permitAll();
            ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)authManager.anyRequest()).fullyAuthenticated();
        }).addFilterAfter((Filter)this._jwtAuthenticationProcessingFilter, AbstractPreAuthenticatedProcessingFilter.class).build();
    }
}

