/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.justimport.config;

import de.justsoftware.jwtfilter.JwtAuthenticationProcessingFilter;
import de.justsoftware.jwtfilter.generator.JwtGenerator;
import de.justsoftware.jwtfilter.generator.JwtGenerators;
import de.justsoftware.jwtfilter.keys.PublicKeyCache;
import de.justsoftware.jwtfilter.verifier.JwtVerifier;
import de.justsoftware.jwtfilter.verifier.JwtVerifiers;
import java.util.Base64;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.core.env.Environment;

@Configuration
@ParametersAreNonnullByDefault
public class JwtConfiguration {
    private final PublicKeyCache _publicKeyCache;

    @Autowired
    public JwtConfiguration(Environment environment) {
        Base64.Decoder decoder = Base64.getDecoder();
        Optional<byte[]> publicKey = Optional.ofNullable(environment.getProperty("just.common.jwt.publicKey")).map(decoder::decode);
        Optional<byte[]> privateKey = Optional.ofNullable(environment.getProperty("just.common.jwt.privateKey")).map(decoder::decode);
        this._publicKeyCache = new PublicKeyCache(() -> privateKey, () -> publicKey);
    }

    @Bean
    @Nonnull
    public JwtAuthenticationProcessingFilter jwtAuthenticationProcessingFilter(JwtVerifier jwtVerifier) {
        return new JwtAuthenticationProcessingFilter(jwtVerifier);
    }

    @Bean
    @Primary
    @Nonnull
    public JwtGenerator createJwtGenerator() {
        return JwtGenerators.createEncryptedJwtGenerator((PublicKeyCache)this._publicKeyCache);
    }

    @Bean
    @Nonnull
    public JwtVerifier createJwtVerifier() {
        return JwtVerifiers.createEncryptedTokenVerifier((PublicKeyCache)this._publicKeyCache);
    }
}

