/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.gateway.kafka;

import com.google.common.collect.Maps;
import de.justsoftware.gateway.security.oauth2.ClientTarget;
import de.justsoftware.gateway.security.oauth2.JustClientRegistrationService;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.kafka.annotation.KafkaListener;
import org.springframework.messaging.handler.annotation.Header;
import org.springframework.messaging.handler.annotation.Payload;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.client.registration.ClientRegistrations;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class ClientRegistrationConsumer {
    public static final String OAUTH_TOPIC = "just.admin.oauth_client_registration";
    private static final String TENANT_ID_KEY = "tenantId";
    private static final Logger LOG = LoggerFactory.getLogger(ClientRegistrationConsumer.class);
    private final JustClientRegistrationService _registrationService;
    private final String _domainPrefix;

    @Autowired
    public ClientRegistrationConsumer(JustClientRegistrationService registrationService, @Value(value="${just.common.system.domainprefix}") String domainPrefix) {
        this._registrationService = registrationService;
        this._domainPrefix = domainPrefix;
    }

    @KafkaListener(topics={"just.admin.oauth_client_registration"}, containerFactory="registrationListenerContainerFactory")
    public void listen(@Header(value="kafka_receivedMessageKey") String clientRegistrationId, @Payload(required=false) @Nullable de.justsoftware.generated.proto.ClientRegistration clientRegistration) {
        if (clientRegistration == null) {
            LOG.info("Deleting clientRegistrationId: {}", (Object)clientRegistrationId);
            this._registrationService.delete(clientRegistrationId).subscribe();
            return;
        }
        LOG.info("Received clientRegistrationId: {}", (Object)clientRegistrationId);
        try {
            this._registrationService.save(this.from(clientRegistration)).subscribe();
        }
        catch (IllegalArgumentException e) {
            LOG.error("Skipping/Removing clientRegistration: {} Reason: {}", (Object)clientRegistrationId, (Object)e.getLocalizedMessage());
            this._registrationService.delete(clientRegistrationId).subscribe();
        }
    }

    private ClientRegistration from(de.justsoftware.generated.proto.ClientRegistration clientRegistration) {
        ClientRegistration.Builder builder = this.getBuilder(clientRegistration);
        builder.registrationId(clientRegistration.getRegistrationId()).clientName(clientRegistration.getClientName()).clientId(clientRegistration.getClientId()).clientSecret(clientRegistration.getClientSecret()).issuerUri(clientRegistration.getIssuerUri()).redirectUri(this._domainPrefix + "/login/oauth2/code/{registrationId}").scope(clientRegistration.getScope().replaceAll("\\s+", "").split(",")).userNameAttributeName(clientRegistration.getUserNameAttribute()).authorizationGrantType(new AuthorizationGrantType(clientRegistration.getAuthorizationGrantType()));
        if (!clientRegistration.getAutomaticMode()) {
            builder.authorizationUri(clientRegistration.getAuthorizationUri()).tokenUri(clientRegistration.getTokenUri()).userInfoUri(clientRegistration.getUserInfoUri()).jwkSetUri(clientRegistration.getJwkSetUri());
        }
        ClientRegistration registration = builder.build();
        HashMap metadata = Maps.newHashMap((Map)registration.getProviderDetails().getConfigurationMetadata());
        metadata.put(TENANT_ID_KEY, clientRegistration.getTenantId());
        metadata.put("targets", clientRegistration.getTargetsList().stream().map(ClientTarget::from).collect(Collectors.toUnmodifiableSet()));
        metadata.put("defaultProvider", clientRegistration.getDefaultProvider());
        return ClientRegistration.withClientRegistration((ClientRegistration)registration).providerConfigurationMetadata((Map)metadata).build();
    }

    private ClientRegistration.Builder getBuilder(de.justsoftware.generated.proto.ClientRegistration clientRegistration) {
        return StringUtils.hasText((String)clientRegistration.getIssuerUri()) ? ClientRegistrations.fromIssuerLocation((String)clientRegistration.getIssuerUri()) : ClientRegistration.withRegistrationId((String)clientRegistration.getRegistrationId());
    }
}

