/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.gateway.config;

import io.micrometer.observation.ObservationPredicate;
import org.springframework.boot.actuate.autoconfigure.tracing.ConditionalOnEnabledTracing;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.observation.ServerRequestObservationContext;

@Configuration
@ConditionalOnEnabledTracing
public class MonitoringConfiguration {
    @Bean
    ObservationPredicate noUiResourceObservations() {
        return (name, context) -> {
            if (name.equals("http.server.requests") && context instanceof ServerRequestObservationContext) {
                ServerRequestObservationContext serverContext = (ServerRequestObservationContext)context;
                String uri = ((ServerHttpRequest)serverContext.getCarrier()).getPath().pathWithinApplication().value();
                return !uri.contains("/monitoring");
            }
            return true;
        };
    }
}

