/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.rest.usergroup.impl;

import com.google.common.collect.ImmutableMap;
import de.justsoftware.drive.business.usergroup.UserGroupService;
import de.justsoftware.drive.common.usergroup.model.UserGroupBO;
import de.justsoftware.drive.common.usergroup.model.UserGroupId;
import de.justsoftware.drive.rest.models.UserGroup;
import de.justsoftware.drive.rest.usergroup.UserGroupFrontendService;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class UserGroupFrontendServiceImpl
implements UserGroupFrontendService {
    private final UserGroupService _userGroupService;

    @Autowired
    public UserGroupFrontendServiceImpl(UserGroupService userGroupService) {
        this._userGroupService = userGroupService;
    }

    public ImmutableMap<UserGroupId, UserGroup> getUserGroupsByIds(Set<UserGroupId> userGroupIds) {
        ImmutableMap result = this._userGroupService.getUserGroupsByIds(userGroupIds);
        return (ImmutableMap)userGroupIds.stream().collect(ImmutableMap.toImmutableMap(Function.identity(), id -> {
            UserGroupBO group = (UserGroupBO)result.get(id);
            if (group == null) {
                return new UserGroup(id, id.toString(), false);
            }
            return UserGroup.from((UserGroupBO)group);
        }));
    }
}

