/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.rest.models;

import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.drive.common.authorization.model.StaticAction;
import de.justsoftware.drive.common.document.model.DocumentId;
import de.justsoftware.drive.common.document.model.DocumentVersionId;
import de.justsoftware.drive.common.file.model.FilePreviewStatus;
import de.justsoftware.drive.common.file.model.VirusScanStatus;
import de.justsoftware.drive.common.util.ObjectUtil;
import de.justsoftware.drive.rest.models.Document;
import de.justsoftware.drive.rest.models.FileLock;
import de.justsoftware.drive.rest.models.Person;
import io.swagger.v3.oas.annotations.media.Schema;
import java.time.Instant;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@Schema(description="A single file")
@ParametersAreNonnullByDefault
@JsonTypeName(value="FILE")
public class File
extends Document {
    private final long _size;
    private final String _extension;
    private final String _mimeType;
    private final String _downloadUrl;
    private final FilePreviewStatus _previewStatus;
    private final FileLock _fileLock;
    private final int _downloads;
    private final String _embedUrl;
    private final String _embedPreviewImageUrl;
    private final VirusScanStatus _virusScanStatus;

    public File(DocumentId id, DocumentVersionId versionId, String name, Person owner, Instant lastModified, long size, String extension, String mimeType, int version, ImmutableSet<StaticAction> allowedActions, String downloadUrl, FilePreviewStatus previewStatus, DocumentId parentFolderId, @Nullable FileLock fileLock, boolean publicLinksAvailable, int downloads, @Nullable String embedUrl, @Nullable String embedPreviewImageUrl, VirusScanStatus virusScanStatus) {
        super(id, versionId, name, owner, lastModified, version, allowedActions, parentFolderId, publicLinksAvailable);
        this._size = size;
        this._extension = extension;
        this._mimeType = mimeType;
        this._downloadUrl = downloadUrl;
        this._previewStatus = previewStatus;
        this._fileLock = fileLock;
        this._downloads = downloads;
        this._embedUrl = embedUrl;
        this._embedPreviewImageUrl = embedPreviewImageUrl;
        this._virusScanStatus = virusScanStatus;
    }

    public long getSize() {
        return this._size;
    }

    @Nonnull
    public String getExtension() {
        return this._extension;
    }

    @Nonnull
    public String getDownloadUrl() {
        return this._downloadUrl;
    }

    @Nonnull
    public FilePreviewStatus getPreviewStatus() {
        return this._previewStatus;
    }

    @Schema(description="the id of the parent folder of the document", required=true)
    @Nonnull
    public DocumentId getParentFolderId() {
        return (DocumentId)ObjectUtil.checkNotNull((Object)super.getParentFolderId());
    }

    @Nonnull
    public String getMimeType() {
        return this._mimeType;
    }

    @CheckForNull
    public FileLock getFileLock() {
        return this._fileLock;
    }

    public int getDownloads() {
        return this._downloads;
    }

    @CheckForNull
    public String getEmbedUrl() {
        return this._embedUrl;
    }

    @CheckForNull
    public String getEmbedPreviewImageUrl() {
        return this._embedPreviewImageUrl;
    }

    public VirusScanStatus getVirusScanStatus() {
        return this._virusScanStatus;
    }
}

