/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.rest.config;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import de.justsoftware.drive.business.document.CycleFoundException;
import de.justsoftware.drive.business.document.IllegalCharDocumentNameBusinessException;
import de.justsoftware.drive.business.document.IllegalDuplicateDocumentNameBusinessException;
import de.justsoftware.drive.business.document.IllegalEmptyDocumentNameBusinessException;
import de.justsoftware.drive.business.document.ItemLockedException;
import de.justsoftware.drive.business.document.NotSameItemException;
import de.justsoftware.drive.business.exception.InvalidMimeTypeException;
import de.justsoftware.drive.business.exception.InvalidShareNameTooLongException;
import de.justsoftware.drive.business.exception.NoPreviewPossibleBusinessException;
import de.justsoftware.drive.business.exception.PermissionDeniedException;
import de.justsoftware.drive.business.exception.ResourceNotYetAvailableBusinessException;
import de.justsoftware.drive.business.exception.ShareAccessDeniedException;
import de.justsoftware.drive.business.exception.UnknownResourceBusinessException;
import de.justsoftware.drive.business.file.VirusFoundException;
import de.justsoftware.drive.business.file.VirusScanFailedException;
import de.justsoftware.drive.business.file.VirusScanNotCompletedException;
import de.justsoftware.drive.business.search.DocumentSearchException;
import de.justsoftware.drive.common.document.model.DocumentId;
import de.justsoftware.drive.filepersistence.common.FilePersistenceConnectionException;
import de.justsoftware.drive.filepersistence.common.FilePersistenceException;
import de.justsoftware.drive.rest.config.DriveExceptionHandler;
import de.justsoftware.drive.rest.exceptions.ApiException;
import java.io.IOException;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.catalina.connector.ClientAbortException;
import org.apache.tomcat.util.http.fileupload.impl.SizeLimitExceededException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.NestedRuntimeException;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MimeType;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.multipart.MultipartException;
import org.springframework.web.servlet.mvc.method.annotation.ResponseEntityExceptionHandler;

/*
 * Exception performing whole class analysis ignored.
 */
@Configuration
@ControllerAdvice
@ParametersAreNonnullByDefault
public class DriveExceptionHandler
extends ResponseEntityExceptionHandler {
    private static final String LOG_MESSAGE = "REST-API call throws exception ({})";
    private static final Random RNG = new Random(System.currentTimeMillis());
    private static final Logger LOG = LoggerFactory.getLogger(DriveExceptionHandler.class);

    @Nonnull
    private static ResponseEntity<Error> handle(ErrorCode errorCode, LogLevel logLevel, Throwable e) {
        return DriveExceptionHandler.handle((Error)new Error(errorCode), (LogLevel)logLevel, (Throwable)e);
    }

    @Nonnull
    private static ResponseEntity<Error> handle(Error error, LogLevel logLevel, Throwable e) {
        logLevel.log(e, Long.valueOf(error.getUid()));
        return ResponseEntity.status((HttpStatusCode)error.getErrorCode().getHttpStatus()).contentType(MediaType.APPLICATION_JSON).body((Object)error);
    }

    @Nonnull
    @ExceptionHandler(value={PermissionDeniedException.class})
    public ResponseEntity<Error> handlePermissionDenied(PermissionDeniedException e) {
        return DriveExceptionHandler.handle((ErrorCode)ErrorCode.PERMISSION_DENIED, (LogLevel)LogLevel.DEBUG, (Throwable)e);
    }

    @Nonnull
    @ExceptionHandler(value={InvalidMimeTypeException.class})
    public ResponseEntity<Error> handleInvalidMimeTypeException(InvalidMimeTypeException e) {
        return DriveExceptionHandler.handle((Error)new Error(ErrorCode.INVALID_MIME_TYPE, Map.of("allowedMimeTypes", e.getAllowedMimeTypes().stream().map(MimeType::toString).collect(Collectors.toSet()), "invalidMimeType", e.getInvalidMimeType().toString())), (LogLevel)LogLevel.INFO, (Throwable)e);
    }

    @Nonnull
    @ExceptionHandler(value={ShareAccessDeniedException.class})
    public ResponseEntity<Error> handleShareAccessDeniedException(ShareAccessDeniedException e) {
        String shareName = e.getShareName();
        DocumentId shareRootFolderId = e.getShareRootFolderId();
        return DriveExceptionHandler.handle((Error)new Error(ErrorCode.PERMISSION_DENIED, (Map)ImmutableMap.of((Object)"requestedDocumentBelongsToShare", (Object)Boolean.TRUE, (Object)"shareName", (Object)Strings.nullToEmpty((String)shareName), (Object)"shareRootFolderId", (Object)shareRootFolderId.toUUIDString())), (LogLevel)LogLevel.DEBUG, (Throwable)e);
    }

    @Nonnull
    @ExceptionHandler(value={InvalidShareNameTooLongException.class})
    public ResponseEntity<Error> handleInvalidShareException(InvalidShareNameTooLongException e) {
        return DriveExceptionHandler.handle((ErrorCode)ErrorCode.INVALID_SHARE_NAME_TOO_LONG, (LogLevel)LogLevel.ERROR, (Throwable)e);
    }

    @Nonnull
    @ExceptionHandler(value={FilePersistenceException.class})
    public ResponseEntity<Error> handleFilePersistence(FilePersistenceException e) {
        return DriveExceptionHandler.handle((ErrorCode)ErrorCode.UNKNOWN, (LogLevel)LogLevel.ERROR, (Throwable)e);
    }

    @Nonnull
    @ExceptionHandler(value={FilePersistenceConnectionException.class})
    public ResponseEntity<Error> handleFilePersistence(FilePersistenceConnectionException e) {
        return DriveExceptionHandler.handle((ErrorCode)ErrorCode.UNKNOWN, (LogLevel)LogLevel.ERROR, (Throwable)e);
    }

    @Nonnull
    @ExceptionHandler(value={DocumentSearchException.class})
    public ResponseEntity<Error> handeDocumentSearchException(DocumentSearchException e) {
        return DriveExceptionHandler.handle((ErrorCode)ErrorCode.UNKNOWN, (LogLevel)LogLevel.ERROR, (Throwable)e);
    }

    @Nonnull
    @ExceptionHandler(value={ApiException.class})
    public ResponseEntity<?> handleApiException(ApiException e) {
        return DriveExceptionHandler.handle((ErrorCode)e.getErrorCode(), (LogLevel)e.getLogLevel(), (Throwable)e);
    }

    @Nonnull
    @ExceptionHandler(value={Exception.class})
    public ResponseEntity<Error> handleRuntimeException(Exception e) throws Exception {
        if (AnnotationUtils.findAnnotation(e.getClass(), ResponseStatus.class) != null) {
            throw e;
        }
        return DriveExceptionHandler.handle((ErrorCode)ErrorCode.UNKNOWN, (LogLevel)LogLevel.ERROR, (Throwable)e);
    }

    @Nonnull
    @ExceptionHandler(value={NestedRuntimeException.class})
    public ResponseEntity<Error> handleDataAccessException(NestedRuntimeException e) {
        return DriveExceptionHandler.handle((ErrorCode)ErrorCode.UNKNOWN, (LogLevel)LogLevel.ERROR, (Throwable)e);
    }

    @Nonnull
    @ExceptionHandler
    public ResponseEntity<Error> handleIllegalEmptyDocumentNameBusinessException(IllegalEmptyDocumentNameBusinessException e) {
        return DriveExceptionHandler.handle((ErrorCode)ErrorCode.INVALID_EMPTY_DOCUMENT_NAME, (LogLevel)LogLevel.DEBUG, (Throwable)e);
    }

    @Nonnull
    @ExceptionHandler
    public ResponseEntity<Error> handleIllegalDuplicateDocumentNameBusinessException(IllegalDuplicateDocumentNameBusinessException e) {
        return DriveExceptionHandler.handle((ErrorCode)ErrorCode.INVALID_DUPLICATE_DOCUMENT_NAME, (LogLevel)LogLevel.DEBUG, (Throwable)e);
    }

    @Nonnull
    @ExceptionHandler
    public ResponseEntity<Error> handleIllegalCharDocumentNameBusinessException(IllegalCharDocumentNameBusinessException e) {
        return DriveExceptionHandler.handle((Error)new Error(ErrorCode.INVALID_CHAR_DOCUMENT_NAME, (Map)ImmutableMap.of((Object)"invalidChar", (Object)String.valueOf(e.getInvalidChar()))), (LogLevel)LogLevel.DEBUG, (Throwable)e);
    }

    @Nonnull
    @ExceptionHandler(value={UnknownResourceBusinessException.class})
    public ResponseEntity<Error> handleUnknownResourceBusinessException(UnknownResourceBusinessException e) {
        return DriveExceptionHandler.handle((ErrorCode)ErrorCode.NOT_FOUND, (LogLevel)LogLevel.DEBUG, (Throwable)e);
    }

    @Nonnull
    @ExceptionHandler(value={MultipartException.class})
    public ResponseEntity<Error> handleUploadSizeLimitExceededException(MultipartException e) {
        Throwable cause;
        if (e.getCause() instanceof IllegalStateException && (cause = e.getCause().getCause()) instanceof SizeLimitExceededException) {
            SizeLimitExceededException sizeEx = (SizeLimitExceededException)cause;
            return DriveExceptionHandler.handle((Error)new Error(ErrorCode.FILE_UPLOAD_MAX_SIZE_EXCEEDED, (Map)ImmutableMap.of((Object)"maxFileSize", (Object)sizeEx.getPermittedSize())), (LogLevel)LogLevel.DEBUG, (Throwable)e);
        }
        return DriveExceptionHandler.handle((ErrorCode)ErrorCode.UNKNOWN, (LogLevel)LogLevel.ERROR, (Throwable)e);
    }

    @Nonnull
    @ExceptionHandler(value={NotSameItemException.class})
    public ResponseEntity<Error> handleNotSameItemException(NotSameItemException e) {
        return DriveExceptionHandler.handle((ErrorCode)ErrorCode.NOT_SAME_ITEM, (LogLevel)LogLevel.DEBUG, (Throwable)e);
    }

    @Nonnull
    @ExceptionHandler(value={CycleFoundException.class})
    public ResponseEntity<Error> handleCycleFoundException(CycleFoundException e) {
        return DriveExceptionHandler.handle((ErrorCode)ErrorCode.CYCLE_FOUND, (LogLevel)LogLevel.DEBUG, (Throwable)e);
    }

    @Nonnull
    @ExceptionHandler(value={ItemLockedException.class})
    public ResponseEntity<Error> handleItemLockedException(ItemLockedException e) {
        return DriveExceptionHandler.handle((ErrorCode)ErrorCode.ITEM_LOCKED, (LogLevel)LogLevel.DEBUG, (Throwable)e);
    }

    @Nonnull
    @ExceptionHandler(value={VirusScanNotCompletedException.class})
    public ResponseEntity<Error> handleVirusScanNotCompletedException(VirusScanNotCompletedException e) {
        return DriveExceptionHandler.handle((ErrorCode)ErrorCode.VIRUS_SCAN_RUNNING, (LogLevel)LogLevel.DEBUG, (Throwable)e);
    }

    @Nonnull
    @ExceptionHandler(value={VirusFoundException.class})
    public ResponseEntity<Error> handleVirusFoundException(VirusFoundException e) {
        return DriveExceptionHandler.handle((ErrorCode)ErrorCode.VIRUS_FOUND, (LogLevel)LogLevel.DEBUG, (Throwable)e);
    }

    @Nonnull
    @ExceptionHandler(value={VirusScanFailedException.class})
    public ResponseEntity<Error> handleVirusScanFailedException(VirusScanFailedException e) {
        return DriveExceptionHandler.handle((ErrorCode)ErrorCode.VIRUS_SCAN_FAILED, (LogLevel)LogLevel.ERROR, (Throwable)e);
    }

    @Nonnull
    @ExceptionHandler(value={IllegalArgumentException.class})
    public ResponseEntity<Error> handleIllegalArgumentException(IllegalArgumentException e) {
        return DriveExceptionHandler.handle((ErrorCode)ErrorCode.BAD_REQUEST, (LogLevel)LogLevel.DEBUG, (Throwable)e);
    }

    @Nonnull
    @ExceptionHandler(value={NoPreviewPossibleBusinessException.class})
    public ResponseEntity<Error> handleNoPreviewPossibleBusinessException(NoPreviewPossibleBusinessException e) {
        return DriveExceptionHandler.handle((ErrorCode)ErrorCode.NOT_IMPLEMENTED, (LogLevel)LogLevel.DEBUG, (Throwable)e);
    }

    @Nonnull
    @ExceptionHandler(value={ResourceNotYetAvailableBusinessException.class})
    public ResponseEntity<Error> handleResourceNotYetAvailableException(ResourceNotYetAvailableBusinessException e) {
        Error error = new Error(ErrorCode.SERVICE_UNAVAILABLE);
        LogLevel.DEBUG.log((Throwable)e, Long.valueOf(error.getUid()));
        return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatusCode)error.getErrorCode().getHttpStatus()).header("Retry-After", new String[]{Integer.toString(e.getRetryAfter())})).body((Object)error);
    }

    @CheckForNull
    @ExceptionHandler(value={IOException.class})
    public ResponseEntity<Error> handleClientAbortException(IOException e) {
        if (e.getClass().equals(ClientAbortException.class)) {
            LOG.debug("Client closed the connection unexpectedly. This might happen during media streaming.", (Throwable)e);
            return null;
        }
        Error error = new Error(ErrorCode.BAD_REQUEST);
        LogLevel.ERROR.log((Throwable)e, Long.valueOf(error.getUid()));
        return ResponseEntity.badRequest().contentType(MediaType.APPLICATION_JSON).body((Object)error);
    }
}

