/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.persistence.usergroup;

import com.google.common.collect.ImmutableMap;
import de.justsoftware.drive.common.tenant.model.TenantId;
import de.justsoftware.drive.common.usergroup.model.UserGroupBO;
import de.justsoftware.drive.common.usergroup.model.UserGroupId;
import de.justsoftware.drive.mybatis.DAOSupport;
import de.justsoftware.drive.persistence.usergroup.UserGroupCreateModel;
import de.justsoftware.drive.persistence.usergroup.UserGroupDAO;
import de.justsoftware.drive.persistence.usergroup.UserGroupMapper;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@ParametersAreNonnullByDefault
@Repository
public class UserGroupDAOImpl
implements UserGroupDAO {
    private final DAOSupport _daoSupport;
    private final UserGroupMapper _userGroupMapper;

    @Autowired
    public UserGroupDAOImpl(DAOSupport daoSupport, UserGroupMapper userGroupMapper) {
        this._daoSupport = daoSupport;
        this._userGroupMapper = userGroupMapper;
    }

    public void deleteGroup(UserGroupId userGroupId) {
        this._userGroupMapper.deleteGroup(userGroupId);
    }

    @Transactional
    public void insertOrUpdate(UserGroupCreateModel userGroupCreateModel) {
        this._userGroupMapper.insertUserGroup(userGroupCreateModel);
        this._userGroupMapper.updateUserGroup(userGroupCreateModel);
    }

    public ImmutableMap<UserGroupId, UserGroupBO> getUserGroupsByIds(Set<UserGroupId> userGroupIds) {
        return (ImmutableMap)this._daoSupport.partition(userGroupIds).index(UserGroupBO::getId).asMap().query((arg_0, arg_1) -> ((UserGroupMapper)this._userGroupMapper).getUserGroups(arg_0, arg_1));
    }

    public UserGroupId getAllUsersGroupId(TenantId tenantId) {
        return this._userGroupMapper.getAllUsersGroupId(tenantId);
    }
}

