/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.persistence.folder;

import de.justsoftware.drive.common.document.model.DocumentId;
import de.justsoftware.drive.common.document.model.DocumentVersionId;
import de.justsoftware.drive.common.item.model.ItemId;
import java.util.List;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.Insert;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Result;
import org.apache.ibatis.annotations.ResultType;
import org.apache.ibatis.annotations.Results;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.Update;
import org.apache.ibatis.session.ResultHandler;

@ParametersAreNonnullByDefault
@Mapper
public interface SubFolderMapper {
    @Select(value={"<script>", "SELECT * FROM sub_folder", "WHERE parent_id IN (<foreach collection='ids' item='i' separator=','>#{i}</foreach>)", "</script>"})
    @Results(value={@Result(column="parent_id", property="key", javaType=DocumentVersionId.class), @Result(column="child_id", property="value", javaType=DocumentVersionId.class)})
    @ResultType(value=Map.class)
    public void getSubFoldersByIds(ResultHandler<Map<String, Object>> var1, @Param(value="ids") List<DocumentVersionId> var2);

    @Insert(value={"INSERT INTO sub_folder(parent_id, child_id)", "VALUES (#{parent}, #{child})"})
    public void insertFolderSubFolders(@Param(value="parent") DocumentVersionId var1, @Param(value="child") DocumentVersionId var2);

    @Select(value={"<script>", "SELECT child_id, parent_id FROM (", "   SELECT s.child_id, s.parent_id,", "   RANK() OVER (PARTITION BY s.child_id ORDER BY c.version DESC) AS rank", "   FROM sub_folder s JOIN document_version v ON s.parent_id = v.id JOIN change c ON v.change_id = c.folder_version_id", "   WHERE s.child_id IN (<foreach collection='ids' item='i' separator=','>#{i}</foreach>)", ") ranked WHERE RANK = 1", "</script>"})
    @Results(value={@Result(column="child_id", property="key", javaType=DocumentVersionId.class), @Result(column="parent_id", property="value", javaType=DocumentVersionId.class)})
    @ResultType(value=Map.class)
    public void getCurrentParentsOfDocumentVersions(ResultHandler<Map<String, Object>> var1, @Param(value="ids") List<DocumentVersionId> var2);

    @Delete(value={"<script>", "DELETE FROM sub_folder", "WHERE child_id IN (<foreach collection='ids' item='i' separator=','>#{i}</foreach>)", "</script>"})
    public void deleteByChildIds(@Param(value="ids") List<DocumentVersionId> var1);

    @Delete(value={"<script>", "DELETE FROM sub_folder", "WHERE EXISTS (SELECT 1 FROM document_version", "    WHERE id = sub_folder.parent_id", "    AND change_id IN (<foreach collection='ids' item='i' separator=','>#{i}</foreach>)", ")", "</script>"})
    public void deleteByParentIntroducedInChange(@Param(value="ids") List<DocumentVersionId> var1);

    @Select(value={"<script>", "WITH <if test=\"_databaseId == 'POSTGRES'\">RECURSIVE</if>", "all_children (child_id) AS (", "SELECT child_id", "FROM sub_folder", "WHERE parent_id = #{id}", "UNION ALL", "SELECT sf.child_id", "FROM sub_folder sf", "JOIN all_children ac ON sf.parent_id = ac.child_id", "WHERE parent_id = ac.child_id)", "SELECT d.id as document_id, child_id ", "FROM all_children", "JOIN document d ON d.last_version_id = child_id", "</script>"})
    @Results(value={@Result(column="document_id", property="key", javaType=DocumentId.class), @Result(column="child_id", property="value", javaType=DocumentVersionId.class)})
    @ResultType(value=Map.class)
    public void getAllChildrenRecursive(ResultHandler<Map<String, Object>> var1, DocumentVersionId var2);

    @Insert(value={"INSERT INTO sub_folder", "(parent_id, child_id)", "SELECT change_id as parent_id, id as child_id", "   FROM document_version", "   WHERE change_id = #{changeId}", "   AND change_id != id"})
    public void insertParentRelationshipForDocumentsInChange(DocumentVersionId var1);

    @Update(value={"UPDATE sub_folder", "SET parent_id = #{targetChange}", "WHERE parent_id = #{currentChange}"})
    public void updateParentRelationshipForChange(@Param(value="currentChange") DocumentVersionId var1, @Param(value="targetChange") DocumentVersionId var2);

    @Delete(value={"DELETE FROM sub_folder WHERE child_id IN (SELECT id FROM document_version dv JOIN change c on c.folder_version_id = dv.change_id WHERE c.item_id = #{itemId}) OR parent_id IN (SELECT id FROM document_version dv JOIN change c on c.folder_version_id = dv.change_id WHERE c.item_id = #{itemId}) "})
    public void deleteAllForItem(ItemId var1);
}

