/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.persistence.file;

import com.google.common.collect.ImmutableMap;
import de.justsoftware.drive.common.document.model.DocumentVersionId;
import de.justsoftware.drive.common.file.model.FilePreviewInfoBO;
import de.justsoftware.drive.common.file.model.PreviewId;
import de.justsoftware.drive.common.file.model.StorageId;
import de.justsoftware.drive.mybatis.DAOSupport;
import de.justsoftware.drive.persistence.file.FileVersionPreviewCreateModel;
import de.justsoftware.drive.persistence.file.FileVersionPreviewDAO;
import de.justsoftware.drive.persistence.file.FileVersionPreviewMapper;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.ibatis.cursor.Cursor;
import org.apache.ibatis.session.RowBounds;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@ParametersAreNonnullByDefault
@Repository
public class FileVersionPreviewDAOImpl
implements FileVersionPreviewDAO {
    private final FileVersionPreviewMapper _previewMapper;
    private final DAOSupport _daoSupport;

    @Autowired
    public FileVersionPreviewDAOImpl(FileVersionPreviewMapper previewMapper, DAOSupport daoSupport) {
        this._previewMapper = previewMapper;
        this._daoSupport = daoSupport;
    }

    public void create(FileVersionPreviewCreateModel createModel) {
        this._previewMapper.insertFileVersionPreview(createModel);
    }

    public List<DocumentVersionId> getNextQueueEntries(int limit) {
        return this._previewMapper.getVersionsWithoutPreview(new RowBounds(0, limit));
    }

    public void update(FileVersionPreviewCreateModel createModel) {
        this._previewMapper.updatePreviewStatus(createModel);
    }

    public ImmutableMap<StorageId, FilePreviewInfoBO> getPreviewInfos(Set<StorageId> storageIds) {
        return (ImmutableMap)this._daoSupport.partition(storageIds).index(FilePreviewInfoBO::getId).asMap().query((arg_0, arg_1) -> ((FileVersionPreviewMapper)this._previewMapper).getInfoByStorageIds(arg_0, arg_1));
    }

    public ImmutableMap<PreviewId, FilePreviewInfoBO> getPreviewInfosByPreviewId(Set<PreviewId> previewIds) {
        return (ImmutableMap)this._daoSupport.partition(previewIds).index(FilePreviewInfoBO::getPreviewId).asMap().query((arg_0, arg_1) -> ((FileVersionPreviewMapper)this._previewMapper).getInfoByPreviewIds(arg_0, arg_1));
    }

    @Nonnull
    public ImmutableMap<DocumentVersionId, PreviewId> getPreviewIdByFileVersionId(Set<DocumentVersionId> fileVersions) {
        return this._daoSupport.partition(fileVersions).asMap((arg_0, arg_1) -> ((FileVersionPreviewMapper)this._previewMapper).getPreviewIdByFileVersionId(arg_0, arg_1));
    }

    public void deletePreviews(Set<StorageId> storageIds) {
        this._daoSupport.partition(storageIds).noResult(arg_0 -> ((FileVersionPreviewMapper)this._previewMapper).deleteByStorageId(arg_0));
    }

    public void deleteAllPreviewOrphansWithoutVersions() {
        this._previewMapper.deleteAllPreviewsWithoutVersions();
    }

    @Transactional(propagation=Propagation.MANDATORY)
    @Nonnull
    public Cursor<PreviewId> streamOutdatedVersionPreviewIds() {
        return this._previewMapper.streamOutdatedVersionPreviewIds();
    }

    public void markAsDeleted(PreviewId previewId) {
        this._previewMapper.markAsDeleted(previewId);
    }
}

