/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.persistence.file;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.drive.common.document.model.DocumentId;
import de.justsoftware.drive.common.document.model.DocumentVersionBO;
import de.justsoftware.drive.common.document.model.DocumentVersionId;
import de.justsoftware.drive.common.document.model.VideoTeaserId;
import de.justsoftware.drive.common.file.model.FileVersionBO;
import de.justsoftware.drive.common.file.model.StorageId;
import de.justsoftware.drive.common.file.model.VirusScanStatus;
import de.justsoftware.drive.common.item.model.ItemId;
import de.justsoftware.drive.common.tenant.model.TenantId;
import de.justsoftware.drive.mybatis.DAOSupport;
import de.justsoftware.drive.persistence.document.DocumentVersionCreateModel;
import de.justsoftware.drive.persistence.document.DocumentVersionMapper;
import de.justsoftware.drive.persistence.file.FileVersionCreateModel;
import de.justsoftware.drive.persistence.file.FileVersionDAO;
import de.justsoftware.drive.persistence.file.FileVersionMapper;
import de.justsoftware.drive.rest.mapping.VirusScanResultIssueDto;
import io.micrometer.observation.annotation.Observed;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.ibatis.session.RowBounds;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
@ParametersAreNonnullByDefault
@Observed
public class FileVersionDAOImpl
implements FileVersionDAO {
    private final DocumentVersionMapper _documentVersionMapper;
    private final FileVersionMapper _fileVersionMapper;
    private final DAOSupport _daoSupport;

    @Autowired
    public FileVersionDAOImpl(FileVersionMapper fileVersionMapper, DocumentVersionMapper documentVersionMapper, DAOSupport daoSupport) {
        this._fileVersionMapper = fileVersionMapper;
        this._documentVersionMapper = documentVersionMapper;
        this._daoSupport = daoSupport;
    }

    public FileVersionCreateModel fileVersionCreateModel() {
        return new FileVersionCreateModel();
    }

    public FileVersionCreateModel fileVersionCreateModel(DocumentVersionId id) {
        return new FileVersionCreateModel(id);
    }

    public void insertFileVersions(Iterable<FileVersionCreateModel> models) {
        for (FileVersionCreateModel model : models) {
            this._documentVersionMapper.insertDocumentVersion((DocumentVersionCreateModel)model);
            this._fileVersionMapper.insertFileVersion(model);
        }
    }

    public ImmutableMap<DocumentVersionId, FileVersionBO> getByIds(Set<DocumentVersionId> fileVersionIds) {
        return (ImmutableMap)this._daoSupport.partition(fileVersionIds).index(DocumentVersionBO::getId).asMap().query((arg_0, arg_1) -> ((FileVersionMapper)this._fileVersionMapper).getVersionsByIds(arg_0, arg_1));
    }

    public ImmutableListMultimap<DocumentVersionId, FileVersionBO> getFileVersionsByChangeIds(Set<DocumentVersionId> changeIds) {
        return (ImmutableListMultimap)this._daoSupport.partition(changeIds).index(DocumentVersionBO::getChangeId).asListMultimap().query((arg_0, arg_1) -> ((FileVersionMapper)this._fileVersionMapper).getFileVersionsByChangeIds(arg_0, arg_1));
    }

    public ImmutableListMultimap<DocumentId, FileVersionBO> getVersionsByDocumentIds(Set<DocumentId> fileIds) {
        return (ImmutableListMultimap)this._daoSupport.partition(fileIds).index((Function)DocumentVersionBO.GET_DOCUMENT_ID).asListMultimap().query((resultHandler, ids) -> this._fileVersionMapper.getVersionsByDocumentIds(resultHandler, ids));
    }

    public ImmutableList<FileVersionBO> getLatestVersions(DocumentId id, int limit) {
        RowBounds rowBounds = limit < 0 ? RowBounds.DEFAULT : new RowBounds(0, limit);
        return ImmutableList.copyOf((Collection)this._fileVersionMapper.getLastVersionsByDocumentId(id, rowBounds));
    }

    public void deleteFileVersions(Set<DocumentVersionId> fileVersionIds) {
        this._daoSupport.partition(fileVersionIds).noResult(ids -> {
            this._fileVersionMapper.deleteByIds(ids);
            this._documentVersionMapper.deleteByIds(ids);
        });
    }

    public Set<StorageId> getReferencedStorageIds(Set<StorageId> storageId) {
        return ImmutableSet.copyOf((Collection)this._daoSupport.partition(storageId).asSet((arg_0, arg_1) -> ((FileVersionMapper)this._fileVersionMapper).isStorageIdReferenced(arg_0, arg_1)));
    }

    @Nonnull
    public List<FileVersionBO> getAllVersionsForItem(ItemId id) {
        return this._fileVersionMapper.getAllVersionsForItem(id);
    }

    @Nonnull
    public List<FileVersionBO> getFileVersionsByStorageId(StorageId id) {
        return this._fileVersionMapper.getFileVersionsByStorageId(id);
    }

    public void deleteAllFromItem(ItemId itemId) {
        this._fileVersionMapper.deleteAllForItem(itemId);
    }

    public Set<StorageId> getExclusiveStorageIdsForItem(ItemId itemId) {
        return this._fileVersionMapper.getExclusiveStorageIdsForItem(itemId);
    }

    public void setVideoTeaser(DocumentVersionId videoItemId, VideoTeaserId videoTeaserId) {
        this._fileVersionMapper.setVideoTeaser(videoItemId, videoTeaserId);
    }

    public void deleteVideoTeaser(DocumentVersionId videoItemId) {
        this._fileVersionMapper.deleteVideoTeaser(videoItemId);
    }

    public List<VirusScanResultIssueDto> findLatestFileVersionsWithVirusScanIssues(TenantId tenantId) {
        List fileVersions = this._fileVersionMapper.findLatestFileVersionsWithVirusScanIssues(tenantId, VirusScanStatus.getStatusesWithIssue());
        if (fileVersions == null) {
            return List.of();
        }
        return fileVersions;
    }
}

