/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.persistence.document;

import de.justsoftware.drive.common.document.model.DocumentBO;
import de.justsoftware.drive.common.document.model.DocumentId;
import de.justsoftware.drive.common.document.model.DocumentVersionId;
import de.justsoftware.drive.common.item.model.ItemId;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.ibatis.annotations.Arg;
import org.apache.ibatis.annotations.ConstructorArgs;
import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.Insert;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Result;
import org.apache.ibatis.annotations.ResultType;
import org.apache.ibatis.annotations.Results;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.Update;
import org.apache.ibatis.cursor.Cursor;
import org.apache.ibatis.session.ResultHandler;

@ParametersAreNonnullByDefault
@Mapper
public interface DocumentMapper {
    @Update(value={"<script>", "UPDATE document d", "SET last_version_id = (", "    SELECT r.id", "    FROM (", "        SELECT v.id,", "        RANK() OVER (PARTITION BY document_id ORDER BY version DESC) AS rank", "        FROM document_version v", "        WHERE v.document_id = d.id", "    ) r", "    WHERE r.rank = 1", ")", "WHERE id IN (<foreach collection='ids' item='i' separator=','>#{i}</foreach>)", "</script>"})
    public void updateLastVersions(@Param(value="ids") List<DocumentId> var1);

    @Update(value={"UPDATE document d", "SET last_version_id = (", "    SELECT r.id", "    FROM (", "        SELECT v.id,", "        RANK() OVER (PARTITION BY document_id ORDER BY version DESC) AS rank", "        FROM document_version v", "        WHERE v.document_id = d.id", "    ) r", "    WHERE r.rank = 1", ")", "WHERE last_version_id IS NULL"})
    public void repairMissingLastVersionLink();

    @Select(value={"<script>", "SELECT id, last_version_id", "FROM document", "WHERE id IN (<foreach collection='ids' item='i' separator=','>#{i}</foreach>)", "AND last_version_id IS NOT NULL", "</script>"})
    @Results(value={@Result(column="id", property="key", javaType=DocumentId.class), @Result(column="last_version_id", property="value", javaType=DocumentVersionId.class)})
    @ResultType(value=Map.class)
    public void getLastVersions(ResultHandler<Map<String, Object>> var1, @Param(value="ids") List<DocumentId> var2);

    @Insert(value={"INSERT INTO document(id)", "VALUES (#{id})"})
    public void createNewDocument(@Param(value="id") DocumentId var1);

    @Update(value={"<script>", "UPDATE document", "SET last_version_id = NULL", "WHERE id IN (<foreach collection='ids' item='i' separator=','>#{i}</foreach>)", "</script>"})
    public void prepareDelete(@Param(value="ids") List<DocumentId> var1);

    @Update(value={"UPDATE document", "SET last_version_id = NULL", "WHERE id IN (", "   SELECT v.document_id", "   FROM change c", "   JOIN document_version v ON c.folder_version_id = v.change_id", "   WHERE c.item_id = #{itemId}", ")"})
    public void prepareDeleteItem(ItemId var1);

    @Delete(value={"<script>", "DELETE FROM document", "WHERE id IN (<foreach collection='ids' item='i' separator=','>#{i}</foreach>)", "</script>"})
    public void deleteFinally(@Param(value="ids") List<DocumentId> var1);

    @Select(value={"<script>", "SELECT d.id, v.version", "FROM document d", "JOIN document_version v ON d.last_version_id = v.id", "WHERE d.id IN (<foreach collection='ids' item='i' separator=','>#{i}</foreach>)", "</script>"})
    @Results(value={@Result(column="id", property="key", javaType=DocumentId.class), @Result(column="version", property="value", javaType=Integer.class)})
    @ResultType(value=Map.class)
    public void getLastVersionNumbers(ResultHandler<Map<String, Object>> var1, @Param(value="ids") List<DocumentId> var2);

    @Update(value={"<script>", "UPDATE document", "<set>", "   <if test=\"desc != null\">description = #{desc},</if>", "   <if test=\"tags != null\">tags = #{tags},</if>", "</set>", "WHERE id = #{id}", "</script>"})
    public void updateDescription(@Param(value="id") DocumentId var1, @Nullable @Param(value="desc") String var2, @Nullable @Param(value="tags") String var3);

    @Select(value={"<script>", "SELECT id, description, tags", "FROM document", "WHERE id IN (<foreach collection='ids' item='i' separator=','>#{i}</foreach>)", "</script>"})
    @ConstructorArgs(value={@Arg(column="id", id=true, javaType=DocumentId.class), @Arg(column="description", javaType=String.class), @Arg(column="tags", javaType=String.class)})
    @ResultType(value=DocumentBO.class)
    public void getDocumentsById(ResultHandler<DocumentBO> var1, @Param(value="ids") List<DocumentId> var2);

    @Select(value={"<script>", "SELECT c.item_id, v.document_id", "FROM change c", "JOIN document_version v ON c.folder_version_id = v.change_id", "WHERE c.item_id IN (<foreach collection='itemIds' item='i' separator=','>#{i}</foreach>)", "GROUP BY c.item_id, v.document_id", "</script>"})
    @Results(value={@Result(column="item_id", property="key", javaType=ItemId.class), @Result(column="document_id", property="value", javaType=DocumentId.class)})
    @ResultType(value=Map.class)
    public void getDocumentIdsPerItems(ResultHandler<Map<String, Object>> var1, @Param(value="itemIds") List<ItemId> var2);

    @Delete(value={"<script>", "UPDATE document", "SET last_version_id = null", "WHERE last_version_id IN (SELECT id FROM document_version", "    WHERE change_id IN (<foreach collection='ids' item='i' separator=','>#{i}</foreach>", "))", "</script>"})
    public void unlinkLastVersionUpdatedByChanges(@Param(value="ids") List<DocumentVersionId> var1);

    @Delete(value={"DELETE FROM document d", "WHERE NOT EXISTS (", "    SELECT 1 FROM document_version dv WHERE dv.document_id = d.id", ")"})
    public void deleteAllWithoutVersion();

    @Select(value={"SELECT d.id FROM document d JOIN document_version dv ON dv.id=d.last_version_id JOIN change c ON c.folder_version_id=dv.change_id WHERE NOT EXISTS ( SELECT i.id from item i where i.id = c.item_id AND (i.deleted='t' OR i.id LIKE 'CHAT,%' or id LIKE 'ENTITY,%' or id LIKE 'WORKSTREAM_MESSAGE,%' or id LIKE 'WIKI%')) ORDER BY d.ctime DESC"})
    public Cursor<DocumentId> streamAllSearchableDocumentIds();
}

