/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.persistence.change;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.drive.common.change.model.ChangeBO;
import de.justsoftware.drive.common.document.model.DocumentVersionId;
import de.justsoftware.drive.common.item.model.ItemId;
import de.justsoftware.drive.common.person.model.PersonId;
import de.justsoftware.drive.mybatis.DAOSupport;
import de.justsoftware.drive.persistence.change.ChangeCreateModel;
import de.justsoftware.drive.persistence.change.ChangeDAO;
import de.justsoftware.drive.persistence.change.ChangeMapper;
import io.micrometer.observation.annotation.Observed;
import java.util.Collection;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
@ParametersAreNonnullByDefault
@Observed
public class ChangeDAOImpl
implements ChangeDAO {
    private final DAOSupport _daoSupport;
    private final ChangeMapper _changeMapper;

    @Autowired
    public ChangeDAOImpl(DAOSupport daoSupport, ChangeMapper changeMapper) {
        this._daoSupport = daoSupport;
        this._changeMapper = changeMapper;
    }

    public ChangeCreateModel changeCreateModel() {
        return new ChangeCreateModel();
    }

    public void insertChanges(Iterable<ChangeCreateModel> changes) {
        changes.forEach(arg_0 -> ((ChangeMapper)this._changeMapper).insertChange(arg_0));
    }

    public ImmutableMap<ItemId, ChangeBO> getNewestChangePerItem(Set<? extends ItemId> items) {
        return this.getNthChangePerItem(items, 1);
    }

    public ImmutableMap<ItemId, ChangeBO> getInitialChangePerItem(Set<? extends ItemId> items) {
        return this.getNthChangePerItem(items, -1);
    }

    @Nonnull
    private ImmutableMap<ItemId, ChangeBO> getNthChangePerItem(Set<? extends ItemId> items, int nth) {
        if (nth == 0) {
            throw new IllegalArgumentException("nth 0 not supported");
        }
        boolean initialChangeFirst = nth < 0;
        return (ImmutableMap)this._daoSupport.partition(items).index((Function)ChangeBO.GET_ITEM_ID).asMap().query((resultHandler, ids) -> this._changeMapper.getNthChange(resultHandler, ids, Math.abs(nth), initialChangeFirst));
    }

    public ImmutableMap<DocumentVersionId, ChangeBO> getChangesByIds(Set<DocumentVersionId> folderVersionIds) {
        return (ImmutableMap)this._daoSupport.partition(folderVersionIds).index(ChangeBO::getId).asMap().query((arg_0, arg_1) -> ((ChangeMapper)this._changeMapper).getChangesByIds(arg_0, arg_1));
    }

    public void forAllChanges(ChangeDAO.ChangeHandler changeHandler) {
        this._changeMapper.getAllChanges(resultContext -> changeHandler.handleChange((ChangeBO)resultContext.getResultObject()));
    }

    public ImmutableMap<ItemId, PersonId> loadAuthorOfFirstChange(Set<ItemId> itemIds) {
        return this._daoSupport.partition(itemIds).asMap((arg_0, arg_1) -> ((ChangeMapper)this._changeMapper).loadAuthorsOfFirstChange(arg_0, arg_1));
    }

    public ImmutableSet<DocumentVersionId> getIntermediateChanges(DocumentVersionId start, DocumentVersionId end) {
        return ImmutableSet.copyOf((Collection)this._changeMapper.getIntermediateChanges(start, end));
    }

    public void deleteChanges(Set<DocumentVersionId> changeIds) {
        this._daoSupport.partition(changeIds).noResult(arg_0 -> ((ChangeMapper)this._changeMapper).deleteChanges(arg_0));
    }

    public void deleteAllChangesForItem(ItemId itemId) {
        this._changeMapper.deleteChangesForItem(itemId);
    }

    public ImmutableList<ChangeBO> getAllChangesForItem(ItemId item) {
        return ImmutableList.copyOf((Collection)this._changeMapper.getAllChangesForItem(item));
    }

    public ImmutableSet<ItemId> getAllItemIds() {
        return ImmutableSet.copyOf((Collection)this._changeMapper.getAllItemIds());
    }

    public ImmutableList<ChangeBO> loadPublicChangesAfter(Set<DocumentVersionId> changes) {
        return this._daoSupport.partition(changes).asList((arg_0, arg_1) -> ((ChangeMapper)this._changeMapper).loadPublicChangesAfter(arg_0, arg_1));
    }

    public boolean existsChangeByItemId(ItemId itemId) {
        return this._changeMapper.existsChangeByItemId(itemId);
    }
}

