/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.business.thumbor.impl;

import de.justsoftware.drive.business.thumbor.ThumborHealthCheck;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;
import org.springframework.web.client.ResourceAccessException;
import org.springframework.web.client.RestOperations;

@ParametersAreNonnullByDefault
@Service
public class ThumborHealthCheckImpl
implements ThumborHealthCheck {
    private static final Logger LOG = LoggerFactory.getLogger(ThumborHealthCheckImpl.class);
    private static final int FIVE_SECONDS_IN_MS = 5000;
    private final RestOperations _restOperations;
    private final String _thumborHealthUrl;
    private volatile boolean _thumborIsAvailable = true;

    @Autowired
    public ThumborHealthCheckImpl(RestOperations restOperations, @Value(value="${just-thumbor.host:localhost}") String thumborHostname, @Value(value="${just-thumbor.port:8888}") int thumborPort) {
        this._restOperations = restOperations;
        this._thumborHealthUrl = String.format("http://%s:%s/healthcheck", thumborHostname, thumborPort);
    }

    @Scheduled(initialDelay=0L, fixedRate=5000L)
    public void scheduledHealthCheck() {
        this._thumborIsAvailable = this.checkHealth();
    }

    private boolean checkHealth() {
        try {
            ResponseEntity response = this._restOperations.getForEntity(this._thumborHealthUrl, String.class, new Object[0]);
            HttpStatusCode statusCode = response.getStatusCode();
            if (statusCode != HttpStatus.OK) {
                if (this._thumborIsAvailable) {
                    LOG.warn("Health check request returned status: {} message: ({})", (Object)statusCode.value(), response.getBody());
                }
                return false;
            }
            String result = (String)response.getBody();
            if (!"WORKING".equals(result)) {
                if (this._thumborIsAvailable) {
                    LOG.warn("Unexpected response body of health check response: {}", (Object)result);
                }
                return false;
            }
            if (!this._thumborIsAvailable) {
                LOG.info("Status of Thumbor service is back to normal.");
            }
            return true;
        }
        catch (ResourceAccessException e) {
            if (this._thumborIsAvailable) {
                LOG.warn("Health check for Thumbor service failed: {}", (Object)e.getMessage());
            }
            return false;
        }
        catch (RuntimeException e) {
            LOG.error("Error checking health for Thumbor service.", (Throwable)e);
            return false;
        }
    }

    public boolean isAvailable() {
        return this._thumborIsAvailable;
    }
}

