/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.business.shares;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.drive.business.authorization.AuthorizationContext;
import de.justsoftware.drive.common.accessrequest.model.AccessRequestBO;
import de.justsoftware.drive.common.authorization.model.SharePrivilege;
import de.justsoftware.drive.common.document.model.DocumentId;
import de.justsoftware.drive.common.folder.model.FolderVersionBO;
import de.justsoftware.drive.common.item.model.ItemBO;
import de.justsoftware.drive.common.item.model.ItemId;
import de.justsoftware.drive.common.person.model.PersonId;
import de.justsoftware.drive.common.shares.model.ShareBO;
import de.justsoftware.drive.common.tenant.model.TenantId;
import de.justsoftware.permission.client.model.Role;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public interface SharesService {
    @Nonnull
    public ItemId createShare(AuthorizationContext var1, PersonId var2, String var3, Map<Role, SharePrivilege> var4);

    @Nonnull
    public ImmutableList<ItemBO> getShares(AuthorizationContext var1);

    @Nonnull
    public ImmutableMap<ItemId, DocumentId> getRootFolderIds(Set<ItemId> var1);

    @Nullable
    default public DocumentId getRootFolderId(ItemId itemId) {
        return (DocumentId)this.getRootFolderIds((Set)ImmutableSet.of((Object)itemId)).get((Object)itemId);
    }

    @Nonnull
    public ImmutableMap<ItemId, FolderVersionBO> getRootFolderVersions(Set<ItemId> var1);

    public void editShare(AuthorizationContext var1, ItemId var2, PersonId var3, String var4, Map<Role, SharePrivilege> var5, Map<Role, SharePrivilege> var6, Set<Role> var7);

    @Nonnull
    public ShareBO getShareDetails(ItemId var1, AuthorizationContext var2);

    @Nonnull
    public ItemBO getShare(ItemId var1, AuthorizationContext var2);

    @Nonnull
    public ShareBO getShareDetails(ItemId var1);

    public void deleteShare(ItemId var1);

    public void deleteAllShares(TenantId var1);

    public void requestAccess(PersonId var1, TenantId var2, DocumentId var3);

    @Nonnull
    public ImmutableSet<AccessRequestBO> getPendingAccessRequestsForShare(ItemId var1, AuthorizationContext var2);

    public void rejectAccessRequests(Set<Role> var1, ItemId var2, AuthorizationContext var3);

    public void removeMemberships(Set<Role> var1);

    public boolean isSubscribed(ItemId var1, AuthorizationContext var2);

    @Nonnull
    public ImmutableSet<ItemBO> getSubscribedShares(AuthorizationContext var1);

    public void subscribeShare(ItemId var1, PersonId var2);

    public void unsubscribeShare(ItemId var1, PersonId var2);

    public void migrateAllUsersRole();
}

