/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.business.judo;

import de.justsoftware.drive.common.file.model.PreviewId;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class JudoClient {
    public static final String JUST_DOCUMENT_PREVIEW_DELETION_TOPIC = "just.documents.preview.deletion";
    private static final Logger LOG = LogManager.getLogger(JudoClient.class);
    private final Producer<String, String> _producer;

    @Autowired
    public JudoClient(Producer<String, String> producer) {
        this._producer = producer;
    }

    public void queuePreviewDeletion(PreviewId previewId) {
        LOG.info("Queueing preview deletion for {}", (Object)previewId);
        this._producer.send(new ProducerRecord(JUST_DOCUMENT_PREVIEW_DELETION_TOPIC, (Object)previewId.toString(), null));
    }
}

