/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.business.file;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import de.justsoftware.drive.business.change.ChangeModificationService;
import de.justsoftware.drive.business.document.ByteSourceWithFilename;
import de.justsoftware.drive.business.document.DocumentTreeModificationService;
import de.justsoftware.drive.business.file.FileStorageService;
import de.justsoftware.drive.business.file.TempFileService;
import de.justsoftware.drive.business.file.VideoTeaserServiceImpl;
import de.justsoftware.drive.business.file.VirusScannerService;
import de.justsoftware.drive.business.folder.FolderService;
import de.justsoftware.drive.business.item.ItemWriteService;
import de.justsoftware.drive.common.change.model.ChangeBO;
import de.justsoftware.drive.common.document.model.VideoTeaserId;
import de.justsoftware.drive.common.file.model.FileInfo;
import de.justsoftware.drive.common.file.model.FileVersionBO;
import de.justsoftware.drive.common.file.model.TempFileBO;
import de.justsoftware.drive.common.file.model.TempFileId;
import de.justsoftware.drive.common.folder.model.FolderVersionBO;
import de.justsoftware.drive.common.item.model.ItemId;
import de.justsoftware.drive.common.person.model.PersonId;
import de.justsoftware.drive.common.tenant.model.TenantId;
import de.justsoftware.drive.filepersistence.common.StorageConnector;
import de.justsoftware.drive.persistence.file.TempFileCreateModel;
import de.justsoftware.drive.persistence.file.TempFileDAO;
import de.justsoftware.drive.persistence.item.ItemCreateModel;
import de.justsoftware.jdoc.rest.service.client.DocumentManager;
import io.micrometer.observation.annotation.Observed;
import java.time.Clock;
import java.time.Instant;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Observed
@Service
@ParametersAreNonnullByDefault
public class TempFileServiceImpl
implements TempFileService {
    private static final int DELETE_CHUNK_SIZE = 100;
    private final FileStorageService _fileStorageService;
    private final StorageConnector _storageConnector;
    private final TempFileDAO _tempFileDAO;
    private final DocumentTreeModificationService _documentTreeService;
    private final ChangeModificationService _changeModificationService;
    private final FolderService _folderService;
    private final ItemWriteService _itemWriteService;
    private final DocumentManager _documentManager;
    private final Clock _clock;
    private final VirusScannerService _virusScannerService;

    @Autowired
    public TempFileServiceImpl(TempFileDAO tempFileDAO, FileStorageService fileStorageService, StorageConnector storageConnector, DocumentTreeModificationService documentTreeModificationService, ChangeModificationService changeModificationService, FolderService folderService, ItemWriteService itemWriteService, DocumentManager documentManager, Clock clock, VirusScannerService virusScannerService) {
        this._tempFileDAO = tempFileDAO;
        this._fileStorageService = fileStorageService;
        this._storageConnector = storageConnector;
        this._documentTreeService = documentTreeModificationService;
        this._changeModificationService = changeModificationService;
        this._folderService = folderService;
        this._itemWriteService = itemWriteService;
        this._documentManager = documentManager;
        this._clock = clock;
        this._virusScannerService = virusScannerService;
    }

    public ImmutableMap<TempFileId, ByteSourceWithFilename> addTempFiles(Iterable<ByteSourceWithFilename> sources, PersonId owner, TenantId tenantId) {
        ImmutableList.Builder tempFiles = ImmutableList.builder();
        ImmutableMap.Builder resultBuilder = ImmutableMap.builder();
        try {
            for (ByteSourceWithFilename source : sources) {
                FileInfo info = this._fileStorageService.storeFile(source);
                TempFileCreateModel createModel = this._tempFileDAO.tempFileCreateModel().setFilesize(info.getFileSize()).setMimeType(info.getMimeType()).setName(info.getName()).setStorageId(info.getStorageId()).setOwner(owner).setUploadDate(this._clock.instant());
                tempFiles.add((Object)createModel);
                resultBuilder.put((Object)createModel.getId(), (Object)source);
            }
            this._tempFileDAO.insertTempFiles((Iterable)tempFiles.build());
            tempFiles.build().forEach(tempFile -> {
                if (tempFile.getStorageId() != null) {
                    this._virusScannerService.sendFileToVirusScan(tempFile.getStorageId(), tenantId);
                }
            });
        }
        catch (RuntimeException e) {
            this._fileStorageService.deleteFilesSilently((Set)FluentIterable.from((Iterable)tempFiles.build()).transform(TempFileCreateModel.TO_STORAGE_ID).toSet());
            throw e;
        }
        return resultBuilder.build();
    }

    @Nonnull
    public ImmutableMap<TempFileId, FileVersionBO> moveTempFilesToItem(Set<TempFileId> tempFileIds, ItemId targetItemId, PersonId owner, TenantId tenantId) {
        this._itemWriteService.createIfNotExists(new ItemCreateModel(targetItemId, "", tenantId));
        ChangeBO itemChange = this._changeModificationService.getOrCreateNewestChange(targetItemId, owner);
        FolderVersionBO folderVersionBO = (FolderVersionBO)this._folderService.getFolderVersionsByIds((Set)ImmutableSet.of((Object)itemChange.getId())).get((Object)itemChange.getId());
        ImmutableMap tempFiles = this.getTempFiles(tempFileIds);
        ImmutableMap saveResult = this._documentTreeService.addFileInfos(folderVersionBO.getDocumentId(), Iterables.transform((Iterable)tempFiles.values(), FileInfo::fromTempFileBO), owner, tenantId);
        this.deleteTempFileReferences(tempFileIds);
        return ImmutableMap.copyOf((Map)Maps.filterValues((Map)Maps.transformValues((Map)tempFiles, input -> (FileVersionBO)saveResult.get((Object)input.getStorageId())), (Predicate)Predicates.notNull()));
    }

    public void deleteTempFileReferences(Set<TempFileId> tempFileIds) {
        this._tempFileDAO.deleteTempFiles(tempFileIds);
    }

    @VisibleForTesting
    void deleteTempFiles(ImmutableMap<TempFileId, TempFileBO> tempFilesMap) {
        ImmutableSet storageIds = FluentIterable.from((Iterable)tempFilesMap.values()).transform(TempFileBO::getStorageId).toSet();
        ImmutableSet videoTeaserIds = FluentIterable.from((Iterable)tempFilesMap.values()).transform(TempFileBO::getVideoTeaserId).filter(Objects::nonNull).toSet();
        this._fileStorageService.deleteFilesSilently((Set)storageIds);
        this.cleanupVideoTeaserFiles((Set)videoTeaserIds);
        this._virusScannerService.deleteVirusScan((Set)storageIds);
        this._tempFileDAO.deleteTempFiles((Set)tempFilesMap.keySet());
    }

    public void deletePreviewSources() {
        this._documentManager.deletePreviewSources();
    }

    public ImmutableMap<TempFileId, TempFileBO> getTempFiles(Set<TempFileId> tempFileIds) {
        return this._tempFileDAO.getByIds(tempFileIds);
    }

    public void deleteTempfilesOlderThan(Instant date) {
        ImmutableMap files;
        while (!(files = this._tempFileDAO.getOlderThan(100, date)).isEmpty()) {
            this.deleteTempFiles(files);
        }
        return;
    }

    public void setVideoTeaser(TempFileBO tempFile, VideoTeaserId videoTeaserId) {
        this._tempFileDAO.setVideoTeaser(tempFile.getId(), videoTeaserId);
    }

    public void deleteVideoTeaser(TempFileId tempFileId) {
        this._tempFileDAO.deleteVideoTeaser(tempFileId);
    }

    private void cleanupVideoTeaserFiles(Set<VideoTeaserId> teaserIds) {
        teaserIds.forEach(teaserId -> this._storageConnector.delete(VideoTeaserServiceImpl.TEASER_BASE_PATH, teaserId.toString()));
    }
}

