/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.business.file;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.drive.business.file.FilePreviewService;
import de.justsoftware.drive.business.kafka.AbstractKafkaConsumer;
import de.justsoftware.drive.business.kafka.KafkaConfigurationProvider;
import de.justsoftware.drive.common.file.model.FilePreviewInfoBO;
import de.justsoftware.drive.common.file.model.FilePreviewStatus;
import de.justsoftware.drive.common.file.model.PreviewId;
import de.justsoftware.drive.persistence.transaction.TransactionSupport;
import de.justsoftware.judoclient.conversionstatus.ConversionStatusKafkaSerde;
import de.justsoftware.judoclient.model.ConversionStatus;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@ParametersAreNonnullByDefault
@Service
public class ConversionStatusConsumer
extends AbstractKafkaConsumer<String, ConversionStatus> {
    private static final Logger LOG = LoggerFactory.getLogger(ConversionStatusConsumer.class);
    private final FilePreviewService _filePreviewService;

    @Autowired
    public ConversionStatusConsumer(KafkaConfigurationProvider kafkaConfigurationProvider, TransactionSupport transactionSupport, FilePreviewService filePreviewService) {
        this(kafkaConfigurationProvider.modelConsumer("just.drive.ConversionStatusConsumer", ConversionStatusKafkaSerde.getInstance().deserializer()), transactionSupport, filePreviewService);
    }

    @VisibleForTesting
    ConversionStatusConsumer(@Nullable Consumer<String, ConversionStatus> consumer, TransactionSupport transactionSupport, FilePreviewService filePreviewService) {
        super(consumer, transactionSupport, "just.documents.conversion.status");
        this._filePreviewService = filePreviewService;
    }

    protected void process(ConsumerRecords<String, ConversionStatus> records, java.util.function.Consumer<Runnable> afterCommitCallbackConsumer) {
        records.forEach(arg_0 -> this.processRecord(arg_0));
    }

    private void processRecord(ConsumerRecord<String, ConversionStatus> record) {
        ConversionStatus conversionStatus = (ConversionStatus)record.value();
        PreviewId previewId = new PreviewId(conversionStatus.getId());
        FilePreviewInfoBO filePreviewInfoBO = (FilePreviewInfoBO)this._filePreviewService.getPreviewInfosByPreviewId((Set)ImmutableSet.of((Object)previewId)).get((Object)previewId);
        if (filePreviewInfoBO == null) {
            LOG.warn("Received update for preview ({}) that is no longer in the database.", (Object)previewId);
            return;
        }
        this._filePreviewService.updateStatus(filePreviewInfoBO, FilePreviewStatus.valueOf((String)conversionStatus.getTaskStatus().toString()));
    }
}

