/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.business.document;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Streams;
import de.justsoftware.drive.common.document.model.DocumentVersionBO;
import de.justsoftware.drive.common.document.model.DocumentVersionId;
import de.justsoftware.drive.common.file.model.FileVersionBO;
import de.justsoftware.drive.common.person.model.PersonId;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class DocumentVersionTree {
    public static final Function<DocumentVersionTree, FluentIterable<DocumentVersionTree>> GET_ALL_NODES = new /* Unavailable Anonymous Inner Class!! */;
    public static final Function<DocumentVersionTree, DocumentVersionBO> GET_DOCUMENT_VERSION = new /* Unavailable Anonymous Inner Class!! */;
    private final DocumentVersionBO _documentVersion;
    private final ImmutableSet<DocumentVersionTree> _children;

    public DocumentVersionTree(DocumentVersionBO documentVersion, ImmutableSet<DocumentVersionTree> children) {
        this._documentVersion = (DocumentVersionBO)Preconditions.checkNotNull((Object)documentVersion);
        this._children = children;
    }

    @Nonnull
    public DocumentVersionBO getDocumentVersion() {
        return this._documentVersion;
    }

    @Nonnull
    public ImmutableSet<DocumentVersionTree> getChildren() {
        return this._children;
    }

    @Nonnull
    public DocumentVersionId getId() {
        return this._documentVersion.getId();
    }

    @Nonnull
    public Optional<PersonId> getOwner() {
        ImmutableSet owners = (ImmutableSet)Streams.concat((Stream[])new Stream[]{Stream.of(this._documentVersion), this._children.stream().filter(Objects::nonNull).map(DocumentVersionTree::getDocumentVersion).filter(documentVersion -> documentVersion.getChangeId().equals((Object)this._documentVersion.getChangeId()))}).map(DocumentVersionBO::getOwner).collect(ImmutableSet.toImmutableSet());
        return owners.size() == 1 ? Optional.of((PersonId)owners.iterator().next()) : Optional.empty();
    }

    @Nonnull
    public FluentIterable<DocumentVersionTree> getAllNodes() {
        return FluentIterable.from((Iterable)this._children).transformAndConcat(GET_ALL_NODES).append((Object[])new DocumentVersionTree[]{this});
    }

    @Nonnull
    public FluentIterable<FileVersionBO> getAllFiles() {
        return this.getAllNodes().transform(GET_DOCUMENT_VERSION).filter(FileVersionBO.class);
    }

    public boolean equals(Object obj) {
        return this == obj || obj != null && obj instanceof DocumentVersionTree && ((DocumentVersionTree)obj).getId().equals((Object)this.getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }
}

