/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.business.context;

import com.google.common.eventbus.EventBus;
import de.justsoftware.jdoc.rest.service.client.DocumentManager;
import de.justsoftware.jdoc.service.RESTDocumentManagerImpl;
import de.justsoftware.jdoc.service.RestTemplateFactory;
import java.time.Clock;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ParametersAreNonnullByDefault
public class DriveBusinessConfiguration {
    @Bean
    @Nonnull
    public Clock clock() {
        return Clock.systemDefaultZone();
    }

    @Bean
    @Nonnull
    public EventBus eventBus() {
        return new EventBus("just-drive-event-bus");
    }

    @Bean
    @Nonnull
    public DocumentManager judoDocumentManager(@Value(value="${just.drive.judo.url}") String judoUrl, RestTemplateFactory restTemplateFactory) {
        return new RESTDocumentManagerImpl(judoUrl, restTemplateFactory);
    }

    @Bean
    @Nonnull
    public RestTemplateFactory restTemplateFactory() {
        return new RestTemplateFactory();
    }
}

